/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import no.finn.unleash.lang.Nullable;
import no.finn.unleash.repository.ToggleBootstrapProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleBootstrapFileProvider
implements ToggleBootstrapProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ToggleBootstrapFileProvider.class);
    final String path;

    public ToggleBootstrapFileProvider() {
        this.path = this.getBootstrapFile();
    }

    public ToggleBootstrapFileProvider(String path) {
        this.path = path;
    }

    @Override
    @Nullable
    public String read() {
        LOG.info("Trying to read feature toggles from bootstrap file found at {}", (Object)this.path);
        try {
            File file = this.getFile(this.path);
            if (file != null) {
                return this.fileAsString(file);
            }
        }
        catch (FileNotFoundException ioEx) {
            LOG.warn("Could not find file {}", (Object)this.path, (Object)ioEx);
        }
        catch (IOException ioEx) {
            LOG.warn("Generic IOException when trying to read file at {}", (Object)this.path, (Object)ioEx);
        }
        return null;
    }

    @Nullable
    private String getBootstrapFile() {
        String path = System.getenv("UNLEASH_BOOTSTRAP_FILE");
        if (path == null) {
            path = System.getProperty("UNLEASH_BOOTSTRAP_FILE");
        }
        return path;
    }

    private String fileAsString(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    @Nullable
    private File getFile(@Nullable String path) {
        if (path != null) {
            if (path.startsWith("classpath:")) {
                try {
                    URL resource = this.getClass().getClassLoader().getResource(path.substring("classpath:".length()));
                    if (resource != null) {
                        return Paths.get(resource.toURI()).toFile();
                    }
                    return null;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            return Paths.get(path, new String[0]).toFile();
        }
        return null;
    }
}

