/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.metric;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Set;
import no.finn.unleash.metric.ClientMetrics;
import no.finn.unleash.metric.ClientRegistration;
import no.finn.unleash.metric.MetricsBucket;
import no.finn.unleash.metric.UnleashMetricService;
import no.finn.unleash.metric.UnleashMetricsSender;
import no.finn.unleash.util.UnleashConfig;
import no.finn.unleash.util.UnleashScheduledExecutor;

public class UnleashMetricServiceImpl
implements UnleashMetricService {
    private final LocalDateTime started;
    private final UnleashConfig unleashConfig;
    private final long metricsInterval;
    private final UnleashMetricsSender unleashMetricsSender;
    private volatile MetricsBucket currentMetricsBucket = new MetricsBucket();

    public UnleashMetricServiceImpl(UnleashConfig unleashConfig, UnleashScheduledExecutor executor) {
        this(unleashConfig, new UnleashMetricsSender(unleashConfig), executor);
    }

    public UnleashMetricServiceImpl(UnleashConfig unleashConfig, UnleashMetricsSender unleashMetricsSender, UnleashScheduledExecutor executor) {
        this.started = LocalDateTime.now(ZoneId.of("UTC"));
        this.unleashConfig = unleashConfig;
        this.metricsInterval = unleashConfig.getSendMetricsInterval();
        this.unleashMetricsSender = unleashMetricsSender;
        executor.setInterval(this.sendMetrics(), this.metricsInterval, this.metricsInterval);
    }

    @Override
    public void register(Set<String> strategies) {
        ClientRegistration registration = new ClientRegistration(this.unleashConfig, this.started, strategies);
        this.unleashMetricsSender.registerClient(registration);
    }

    @Override
    public void count(String toggleName, boolean active) {
        this.currentMetricsBucket.registerCount(toggleName, active);
    }

    @Override
    public void countVariant(String toggleName, String variantName) {
        this.currentMetricsBucket.registerCount(toggleName, variantName);
    }

    private Runnable sendMetrics() {
        return () -> {
            MetricsBucket metricsBucket = this.currentMetricsBucket;
            this.currentMetricsBucket = new MetricsBucket();
            metricsBucket.end();
            ClientMetrics metrics = new ClientMetrics(this.unleashConfig, metricsBucket);
            this.unleashMetricsSender.sendMetrics(metrics);
        };
    }
}

