/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.UnleashException;
import no.finn.unleash.event.EventDispatcher;
import no.finn.unleash.event.UnleashEvent;
import no.finn.unleash.event.UnleashSubscriber;
import no.finn.unleash.repository.JsonToggleParser;
import no.finn.unleash.repository.ToggleBackupHandler;
import no.finn.unleash.repository.ToggleCollection;
import no.finn.unleash.util.UnleashConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ToggleBackupHandlerFile
implements ToggleBackupHandler {
    private static final Logger LOG = LogManager.getLogger(ToggleBackupHandlerFile.class);
    private final String backupFile;
    private final EventDispatcher eventDispatcher;

    public ToggleBackupHandlerFile(UnleashConfig config) {
        this.backupFile = config.getBackupFile();
        this.eventDispatcher = new EventDispatcher(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ToggleCollection read() {
        LOG.info("Unleash will try to load feature toggle states from temporary backup");
        try (FileReader reader = new FileReader(this.backupFile);){
            BufferedReader br = new BufferedReader(reader);
            ToggleCollection toggleCollection2 = JsonToggleParser.fromJson(br);
            this.eventDispatcher.dispatch(new ToggleBackupRead(toggleCollection2));
            ToggleCollection toggleCollection = toggleCollection2;
            return toggleCollection;
        }
        catch (FileNotFoundException e) {
            LOG.info(" Unleash could not find the backup-file '" + this.backupFile + "'. \nThis is expected behavior the first time unleash runs in a new environment.");
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            this.eventDispatcher.dispatch(new UnleashException("Failed to read backup file: " + this.backupFile, e));
        }
        List<FeatureToggle> emptyList = Collections.emptyList();
        return new ToggleCollection(emptyList);
    }

    @Override
    public void write(ToggleCollection toggleCollection) {
        try (FileWriter writer = new FileWriter(this.backupFile);){
            writer.write(JsonToggleParser.toJsonString(toggleCollection));
            this.eventDispatcher.dispatch(new ToggleBackupWritten(toggleCollection));
        }
        catch (IOException e) {
            this.eventDispatcher.dispatch(new UnleashException("Unleash was unable to backup feature toggles to file: " + this.backupFile, e));
        }
    }

    private static class ToggleBackupWritten
    implements UnleashEvent {
        private final ToggleCollection toggleCollection;

        private ToggleBackupWritten(ToggleCollection toggleCollection) {
            this.toggleCollection = toggleCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.togglesBackedUp(this.toggleCollection);
        }
    }

    private static class ToggleBackupRead
    implements UnleashEvent {
        private final ToggleCollection toggleCollection;

        private ToggleBackupRead(ToggleCollection toggleCollection) {
            this.toggleCollection = toggleCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.toggleBackupRestored(this.toggleCollection);
        }
    }
}

