/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.metric;

import java.time.LocalDateTime;
import java.util.Set;
import no.finn.unleash.event.UnleashEvent;
import no.finn.unleash.event.UnleashSubscriber;
import no.finn.unleash.util.UnleashConfig;

public class ClientRegistration
implements UnleashEvent {
    private final String appName;
    private final String instanceId;
    private final String sdkVersion;
    private final Set<String> strategies;
    private final LocalDateTime started;
    private final long interval;

    ClientRegistration(UnleashConfig config, LocalDateTime started, Set<String> strategies) {
        this.appName = config.getAppName();
        this.instanceId = config.getInstanceId();
        this.sdkVersion = config.getSdkVersion();
        this.started = started;
        this.strategies = strategies;
        this.interval = config.getSendMetricsInterval();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public Set<String> getStrategies() {
        return this.strategies;
    }

    public LocalDateTime getStarted() {
        return this.started;
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public void publishTo(UnleashSubscriber unleashSubscriber) {
        unleashSubscriber.clientRegistered(this);
    }

    public String toString() {
        return "client registration: appName=" + this.appName + " instanceId=" + this.instanceId + " sdkVersion=" + this.sdkVersion + " started=" + this.sdkVersion + " interval=" + this.sdkVersion + " strategies=" + this.strategies;
    }
}

