/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;

public class ValueInterval<T, I extends ChronoInterval<T>, V>
implements ChronoInterval<T>,
Serializable {
    private static final long serialVersionUID = -5542033333136556857L;
    private final I interval;
    private final V value;

    ValueInterval(I i, V v) {
        if (v == null) {
            throw new NullPointerException("Missing value.");
        }
        this.interval = i;
        this.value = v;
    }

    public V getValue() {
        return this.value;
    }

    public ValueInterval<T, I, V> withValue(V v) {
        return new ValueInterval<T, I, V>(this.interval, v);
    }

    public I getBoundaries() {
        return this.interval;
    }

    @Override
    public Boundary<T> getStart() {
        return this.interval.getStart();
    }

    @Override
    public Boundary<T> getEnd() {
        return this.interval.getEnd();
    }

    @Override
    public boolean isEmpty() {
        return this.interval.isEmpty();
    }

    @Override
    public boolean contains(T t) {
        return this.interval.contains(t);
    }

    @Override
    public boolean contains(ChronoInterval<T> chronoInterval) {
        return this.interval.contains(chronoInterval);
    }

    @Override
    public boolean isAfter(T t) {
        return this.interval.isAfter(t);
    }

    @Override
    public boolean isBefore(T t) {
        return this.interval.isBefore(t);
    }

    @Override
    public boolean isBefore(ChronoInterval<T> chronoInterval) {
        return this.interval.isBefore(chronoInterval);
    }

    @Override
    public boolean abuts(ChronoInterval<T> chronoInterval) {
        return this.interval.abuts(chronoInterval);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ValueInterval) {
            ValueInterval valueInterval = (ValueInterval)ValueInterval.class.cast(object);
            return this.interval.equals(valueInterval.interval) && this.value.equals(valueInterval.value);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.interval.hashCode() + 31 * this.value.hashCode();
    }

    public String toString() {
        return this.interval + "=>" + this.value;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        if (this.interval == null || this.value == null) {
            throw new StreamCorruptedException();
        }
    }
}

