/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.InfinityStyle;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.ValueInterval;

public abstract class IsoInterval<T extends Temporal<? super T>, I extends IsoInterval<T, I>>
implements ChronoInterval<T> {
    private final Boundary<T> start;
    private final Boundary<T> end;

    IsoInterval(Boundary<T> boundary, Boundary<T> boundary2) {
        if (Boundary.isAfter(boundary, boundary2)) {
            throw new IllegalArgumentException("Start after end: " + boundary + "/" + boundary2);
        }
        if (boundary2.isOpen() && boundary.isOpen() && Boundary.isSimultaneous(boundary, boundary2)) {
            if (boundary.isInfinite()) {
                throw new IllegalArgumentException("Infinite boundaries must not be equal.");
            }
            throw new IllegalArgumentException("Open start equal to open end: " + boundary + "/" + boundary2);
        }
        this.start = boundary;
        this.end = boundary2;
    }

    @Override
    public final Boundary<T> getStart() {
        return this.start;
    }

    @Override
    public final Boundary<T> getEnd() {
        return this.end;
    }

    public final <R> R get(ChronoFunction<ChronoInterval<T>, R> chronoFunction) {
        return chronoFunction.apply(this);
    }

    public I withStart(T t) {
        IntervalEdge intervalEdge = this.start.getEdge();
        Boundary<T> boundary = Boundary.of(intervalEdge, t);
        return (I)((IsoInterval)this.getFactory().between(boundary, this.end));
    }

    public I withEnd(T t) {
        IntervalEdge intervalEdge = this.end.getEdge();
        Boundary<T> boundary = Boundary.of(intervalEdge, t);
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    public I withStart(UnaryOperator<T> unaryOperator) {
        if (this.start.isInfinite()) {
            throw new IllegalStateException("Operator cannot be applied on an infinite interval boundary.");
        }
        IntervalEdge intervalEdge = this.start.getEdge();
        Boundary<Temporal> boundary = Boundary.of(intervalEdge, (Temporal)unaryOperator.apply((Temporal)this.start.getTemporal()));
        return (I)((IsoInterval)this.getFactory().between(boundary, this.end));
    }

    public I withEnd(UnaryOperator<T> unaryOperator) {
        if (this.end.isInfinite()) {
            throw new IllegalStateException("Operator cannot be applied on an infinite interval boundary.");
        }
        IntervalEdge intervalEdge = this.end.getEdge();
        Boundary<Temporal> boundary = Boundary.of(intervalEdge, (Temporal)unaryOperator.apply((Temporal)this.end.getTemporal()));
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    public I withOpenStart() {
        if (this.start.isOpen()) {
            return this.getContext();
        }
        Boundary<Temporal> boundary = Boundary.of(IntervalEdge.OPEN, (Temporal)this.start.getTemporal());
        return (I)((IsoInterval)this.getFactory().between(boundary, this.end));
    }

    public I withClosedStart() {
        if (this.start.isInfinite()) {
            throw new IllegalStateException("Infinite past cannot be included.");
        }
        if (this.start.isClosed()) {
            return this.getContext();
        }
        Boundary<Temporal> boundary = Boundary.of(IntervalEdge.CLOSED, (Temporal)this.start.getTemporal());
        return (I)((IsoInterval)this.getFactory().between(boundary, this.end));
    }

    public I withOpenEnd() {
        if (this.end.isOpen()) {
            return this.getContext();
        }
        Boundary<Temporal> boundary = Boundary.of(IntervalEdge.OPEN, (Temporal)this.end.getTemporal());
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    public I withClosedEnd() {
        if (this.end.isInfinite()) {
            throw new IllegalStateException("Infinite future cannot be included.");
        }
        if (this.end.isClosed()) {
            return this.getContext();
        }
        Boundary<Temporal> boundary = Boundary.of(IntervalEdge.CLOSED, (Temporal)this.end.getTemporal());
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    @Override
    public boolean isEmpty() {
        if (!this.isFinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.start.getTemporal();
        Temporal temporal2 = (Temporal)this.end.getTemporal();
        if (this.start.isOpen()) {
            if (this.end.isClosed()) {
                return temporal.isSimultaneous(temporal2);
            }
            temporal = this.getTimeLine().stepForward(temporal);
            if (temporal == null) {
                return false;
            }
        }
        return this.end.isOpen() && temporal.isSimultaneous(temporal2);
    }

    @Override
    public boolean isBefore(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (this.end.isOpen()) {
            return !temporal.isAfter(t);
        }
        return temporal.isBefore(t);
    }

    @Override
    public boolean isBefore(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        T t = IsoInterval.getClosedFiniteStart(chronoInterval.getStart(), this.getTimeLine());
        if (t == null) {
            return true;
        }
        if (this.end.isOpen()) {
            return !temporal.isAfter(t);
        }
        return temporal.isBefore(t);
    }

    @Override
    public boolean isAfter(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            return false;
        }
        return this.getClosedFiniteStart().isAfter(t);
    }

    @Override
    public boolean isAfter(ChronoInterval<T> chronoInterval) {
        return chronoInterval.isBefore(this);
    }

    @Override
    public boolean contains(T t) {
        boolean bl;
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            bl = true;
        } else if (this.start.isOpen()) {
            bl = ((Temporal)this.start.getTemporal()).isBefore(t);
        } else {
            boolean bl2 = bl = !((Temporal)this.start.getTemporal()).isAfter(t);
        }
        if (!bl) {
            return false;
        }
        boolean bl3 = this.end.isInfinite() ? true : (this.end.isOpen() ? ((Temporal)this.end.getTemporal()).isAfter(t) : !((Temporal)this.end.getTemporal()).isBefore(t));
        return bl3;
    }

    @Override
    public boolean contains(ChronoInterval<T> chronoInterval) {
        if (!chronoInterval.isFinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = IsoInterval.getClosedFiniteStart(chronoInterval.getStart(), this.getTimeLine());
        if (t2 == null || t != null && t.isAfter(t2)) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)chronoInterval.getEnd().getTemporal();
        if (temporal == null) {
            return true;
        }
        if (chronoInterval.getEnd().isOpen() && t2.isSimultaneous((Temporal)temporal2)) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (temporal == null || t2.isAfter((Temporal)temporal)) {
                return false;
            }
        } else if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (chronoInterval.getEnd().isOpen()) {
                temporal2 = this.getTimeLine().stepBackwards(temporal2);
            }
            if (temporal == null || temporal2 == null || temporal.isBefore(temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed() && (temporal = this.getTimeLine().stepForward(temporal)) == null) {
                return true;
            }
            if (chronoInterval.getEnd().isClosed() && (temporal2 = this.getTimeLine().stepForward(temporal2)) == null) {
                return false;
            }
            return !temporal.isBefore(temporal2);
        }
        return true;
    }

    public I collapse() {
        if (this.start.isInfinite()) {
            throw new IllegalStateException("An interval with infinite past cannot be collapsed.");
        }
        T t = this.getClosedFiniteStart();
        Boundary<T> boundary = Boundary.ofClosed(t);
        Boundary<T> boundary2 = Boundary.ofOpen(t);
        return (I)((IsoInterval)this.getFactory().between(boundary, boundary2));
    }

    public I toCanonical() {
        Temporal temporal;
        boolean bl = false;
        Boundary<Object> boundary = this.start;
        Boundary<Object> boundary2 = this.end;
        if (!this.start.isInfinite() && this.start.isOpen()) {
            temporal = this.getTimeLine().stepForward((Temporal)this.start.getTemporal());
            if (temporal == null) {
                throw new IllegalStateException("Cannot canonicalize this interval: " + this);
            }
            boundary = Boundary.ofClosed(temporal);
            bl = true;
        }
        if (!this.end.isInfinite()) {
            if (this.getFactory().isCalendrical()) {
                if (this.end.isOpen()) {
                    temporal = this.getTimeLine().stepBackwards((Temporal)this.end.getTemporal());
                    if (temporal == null) {
                        throw new IllegalStateException("Cannot canonicalize this interval: " + this);
                    }
                    boundary2 = Boundary.ofClosed(temporal);
                    bl = true;
                }
            } else if (this.end.isClosed()) {
                temporal = this.getTimeLine().stepForward((Temporal)this.end.getTemporal());
                if (temporal == null) {
                    throw new IllegalStateException("Cannot canonicalize this interval: " + this);
                }
                boundary2 = Boundary.ofOpen(temporal);
                bl = true;
            }
        }
        return (I)(bl ? (IsoInterval)this.getFactory().between(boundary, boundary2) : this.getContext());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IsoInterval) {
            IsoInterval isoInterval = (IsoInterval)IsoInterval.class.cast(object);
            return this.start.equals(isoInterval.start) && this.end.equals(isoInterval.end) && this.getTimeLine().equals(isoInterval.getTimeLine());
        }
        return false;
    }

    public final int hashCode() {
        return 17 * this.start.hashCode() + 37 * this.end.hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.start.isOpen() ? (char)'(' : '[');
        stringBuilder.append((Object)(this.start.isInfinite() ? "-\u221e" : this.start.getTemporal()));
        stringBuilder.append('/');
        stringBuilder.append((Object)(this.end.isInfinite() ? "+\u221e" : this.end.getTemporal()));
        stringBuilder.append(this.end.isOpen() ? (char)')' : ']');
        return stringBuilder.toString();
    }

    public String print(ChronoPrinter<T> chronoPrinter) {
        return this.print(chronoPrinter, IsoInterval.getIntervalPattern(chronoPrinter));
    }

    public String print(ChronoPrinter<T> chronoPrinter, String string) {
        I i = this.toCanonical();
        AttributeQuery attributeQuery = chronoPrinter.getAttributes();
        StringBuilder stringBuilder = new StringBuilder(32);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '{' && n + 2 < n2 && string.charAt(n + 2) == '}') {
                char c2 = string.charAt(n + 1);
                if (c2 == '0') {
                    if (((IsoInterval)i).getStart().isInfinite()) {
                        stringBuilder.append("-\u221e");
                    } else {
                        chronoPrinter.print((Temporal)((IsoInterval)i).getStart().getTemporal(), stringBuilder, attributeQuery);
                    }
                    n += 3;
                    continue;
                }
                if (c2 == '1') {
                    if (((IsoInterval)i).getEnd().isInfinite()) {
                        stringBuilder.append("+\u221e");
                    } else {
                        chronoPrinter.print((Temporal)((IsoInterval)i).getEnd().getTemporal(), stringBuilder, attributeQuery);
                    }
                    n += 3;
                    continue;
                }
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    public String print(ChronoPrinter<T> chronoPrinter, BracketPolicy bracketPolicy) {
        try {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.print(chronoPrinter, '/', chronoPrinter, bracketPolicy, InfinityStyle.SYMBOL, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void print(ChronoPrinter<T> chronoPrinter, char c, ChronoPrinter<T> chronoPrinter2, BracketPolicy bracketPolicy, InfinityStyle infinityStyle, Appendable appendable) throws IOException {
        I i = this.getContext();
        if (bracketPolicy == BracketPolicy.SHOW_NEVER) {
            i = this.toCanonical();
        }
        AttributeQuery attributeQuery = chronoPrinter.getAttributes();
        boolean bl = bracketPolicy.display(this);
        StringBuilder stringBuilder = new StringBuilder(50);
        if (bl) {
            stringBuilder.append(((IsoInterval)i).getStart().isOpen() ? (char)'(' : '[');
        }
        if (((IsoInterval)i).getStart().isInfinite()) {
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, this.getFactory().getTimeLine()));
        } else {
            chronoPrinter.print((Temporal)((IsoInterval)i).getStart().getTemporal(), stringBuilder, attributeQuery);
        }
        stringBuilder.append(c);
        if (((IsoInterval)i).getEnd().isInfinite()) {
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, this.getFactory().getTimeLine()));
        } else {
            chronoPrinter2.print((Temporal)((IsoInterval)i).getEnd().getTemporal(), stringBuilder, attributeQuery);
        }
        if (bl) {
            stringBuilder.append(((IsoInterval)i).getEnd().isOpen() ? (char)')' : ']');
        }
        appendable.append(stringBuilder.toString());
    }

    public boolean equivalentTo(I i) {
        if (this.getContext() == i) {
            return true;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t == null) {
            if (t2 != null) {
                return false;
            }
        } else {
            if (t2 == null) {
                return false;
            }
            if (!t.isSimultaneous(t2)) {
                return false;
            }
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (temporal == null) {
            return temporal2 == null;
        }
        if (temporal2 == null) {
            return false;
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = this.getTimeLine().stepBackwards(temporal2);
            }
        } else {
            if (this.end.isClosed()) {
                temporal = this.getTimeLine().stepForward(temporal);
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = this.getTimeLine().stepForward(temporal2);
            }
        }
        if (temporal == null) {
            return temporal2 == null;
        }
        if (temporal2 == null) {
            return false;
        }
        return temporal.isSimultaneous(temporal2);
    }

    public boolean precedes(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (this.end.isClosed() && (temporal = this.getTimeLine().stepForward(temporal)) == null) {
            return false;
        }
        return temporal.isBefore(((IsoInterval)i).getClosedFiniteStart());
    }

    public boolean precededBy(I i) {
        return ((IsoInterval)i).precedes(this.getContext());
    }

    public boolean meets(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (this.end.isClosed() && (temporal = this.getTimeLine().stepForward(temporal)) == null) {
            return false;
        }
        if (temporal.isSimultaneous(((IsoInterval)i).getClosedFiniteStart())) {
            T t = this.getClosedFiniteStart();
            Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
            if (t == null || temporal2 == null) {
                return true;
            }
            return t.isBefore((Temporal)temporal2);
        }
        return false;
    }

    public boolean metBy(I i) {
        return ((IsoInterval)i).meets(this.getContext());
    }

    public boolean overlaps(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t != null && !t.isBefore(t2)) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (temporal == null || temporal.isBefore(t2)) {
                return false;
            }
            if (temporal2 == null) {
                return true;
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = this.getTimeLine().stepBackwards(temporal2);
            }
        } else {
            if (this.end.isClosed() && (temporal = this.getTimeLine().stepForward(temporal)) == null) {
                return temporal2 == null;
            }
            if (!temporal.isAfter(t2)) {
                return false;
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = this.getTimeLine().stepForward(temporal2);
            }
        }
        return temporal2 == null || temporal.isBefore(temporal2);
    }

    public boolean overlappedBy(I i) {
        return ((IsoInterval)i).overlaps(this.getContext());
    }

    public boolean finishes(I i) {
        boolean bl;
        if (this.start.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        boolean bl2 = bl = this.end.isOpen() && temporal != null && t.isSimultaneous((Temporal)temporal);
        if (bl || t2 != null && !t2.isBefore(t)) {
            return false;
        }
        if (temporal2 == null) {
            return temporal == null;
        }
        if (temporal == null) {
            return false;
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = this.getTimeLine().stepBackwards(temporal2);
            }
            if (temporal == null || temporal2 == null || t.isAfter((Temporal)temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed()) {
                temporal = this.getTimeLine().stepForward(temporal);
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = this.getTimeLine().stepForward(temporal2);
            }
            if (temporal2 != null && !t.isBefore((Temporal)temporal2)) {
                return false;
            }
            if (temporal == null) {
                return temporal2 == null;
            }
            if (temporal2 == null) {
                return false;
            }
        }
        return temporal.isSimultaneous(temporal2);
    }

    public boolean finishedBy(I i) {
        return ((IsoInterval)i).finishes(this.getContext());
    }

    public boolean starts(I i) {
        if (this.end.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t2 == null ? t != null : t == null || !t.isSimultaneous(t2)) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (this.end.isOpen() && t != null && t.isSimultaneous((Temporal)temporal)) {
            return true;
        }
        if (temporal2 == null) {
            if (this.end.isClosed()) {
                return true;
            }
            if (t2 == null) {
                return this.getTimeLine().stepBackwards(temporal) != null;
            }
            return temporal.isAfter(t2);
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = this.getTimeLine().stepBackwards(temporal2);
            }
            if (temporal == null || temporal2 == null || !temporal.isBefore(temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed() && (temporal = this.getTimeLine().stepForward(temporal)) == null) {
                return false;
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = this.getTimeLine().stepForward(temporal2);
            }
            if (temporal2 != null && !temporal.isBefore(temporal2)) {
                return false;
            }
        }
        if (this.end.isClosed()) {
            return true;
        }
        if (t2 == null) {
            return this.getTimeLine().stepBackwards(temporal) != null;
        }
        return temporal.isAfter(t2);
    }

    public boolean startedBy(I i) {
        return ((IsoInterval)i).starts(this.getContext());
    }

    public boolean encloses(I i) {
        if (!i.isFinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t != null && !t.isBefore(t2)) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (temporal == null) {
            return true;
        }
        if (((IsoInterval)i).getEnd().isOpen() && t2.isSimultaneous((Temporal)temporal2)) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (temporal == null || t2.isAfter((Temporal)temporal)) {
                return false;
            }
        } else if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = this.getTimeLine().stepBackwards(temporal2);
            }
            if (temporal == null || temporal2 == null || !temporal.isAfter(temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed()) {
                temporal = this.getTimeLine().stepForward(temporal);
            }
            if (((IsoInterval)i).getEnd().isClosed() && (temporal2 = this.getTimeLine().stepForward(temporal2)) == null) {
                return false;
            }
            if (temporal != null && !temporal.isAfter(temporal2)) {
                return false;
            }
        }
        return true;
    }

    public boolean enclosedBy(I i) {
        return ((IsoInterval)i).encloses(this.getContext());
    }

    @Override
    public boolean intersects(ChronoInterval<T> chronoInterval) {
        boolean bl;
        boolean bl2;
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        boolean bl3 = bl2 = this.getStart().isInfinite() || chronoInterval.getEnd().isInfinite();
        if (!bl2) {
            T t = this.getClosedFiniteStart();
            if (chronoInterval.getEnd().isOpen()) {
                bl2 = t.isBefore(chronoInterval.getEnd().getTemporal());
            } else {
                boolean bl4 = bl2 = !t.isAfter(chronoInterval.getEnd().getTemporal());
            }
        }
        if (!bl2) {
            return false;
        }
        boolean bl5 = bl = chronoInterval.getStart().isInfinite() || this.getEnd().isInfinite();
        if (!bl) {
            T t = IsoInterval.getClosedFiniteStart(chronoInterval.getStart(), this.getTimeLine());
            bl = this.getEnd().isOpen() ? t.isBefore(this.getEnd().getTemporal()) : !t.isAfter(this.getEnd().getTemporal());
        }
        return bl;
    }

    public Optional<I> findIntersection(ChronoInterval<T> chronoInterval) {
        Boundary<Object> boundary;
        Temporal temporal;
        Object object;
        Boundary<Object> boundary2;
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return Optional.empty();
        }
        if (this.start.isInfinite()) {
            boundary2 = chronoInterval.getStart();
        } else if (chronoInterval.getStart().isInfinite()) {
            boundary2 = this.start;
        } else {
            object = this.getClosedFiniteStart();
            temporal = (Temporal)chronoInterval.getStart().getTemporal();
            if (chronoInterval.getStart().isOpen()) {
                temporal = this.getTimeLine().stepForward(temporal);
            }
            if (object == null || temporal == null) {
                return Optional.empty();
            }
            Boundary<Object> boundary3 = boundary2 = object.isBefore((Temporal)temporal) ? Boundary.ofClosed(temporal) : Boundary.ofClosed(object);
        }
        if (this.end.isInfinite()) {
            boundary = chronoInterval.getEnd();
        } else if (chronoInterval.getEnd().isInfinite()) {
            boundary = this.end;
        } else if (this.getFactory().isCalendrical()) {
            object = this.getClosedFiniteEnd();
            temporal = (Temporal)chronoInterval.getEnd().getTemporal();
            if (chronoInterval.getEnd().isOpen()) {
                temporal = this.getTimeLine().stepBackwards(temporal);
            }
            if (object == null || temporal == null) {
                return Optional.empty();
            }
            boundary = object.isBefore(temporal) ? Boundary.ofClosed(object) : Boundary.ofClosed(temporal);
        } else {
            object = this.getOpenFiniteEnd();
            temporal = (Temporal)chronoInterval.getEnd().getTemporal();
            if (chronoInterval.getEnd().isClosed()) {
                temporal = this.getTimeLine().stepForward(temporal);
            }
            if (object == null) {
                boundary = temporal == null ? Boundary.infiniteFuture() : Boundary.ofOpen(temporal);
            } else if (temporal == null) {
                boundary = Boundary.ofOpen(object);
            } else {
                Boundary<Object> boundary4 = boundary = object.isBefore(temporal) ? Boundary.ofOpen(object) : Boundary.ofOpen(temporal);
            }
        }
        if (Boundary.isAfter(boundary2, boundary)) {
            return Optional.empty();
        }
        object = (IsoInterval)this.getFactory().between(boundary2, boundary);
        return ((IsoInterval)object).isEmpty() ? Optional.empty() : Optional.of(object);
    }

    @Override
    public boolean abuts(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = IsoInterval.getClosedFiniteStart(chronoInterval.getStart(), this.getTimeLine());
        T t3 = this.getOpenFiniteEnd();
        T t4 = IsoInterval.getOpenFiniteEnd(chronoInterval.getEnd(), this.getTimeLine());
        if (t3 == null || t2 == null) {
            return t != null && t4 != null && t.isSimultaneous(t4);
        }
        if (t == null || t4 == null) {
            return t3.isSimultaneous(t2);
        }
        return t3.isSimultaneous(t2) ^ t.isSimultaneous(t4);
    }

    public <V> ValueInterval<T, I, V> withValue(V v) {
        return new ValueInterval(this.getContext(), v);
    }

    abstract IntervalFactory<T, I> getFactory();

    T getTemporalOfClosedStart() {
        Temporal temporal = (Temporal)this.start.getTemporal();
        if (temporal == null) {
            throw new UnsupportedOperationException("An infinite interval has no finite duration.");
        }
        if (this.start.isOpen()) {
            return (T)this.getTimeLine().stepForward(temporal);
        }
        return (T)temporal;
    }

    T getTemporalOfOpenEnd() {
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (temporal == null) {
            throw new UnsupportedOperationException("An infinite interval has no finite duration.");
        }
        if (this.end.isClosed()) {
            return (T)this.getTimeLine().stepForward(temporal);
        }
        return (T)temporal;
    }

    static String getIntervalPattern(ChronoPrinter<?> chronoPrinter) {
        AttributeQuery attributeQuery = chronoPrinter.getAttributes();
        if (attributeQuery.contains(Attributes.LANGUAGE)) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE);
            return CalendarText.patternForInterval(locale);
        }
        return "{0}/{1}";
    }

    static String getIntervalPattern(ChronoParser<?> chronoParser) {
        AttributeQuery attributeQuery = chronoParser.getAttributes();
        if (attributeQuery.contains(Attributes.LANGUAGE)) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE);
            return CalendarText.patternForInterval(locale);
        }
        return "{0}/{1}";
    }

    abstract I getContext();

    T getClosedFiniteStart() {
        Temporal temporal = (Temporal)this.start.getTemporal();
        if (temporal != null && this.start.isOpen()) {
            return (T)this.getTimeLine().stepForward(temporal);
        }
        return (T)temporal;
    }

    T getClosedFiniteEnd() {
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (temporal != null && this.end.isOpen()) {
            return (T)this.getTimeLine().stepBackwards(temporal);
        }
        return (T)temporal;
    }

    private T getOpenFiniteEnd() {
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (temporal != null && this.end.isClosed()) {
            return (T)this.getTimeLine().stepForward(temporal);
        }
        return (T)temporal;
    }

    private static <T extends Temporal<? super T>> T getClosedFiniteStart(Boundary<T> boundary, TimeLine<T> timeLine) {
        Temporal temporal = (Temporal)boundary.getTemporal();
        if (temporal != null && boundary.isOpen()) {
            return (T)timeLine.stepForward(temporal);
        }
        return (T)temporal;
    }

    private static <T extends Temporal<? super T>> T getOpenFiniteEnd(Boundary<T> boundary, TimeLine<T> timeLine) {
        Temporal temporal = (Temporal)boundary.getTemporal();
        if (temporal != null && boundary.isClosed()) {
            return (T)timeLine.stepForward(temporal);
        }
        return (T)temporal;
    }

    private TimeLine<T> getTimeLine() {
        return this.getFactory().getTimeLine();
    }
}

