/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.time4j.PlainDate;
import net.time4j.engine.EpochDays;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

public final class EraPreference {
    static final EraPreference DEFAULT = new EraPreference();
    private static final HistoricDate AD1 = HistoricDate.of(HistoricEra.AD, 1, 1, 1);
    private static final HistoricDate BC38 = HistoricDate.of(HistoricEra.BC, 38, 1, 1);
    private static final int NON_DEFAULT_MARKER = 127;
    private static final PlainDate PROTOTYPE = PlainDate.of(2000, 1);
    private final HistoricEra era;
    private final PlainDate start;
    private final PlainDate end;

    private EraPreference() {
        this.era = null;
        this.start = (PlainDate)PlainDate.axis().getMinimum();
        this.end = (PlainDate)PlainDate.axis().getMaximum();
    }

    private EraPreference(HistoricEra historicEra, PlainDate plainDate, PlainDate plainDate2) {
        if (historicEra.compareTo(HistoricEra.AD) <= 0) {
            throw new UnsupportedOperationException(historicEra.name());
        }
        if (plainDate2.isBefore(plainDate)) {
            throw new IllegalArgumentException("End before start: " + plainDate + "/" + plainDate2);
        }
        this.era = historicEra;
        this.start = plainDate;
        this.end = plainDate2;
    }

    public static EraPreference hispanicUntil(PlainDate plainDate) {
        return EraPreference.hispanicBetween((PlainDate)PlainDate.axis().getMinimum(), plainDate);
    }

    public static EraPreference hispanicBetween(PlainDate plainDate, PlainDate plainDate2) {
        return new EraPreference(HistoricEra.HISPANIC, plainDate, plainDate2);
    }

    public static EraPreference byzantineUntil(PlainDate plainDate) {
        return EraPreference.byzantineBetween((PlainDate)PlainDate.axis().getMinimum(), plainDate);
    }

    public static EraPreference byzantineBetween(PlainDate plainDate, PlainDate plainDate2) {
        return new EraPreference(HistoricEra.BYZANTINE, plainDate, plainDate2);
    }

    public static EraPreference abUrbeCondita() {
        return EraPreference.abUrbeConditaUntil((PlainDate)PlainDate.axis().getMaximum());
    }

    public static EraPreference abUrbeConditaUntil(PlainDate plainDate) {
        return EraPreference.abUrbeConditaBetween((PlainDate)PlainDate.axis().getMinimum(), plainDate);
    }

    public static EraPreference abUrbeConditaBetween(PlainDate plainDate, PlainDate plainDate2) {
        return new EraPreference(HistoricEra.AB_URBE_CONDITA, plainDate, plainDate2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EraPreference) {
            EraPreference eraPreference = (EraPreference)object;
            if (this == DEFAULT) {
                return eraPreference == DEFAULT;
            }
            return this.era == eraPreference.era && this.start.equals(eraPreference.start) && this.end.equals(eraPreference.end);
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.era.hashCode() + 31 * this.start.hashCode() + 37 * this.end.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this == DEFAULT) {
            stringBuilder.append("default");
        } else {
            stringBuilder.append("era->");
            stringBuilder.append(this.era);
            stringBuilder.append(",start->");
            stringBuilder.append(this.start);
            stringBuilder.append(",end->");
            stringBuilder.append(this.end);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    HistoricEra getPreferredEra(HistoricDate historicDate, PlainDate plainDate) {
        if (this.era == null || plainDate.isBefore(this.start) || plainDate.isAfter(this.end)) {
            return historicDate.compareTo(AD1) < 0 ? HistoricEra.BC : HistoricEra.AD;
        }
        if (this.era == HistoricEra.HISPANIC && historicDate.compareTo(BC38) < 0) {
            return HistoricEra.BC;
        }
        return this.era;
    }

    void writeToStream(DataOutput dataOutput) throws IOException {
        if (this == DEFAULT) {
            dataOutput.writeByte(0);
        } else {
            dataOutput.writeByte(127);
            dataOutput.writeUTF(this.era.name());
            dataOutput.writeLong(this.start.get(EpochDays.MODIFIED_JULIAN_DATE));
            dataOutput.writeLong(this.end.get(EpochDays.MODIFIED_JULIAN_DATE));
        }
    }

    static EraPreference readFromStream(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        if (by == 127) {
            HistoricEra historicEra = HistoricEra.valueOf(dataInput.readUTF());
            long l = dataInput.readLong();
            long l2 = dataInput.readLong();
            return new EraPreference(historicEra, (PlainDate)PROTOTYPE.with(EpochDays.MODIFIED_JULIAN_DATE, l), (PlainDate)PROTOTYPE.with(EpochDays.MODIFIED_JULIAN_DATE, l2));
        }
        return DEFAULT;
    }
}

