/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.function.LongFunction;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.calendar.IndianMonth;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.MoonPhase;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.hindu.AryaSiddhanta;
import net.time4j.calendar.hindu.HinduCS;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduRule;
import net.time4j.calendar.hindu.SPX;
import net.time4j.engine.EpochDays;
import net.time4j.engine.VariantSource;
import net.time4j.scale.TimeScale;

public final class HinduVariant
implements VariantSource,
Serializable {
    static final GeoLocation UJJAIN = GeoLocation.of(23.15, 75.76833333333333);
    private static final double U_OFFSET = 18184.4;
    private static final HinduRule[] RULES = HinduRule.values();
    private static final int TYPE_OLD_SOLAR = -1;
    private static final int TYPE_OLD_LUNAR = -2;
    static final HinduVariant VAR_OLD_SOLAR = new HinduVariant(AryaSiddhanta.SOLAR);
    static final HinduVariant VAR_OLD_LUNAR = new HinduVariant(AryaSiddhanta.LUNAR);
    private final transient int type;
    private final transient HinduEra defaultEra;
    private final transient boolean elapsedMode;
    private final transient double depressionAngle;
    private final transient GeoLocation location;

    HinduVariant(HinduRule hinduRule, HinduEra hinduEra) {
        this(hinduRule.ordinal(), hinduEra, HinduVariant.useStandardElapsedMode(hinduEra, hinduRule), Double.NaN, UJJAIN);
    }

    private HinduVariant(AryaSiddhanta aryaSiddhanta) {
        this(aryaSiddhanta == AryaSiddhanta.SOLAR ? -1 : -2, HinduEra.KALI_YUGA, true, Double.NaN, UJJAIN);
    }

    private HinduVariant(int n, HinduEra hinduEra, boolean bl, double d, GeoLocation geoLocation) {
        if (n < -2 || n >= HinduRule.values().length) {
            throw new IllegalArgumentException("Undefined Hindu rule.");
        }
        if (hinduEra == null) {
            throw new NullPointerException("Missing default Hindu era.");
        }
        if (geoLocation == null) {
            throw new NullPointerException("Missing geographical location.");
        }
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("Infinite depression angle.");
        }
        if (!Double.isNaN(d) && Math.abs(d) > 10.0) {
            throw new IllegalArgumentException("Depression angle is too big: " + d);
        }
        this.type = n;
        this.defaultEra = hinduEra;
        this.elapsedMode = bl;
        this.depressionAngle = d;
        this.location = geoLocation;
    }

    public static HinduVariant from(String string) {
        if (string.startsWith("AryaSiddhanta@")) {
            try {
                AryaSiddhanta aryaSiddhanta = AryaSiddhanta.valueOf(string.substring("AryaSiddhanta@".length()));
                return aryaSiddhanta == AryaSiddhanta.SOLAR ? VAR_OLD_SOLAR : VAR_OLD_LUNAR;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("Invalid variant: " + string, indexOutOfBoundsException);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        HinduEra hinduEra = null;
        boolean bl = true;
        double d = Double.NaN;
        double d2 = UJJAIN.getLatitude();
        double d3 = UJJAIN.getLongitude();
        int n3 = UJJAIN.getAltitude();
        boolean bl2 = true;
        block13: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (++n) {
                case 1: {
                    n2 = Integer.valueOf(string2);
                    continue block13;
                }
                case 2: {
                    hinduEra = HinduEra.valueOf(string2);
                    continue block13;
                }
                case 3: {
                    bl = string2.equals("elapsed");
                    continue block13;
                }
                case 4: {
                    if (string2.equals("oldstyle") || string2.equals("alt") || string2.equals("std")) continue block13;
                    d = Double.valueOf(string2);
                    continue block13;
                }
                case 5: {
                    d2 = Double.valueOf(string2);
                    bl2 = d2 == UJJAIN.getLatitude();
                    continue block13;
                }
                case 6: {
                    d3 = Double.valueOf(string2);
                    bl2 = bl2 && d3 == UJJAIN.getLongitude();
                    continue block13;
                }
                case 7: {
                    n3 = Integer.valueOf(string2);
                    bl2 = bl2 && n3 == 0;
                    continue block13;
                }
            }
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
        try {
            return new HinduVariant(n2, hinduEra, bl, d, bl2 ? UJJAIN : GeoLocation.of(d2, d3, n3));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
    }

    public HinduEra getDefaultEra() {
        return this.defaultEra;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public boolean isSolar() {
        return !this.isLunisolar();
    }

    public boolean isLunisolar() {
        return this.isAmanta() || this.isPurnimanta();
    }

    public boolean isAmanta() {
        if (this.type == -2) {
            return true;
        }
        return this.type >= HinduRule.AMANTA.ordinal() && this.type < HinduRule.PURNIMANTA.ordinal();
    }

    public boolean isPurnimanta() {
        return this.type == HinduRule.PURNIMANTA.ordinal();
    }

    public boolean isOld() {
        return this.type < 0;
    }

    public boolean isUsingElapsedYears() {
        return this.elapsedMode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HinduVariant) {
            HinduVariant hinduVariant = (HinduVariant)object;
            return this.type == hinduVariant.type && this.defaultEra == hinduVariant.defaultEra && this.elapsedMode == hinduVariant.elapsedMode && HinduVariant.equals(this.depressionAngle, hinduVariant.depressionAngle) && this.location.getLatitude() == hinduVariant.location.getLatitude() && this.location.getLongitude() == hinduVariant.location.getLongitude() && this.location.getAltitude() == hinduVariant.location.getAltitude();
        }
        return false;
    }

    public int hashCode() {
        return this.type + 17 * this.defaultEra.hashCode() + (this.elapsedMode ? 1 : 0) + (Double.isNaN(this.depressionAngle) ? 100 : (int)this.depressionAngle * 100);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hindu-variant=[");
        switch (this.type) {
            case -1: {
                stringBuilder.append("OLD-SOLAR");
                break;
            }
            case -2: {
                stringBuilder.append("OLD-LUNAR");
                break;
            }
            default: {
                stringBuilder.append(this.getRule().name());
            }
        }
        if (!this.isOld()) {
            stringBuilder.append("|default-era=");
            stringBuilder.append(this.defaultEra.name());
            stringBuilder.append('|');
            stringBuilder.append(this.elapsedMode ? "elapsed-year-mode" : "current-year-mode");
            if (!Double.isNaN(this.depressionAngle)) {
                stringBuilder.append("|depression-angle=");
                stringBuilder.append(this.depressionAngle);
            }
            if (this.location != UJJAIN) {
                stringBuilder.append("|lat=");
                stringBuilder.append(this.location.getLatitude());
                stringBuilder.append(",lng=");
                stringBuilder.append(this.location.getLongitude());
                int n = this.location.getAltitude();
                if (n != 0) {
                    stringBuilder.append(",alt=");
                    stringBuilder.append(n);
                }
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getVariant() {
        if (this.isOld()) {
            AryaSiddhanta aryaSiddhanta = this.type == -1 ? AryaSiddhanta.SOLAR : AryaSiddhanta.LUNAR;
            return "AryaSiddhanta@" + aryaSiddhanta.name();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type);
        stringBuilder.append('|');
        stringBuilder.append(this.defaultEra.name());
        stringBuilder.append('|');
        stringBuilder.append(this.elapsedMode ? "elapsed" : "current");
        stringBuilder.append('|');
        stringBuilder.append(Double.isNaN(this.depressionAngle) ? "oldstyle" : Double.valueOf(this.depressionAngle));
        if (this.location != UJJAIN) {
            stringBuilder.append('|');
            stringBuilder.append(this.location.getLatitude());
            stringBuilder.append('|');
            stringBuilder.append(this.location.getLongitude());
            int n = this.location.getAltitude();
            if (n != 0) {
                stringBuilder.append('|');
                stringBuilder.append(n);
            }
        }
        return stringBuilder.toString();
    }

    public HinduVariant with(HinduEra hinduEra) {
        if (this.isOld() || this.defaultEra.equals(hinduEra)) {
            return this;
        }
        return new HinduVariant(this.type, hinduEra, this.elapsedMode, this.depressionAngle, this.location);
    }

    public HinduVariant withElapsedYears() {
        if (this.isOld() || this.elapsedMode) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, true, this.depressionAngle, this.location);
    }

    public HinduVariant withCurrentYears() {
        if (this.isOld() || !this.elapsedMode) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, false, this.depressionAngle, this.location);
    }

    @Deprecated
    public HinduVariant withAlternativeHinduSunrise() {
        return this;
    }

    public HinduVariant withModernAstronomy(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("Depression angle must be a finite number.");
        }
        if (this.isOld()) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, this.elapsedMode, d, this.location);
    }

    public HinduVariant withAlternativeLocation(GeoLocation geoLocation) {
        if (Math.abs(geoLocation.getLatitude()) > 60.0) {
            throw new IllegalArgumentException("Latitudes beyond +/-60\u00b0 degrees not supported.");
        }
        if (this.isOld()) {
            return this;
        }
        if (geoLocation.getLatitude() == this.location.getLatitude() && geoLocation.getLongitude() == this.location.getLongitude() && geoLocation.getAltitude() == this.location.getAltitude()) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, this.elapsedMode, this.depressionAngle, geoLocation);
    }

    boolean prefersRasiNames() {
        return this.type == HinduRule.MADRAS.ordinal() || this.type == HinduRule.MALAYALI.ordinal();
    }

    HinduCS getCalendarSystem() {
        switch (this.type) {
            case -1: {
                return AryaSiddhanta.SOLAR.getCalendarSystem();
            }
            case -2: {
                return AryaSiddhanta.LUNAR.getCalendarSystem();
            }
        }
        return new ModernHinduCS(this);
    }

    int getFirstMonthOfYear() {
        IndianMonth indianMonth;
        if (this.isOld()) {
            return 1;
        }
        switch (this.getRule()) {
            case AMANTA_ASHADHA: {
                indianMonth = IndianMonth.ASHADHA;
                break;
            }
            case AMANTA_KARTIKA: {
                indianMonth = IndianMonth.KARTIKA;
                break;
            }
            default: {
                indianMonth = IndianMonth.CHAITRA;
            }
        }
        return indianMonth.getValue();
    }

    HinduCS toAmanta() {
        return new HinduVariant(HinduRule.AMANTA.ordinal(), this.defaultEra, this.elapsedMode, this.depressionAngle, this.location).getCalendarSystem();
    }

    private boolean useModernAstronomy() {
        return !Double.isNaN(this.depressionAngle);
    }

    private static boolean useStandardElapsedMode(HinduEra hinduEra, HinduRule hinduRule) {
        switch (hinduEra) {
            case SAKA: {
                switch (hinduRule) {
                    case MADRAS: 
                    case MALAYALI: 
                    case TAMIL: {
                        return false;
                    }
                }
                return true;
            }
            case KOLLAM: {
                return false;
            }
        }
        return true;
    }

    private static boolean equals(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.isNaN(d2);
        }
        if (Double.isNaN(d2)) {
            return false;
        }
        return d == d2;
    }

    private HinduRule getRule() {
        return RULES[this.type];
    }

    private Object writeReplace() {
        return new SPX(this, 21);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static class ModernHinduCS
    extends HinduCS {
        private static final int MIN_YEAR = 1200;
        private static final int MAX_YEAR = 5999;
        private static final boolean CC = false;
        static final double SIDEREAL_YEAR = 365.2587564814815;
        static final double SIDEREAL_START = 336.1360765905204;
        private static final double SIDEREAL_MONTH = 27.321674162683866;
        private static final double SYNODIC_MONTH = 29.53058794607172;
        private static final double EPSILON = Math.pow(2.0, -1000.0);
        private static final double CREATION = -7.14403429586E11;
        private static final double ANOMALISTIC_YEAR = 365.25878920258134;
        private static final double ANOMALISTIC_MONTH = 27.554597974680476;
        private static final double MEAN_SIDEREAL_YEAR = 365.25636;
        private static final double MEAN_SYNODIC_MONTH = 29.530588861;
        private static final double[] RISING_SIGN_FACTORS;
        private volatile long min = Long.MIN_VALUE;
        private volatile long max = Long.MAX_VALUE;

        ModernHinduCS(HinduVariant hinduVariant) {
            super(hinduVariant);
        }

        @Override
        HinduCalendar create(long l) {
            HinduVariant hinduVariant = this.variant;
            switch (this.getRule()) {
                case MADRAS: 
                case MALAYALI: 
                case TAMIL: 
                case ORISSA: {
                    return ModernHinduCS.hSolarFromFixed(l, hinduVariant);
                }
                case AMANTA: {
                    return ModernHinduCS.hLunarFromFixed(l, hinduVariant);
                }
                case AMANTA_ASHADHA: 
                case AMANTA_KARTIKA: {
                    HinduCalendar hinduCalendar = hinduVariant.toAmanta().create(l);
                    int n = hinduCalendar.getExpiredYearOfKaliYuga();
                    if (hinduCalendar.getMonth().getValue().getValue() < hinduVariant.getFirstMonthOfYear()) {
                        --n;
                    }
                    return new HinduCalendar(hinduVariant, n, hinduCalendar.getMonth(), hinduCalendar.getDayOfMonth(), l);
                }
                case PURNIMANTA: {
                    HinduCS hinduCS = hinduVariant.toAmanta();
                    HinduCalendar hinduCalendar = hinduCS.create(l);
                    HinduMonth hinduMonth = HinduMonth.ofLunisolar(hinduCalendar.getDayOfMonth().getValue() >= 16 ? hinduCS.create(l + 20L).getMonth().getValue().getValue() : hinduCalendar.getMonth().getValue().getValue());
                    if (hinduCalendar.getMonth().isLeap()) {
                        hinduMonth = hinduMonth.withLeap();
                    }
                    return new HinduCalendar(hinduVariant, hinduCalendar.getExpiredYearOfKaliYuga(), hinduMonth, hinduCalendar.getDayOfMonth(), l);
                }
            }
            throw new UnsupportedOperationException(this.getRule().name());
        }

        @Override
        HinduCalendar create(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
            long l;
            HinduVariant hinduVariant = this.variant;
            switch (this.getRule()) {
                case MADRAS: 
                case MALAYALI: 
                case TAMIL: 
                case ORISSA: {
                    l = ModernHinduCS.hFixedFromSolar(n, hinduMonth, hinduDay, hinduVariant);
                    break;
                }
                case AMANTA: {
                    l = ModernHinduCS.hFixedFromLunar(n, hinduMonth, hinduDay, hinduVariant);
                    break;
                }
                case AMANTA_ASHADHA: 
                case AMANTA_KARTIKA: {
                    int n2 = n;
                    if (hinduMonth.getValue().getValue() < hinduVariant.getFirstMonthOfYear()) {
                        ++n2;
                    }
                    HinduCalendar hinduCalendar = hinduVariant.toAmanta().create(n2, hinduMonth, hinduDay);
                    return new HinduCalendar(hinduVariant, n, hinduMonth, hinduDay, hinduCalendar.getDaysSinceEpochUTC());
                }
                case PURNIMANTA: {
                    HinduMonth hinduMonth2 = hinduMonth.isLeap() || hinduDay.getValue() <= 15 ? hinduMonth : (this.variant.toAmanta().isExpunged(n, ModernHinduCS.prevMonth(hinduMonth, 1)) ? ModernHinduCS.prevMonth(hinduMonth, 2) : ModernHinduCS.prevMonth(hinduMonth, 1));
                    l = ModernHinduCS.hFixedFromLunar(n, hinduMonth2, hinduDay, hinduVariant);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.getRule().name());
                }
            }
            return new HinduCalendar(hinduVariant, n, hinduMonth, hinduDay, l);
        }

        @Override
        boolean isValid(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
            if (n < 1200 || n > 5999 || hinduMonth == null || hinduDay == null) {
                return false;
            }
            if (this.variant.isSolar() && (hinduMonth.isLeap() || hinduDay.isLeap())) {
                return false;
            }
            if (this.variant.isLunisolar() && hinduDay.getValue() > 30) {
                return false;
            }
            HinduCS hinduCS = this;
            HinduRule hinduRule = this.getRule();
            if (hinduRule == HinduRule.AMANTA_ASHADHA || hinduRule == HinduRule.AMANTA_KARTIKA) {
                if (hinduMonth.getValue().getValue() < this.variant.getFirstMonthOfYear()) {
                    ++n;
                }
                hinduCS = this.variant.toAmanta();
            }
            return !hinduCS.isExpunged(n, hinduMonth, hinduDay);
        }

        @Override
        public long getMinimumSinceUTC() {
            if (this.min == Long.MIN_VALUE) {
                HinduCalendar hinduCalendar = this.variant.isPurnimanta() ? this.createNewYear(1201).withFirstDayOfMonth() : this.createNewYear(1200);
                this.min = hinduCalendar.getDaysSinceEpochUTC();
            }
            return this.min;
        }

        @Override
        public long getMaximumSinceUTC() {
            if (this.max == Long.MAX_VALUE) {
                HinduCalendar hinduCalendar = this.createNewYear(6000);
                if (this.variant.isPurnimanta()) {
                    hinduCalendar = hinduCalendar.withFirstDayOfMonth();
                }
                this.max = hinduCalendar.getDaysSinceEpochUTC() - 1L;
            }
            return this.max;
        }

        private HinduCalendar createNewYear(int n) {
            return this.create(n, HinduMonth.of(IndianMonth.AGRAHAYANA), HinduDay.valueOf(1)).withNewYear();
        }

        private HinduRule getRule() {
            return this.variant.getRule();
        }

        private static HinduMonth prevMonth(HinduMonth hinduMonth, int n) {
            int n2 = hinduMonth.getValue().getValue() - n;
            if (n2 <= 0) {
                n2 += 12;
            }
            return HinduMonth.ofLunisolar(n2);
        }

        private static double hSineTable(double d) {
            double d2 = 3438.0 * Math.sin(Math.toRadians(d * 3.75));
            double d3 = 0.215 * Math.signum(d2) * Math.signum(Math.abs(d2) - 1716.0);
            return Math.floor(d2 + d3 + 0.5) / 3438.0;
        }

        private static double hSine(double d) {
            double d2 = d / 3.75;
            double d3 = ModernHinduCS.modulo(d2, 1.0);
            return d3 * ModernHinduCS.hSineTable(Math.ceil(d2)) + (1.0 - d3) * ModernHinduCS.hSineTable(Math.floor(d2));
        }

        private static double hArcSin(double d) {
            if (d < 0.0) {
                return -ModernHinduCS.hArcSin(-d);
            }
            int n = 0;
            while (d > ModernHinduCS.hSineTable(n)) {
                ++n;
            }
            double d2 = ModernHinduCS.hSineTable(n - 1);
            return 3.75 * ((double)(n - 1) + (d - d2) / (ModernHinduCS.hSineTable(n) - d2));
        }

        private static double hMeanPosition(double d, double d2) {
            return 360.0 * ModernHinduCS.modulo((d - -7.14403429586E11) / d2, 1.0);
        }

        private static double hTruePosition(double d, double d2, double d3, double d4, double d5) {
            double d6 = ModernHinduCS.hMeanPosition(d, d2);
            double d7 = ModernHinduCS.hSine(ModernHinduCS.hMeanPosition(d, d4));
            double d8 = Math.abs(d7) * d5 * d3;
            double d9 = ModernHinduCS.hArcSin(d7 * (d3 - d8));
            return ModernHinduCS.modulo(d6 - d9, 360.0);
        }

        private static double hSiderealSolarLongitude(double d) {
            return ModernHinduCS.modulo(StdSolarCalculator.CC.getFeature(ModernHinduCS.toJDE(d).getValue(), "solar-longitude") - ModernHinduCS.hPrecession(d) + 336.1360765905204, 360.0);
        }

        static double hSolarLongitude(double d) {
            return ModernHinduCS.hTruePosition(d, 365.2587564814815, 0.03888888888888889, 365.25878920258134, 0.023809523809523808);
        }

        static double hPrecession(double d) {
            double d2 = ModernHinduCS.toJDE(d).getCenturyJ2000();
            int n = -1;
            double d3 = ModernHinduCS.modulo((0.01305636111111111 + (-9.172222222222223E-6 + 1.6666666666666667E-8 * d2) * d2) * d2, 360.0);
            double d4 = ModernHinduCS.modulo(174.876384 + (-0.24161358333333333 + 9.822222222222223E-6 * d2) * d2, 360.0);
            double d5 = ModernHinduCS.modulo((1.3969712777777776 + (3.0864722222222223E-4 + (double)n * 6.0E-6 / 3600.0 * d2) * d2) * d2, 360.0);
            double d6 = Math.cos(Math.toRadians(d3)) * Math.sin(Math.toRadians(d4));
            double d7 = Math.cos(Math.toRadians(d4));
            double d8 = Math.toDegrees(Math.atan2(d6, d7));
            return ModernHinduCS.modulo(d5 + d4 - d8, 360.0);
        }

        private static JulianDay toJDE(double d) {
            long l = Math.round((d + 1721424.0 - 2440587.0) * 86400.0);
            return JulianDay.ofEphemerisTime(Moment.of(l, TimeScale.POSIX));
        }

        private static double toRataDie(Moment moment) {
            return (double)moment.getPosixTime() / 86400.0 + 2440587.0 - 1721424.0;
        }

        private static int hZodiac(double d) {
            return (int)(Math.floor(ModernHinduCS.hSolarLongitude(d) / 30.0) + 1.0);
        }

        private static int hSiderealZodiac(double d) {
            return (int)(Math.floor(ModernHinduCS.hSiderealSolarLongitude(d) / 30.0) + 1.0);
        }

        private static double hLunarLongitude(double d) {
            return ModernHinduCS.hTruePosition(d, 27.321674162683866, 0.08888888888888889, 27.554597974680476, 0.010416666666666666);
        }

        private static double hLunarPhase(double d) {
            return ModernHinduCS.modulo(ModernHinduCS.hLunarLongitude(d) - ModernHinduCS.hSolarLongitude(d), 360.0);
        }

        private static int hLunarDayFromMoment(double d, HinduVariant hinduVariant) {
            double d2;
            if (hinduVariant.useModernAstronomy()) {
                int n;
                double d3;
                double d4 = ModernHinduCS.toJDE(d).getValue();
                double d5 = StdSolarCalculator.CC.getFeature(d4, "solar-longitude");
                double d6 = StdSolarCalculator.CC.getFeature(d4, "lunar-longitude");
                double d7 = ModernHinduCS.modulo(d6 - d5, 360.0);
                d2 = Math.abs(d7 - (d3 = 360.0 * ModernHinduCS.modulo((d - ModernHinduCS.nthNewMoon(n = (int)Math.round((d - ModernHinduCS.nthNewMoon(0)) / 29.530588861))) / 29.530588861, 1.0))) > 180.0 ? d3 : d7;
            } else {
                d2 = ModernHinduCS.hLunarPhase(d);
            }
            return (int)(Math.floor(d2 / 12.0) + 1.0);
        }

        private static double nthNewMoon(int n) {
            return ModernHinduCS.toRataDie(MoonPhase.NEW_MOON.atLunation(n - 24724));
        }

        private static double hNewMoonBefore(double d) {
            double d2 = d - ModernHinduCS.hLunarPhase(d) * 29.53058794607172 / 360.0;
            return ModernHinduCS.binarySearchLunarPhase(d2 - 1.0, Math.min(d, d2 + 1.0));
        }

        private static double binarySearchLunarPhase(double d, double d2) {
            double d3 = (d + d2) / 2.0;
            if (ModernHinduCS.hZodiac(d) == ModernHinduCS.hZodiac(d2) || d2 - d < EPSILON) {
                return d3;
            }
            if (ModernHinduCS.hLunarPhase((d + d2) / 2.0) < 180.0) {
                return ModernHinduCS.binarySearchLunarPhase(d, d3);
            }
            return ModernHinduCS.binarySearchLunarPhase(d3, d2);
        }

        private static int hCalendarYear(double d, HinduVariant hinduVariant) {
            if (hinduVariant.useModernAstronomy()) {
                return (int)Math.floor(0.5 + (d - -1132959.0) / 365.25636 - ModernHinduCS.hSiderealSolarLongitude(d) / 360.0);
            }
            return (int)Math.floor(0.5 + (d - -1132959.0) / 365.2587564814815 - ModernHinduCS.hSolarLongitude(d) / 360.0);
        }

        private static HinduCalendar hSolarFromFixed(long l, HinduVariant hinduVariant) {
            long l2;
            int n;
            assert (hinduVariant.isSolar());
            LongFunction<Double> longFunction = ModernHinduCS.hCritical(hinduVariant);
            long l3 = EpochDays.RATA_DIE.transform(l, EpochDays.UTC);
            double d = longFunction.apply(l3);
            int n2 = ModernHinduCS.hCalendarYear(d, hinduVariant);
            if (hinduVariant.useModernAstronomy()) {
                n = ModernHinduCS.hSiderealZodiac(d);
                l2 = l3 - 3L - (long)((int)ModernHinduCS.modulo(Math.floor(ModernHinduCS.hSiderealSolarLongitude(d)), 30.0));
                while (ModernHinduCS.hSiderealZodiac(longFunction.apply(l2)) != n) {
                    ++l2;
                }
            } else {
                n = ModernHinduCS.hZodiac(d);
                l2 = l3 - 3L - (long)((int)ModernHinduCS.modulo(Math.floor(ModernHinduCS.hSolarLongitude(d)), 30.0));
                while (ModernHinduCS.hZodiac(longFunction.apply(l2)) != n) {
                    ++l2;
                }
            }
            return new HinduCalendar(hinduVariant, n2, HinduMonth.ofSolar(n), HinduDay.valueOf((int)(l3 - l2 + 1L)), l);
        }

        private static long hFixedFromSolar(int n, HinduMonth hinduMonth, HinduDay hinduDay, HinduVariant hinduVariant) {
            assert (hinduVariant.isSolar());
            int n2 = hinduMonth.getRasi();
            LongFunction<Double> longFunction = ModernHinduCS.hCritical(hinduVariant);
            double d = hinduVariant.useModernAstronomy() ? 365.25636 : 365.2587564814815;
            long l = -1132962L + (long)Math.floor(d * ((double)n + (double)(n2 - 1) / 12.0));
            if (hinduVariant.useModernAstronomy()) {
                while (ModernHinduCS.hSiderealZodiac(longFunction.apply(l)) != n2) {
                    ++l;
                }
            } else {
                while (ModernHinduCS.hZodiac(longFunction.apply(l)) != n2) {
                    ++l;
                }
            }
            return EpochDays.UTC.transform((long)(hinduDay.getValue() - 1) + l, EpochDays.RATA_DIE);
        }

        private static LongFunction<Double> hCritical(HinduVariant hinduVariant) {
            switch (hinduVariant.getRule()) {
                case ORISSA: {
                    return l -> ModernHinduCS.hSunrise(l + 1L, hinduVariant);
                }
                case TAMIL: {
                    return l -> ModernHinduCS.hSunset(l, hinduVariant);
                }
                case MALAYALI: {
                    return l -> ModernHinduCS.hStandardFromSundial((double)l + 0.55, hinduVariant);
                }
                case MADRAS: {
                    return l -> ModernHinduCS.hStandardFromSundial(l + 1L, hinduVariant);
                }
            }
            throw new UnsupportedOperationException("Not yet implemented.");
        }

        private static HinduCalendar hLunarFromFixed(long l, HinduVariant hinduVariant) {
            int n;
            int n2;
            assert (hinduVariant.isLunisolar());
            long l2 = EpochDays.RATA_DIE.transform(l, EpochDays.UTC);
            double d = ModernHinduCS.hSunrise(l2, hinduVariant);
            int n3 = ModernHinduCS.hLunarDayFromMoment(d, hinduVariant);
            HinduDay hinduDay = HinduDay.valueOf(n3);
            if (ModernHinduCS.hLunarDayFromMoment(ModernHinduCS.hSunrise(l2 - 1L, hinduVariant), hinduVariant) == n3) {
                hinduDay = hinduDay.withLeap();
            }
            if (hinduVariant.useModernAstronomy()) {
                Moment moment = ModernHinduCS.toJDE(d).toMoment();
                double d2 = ModernHinduCS.toRataDie(MoonPhase.NEW_MOON.before(moment));
                double d3 = ModernHinduCS.toRataDie(MoonPhase.NEW_MOON.atOrAfter(moment));
                n2 = ModernHinduCS.hSiderealZodiac(d2);
                n = ModernHinduCS.hSiderealZodiac(d3);
            } else {
                double d4 = ModernHinduCS.hNewMoonBefore(d);
                double d5 = ModernHinduCS.hNewMoonBefore(Math.floor(d4) + 35.0);
                n2 = ModernHinduCS.hZodiac(d4);
                n = ModernHinduCS.hZodiac(d5);
            }
            int n4 = n2 == 12 ? 1 : n2 + 1;
            HinduMonth hinduMonth = HinduMonth.ofLunisolar(n4);
            if (n == n2) {
                hinduMonth = hinduMonth.withLeap();
            }
            int n5 = ModernHinduCS.hCalendarYear(n4 <= 2 ? (double)l2 + 180.0 : (double)l2, hinduVariant);
            return new HinduCalendar(hinduVariant, n5, hinduMonth, hinduDay, l);
        }

        private static long hFixedFromLunar(int n, HinduMonth hinduMonth, HinduDay hinduDay, HinduVariant hinduVariant) {
            HinduCalendar hinduCalendar;
            double d;
            double d2;
            assert (hinduVariant.isLunisolar());
            int n2 = hinduMonth.getValue().getValue();
            if (hinduVariant.useModernAstronomy()) {
                d2 = -1132959.0 + 365.25636 * ((double)n + (double)(n2 - 1) / 12.0);
                d = ModernHinduCS.hSiderealSolarLongitude(d2);
            } else {
                d2 = -1132959.0 + 365.2587564814815 * ((double)n + (double)(n2 - 1) / 12.0);
                d = ModernHinduCS.hSolarLongitude(d2);
            }
            d = d / 360.0 - (double)(n2 - 1) / 12.0;
            long l = (long)Math.floor(d2 - 365.2587564814815 * (-0.5 + ModernHinduCS.modulo(d + 0.5, 1.0)));
            int n3 = ModernHinduCS.hLunarDayFromMoment((double)l + 0.25, hinduVariant);
            int n4 = hinduDay.getValue();
            int n5 = n3 > 3 && n3 < 27 ? n3 : ((hinduCalendar = ModernHinduCS.hLunarFromFixed(EpochDays.UTC.transform(l - 15L, EpochDays.RATA_DIE), hinduVariant)).getMonth().getValue() != hinduMonth.getValue() || hinduCalendar.getMonth().isLeap() && !hinduMonth.isLeap() ? -15 + (int)ModernHinduCS.modulo(n3 + 15, 30.0) : 15 + (int)ModernHinduCS.modulo(n3 - 15, 30.0));
            long l2 = l + (long)n4 - (long)n5;
            long l3 = l2 + 14L - (long)((int)ModernHinduCS.modulo(ModernHinduCS.hLunarDayFromMoment((double)l2 + 0.25, hinduVariant) - n4 + 15, 30.0));
            while (true) {
                int n6;
                int n7 = ModernHinduCS.hLunarDayFromMoment(ModernHinduCS.hSunrise(l3, hinduVariant), hinduVariant);
                int n8 = (int)ModernHinduCS.modulo(n4 + 1, 30.0);
                int n9 = n6 = n8 == 0 ? 30 : n8;
                if (n7 == n4 || n7 == n6) break;
                ++l3;
            }
            if (hinduDay.isLeap()) {
                ++l3;
            }
            return EpochDays.UTC.transform(l3, EpochDays.RATA_DIE);
        }

        private static double hAscensionalDifference(double d, GeoLocation geoLocation) {
            double d2 = 0.4063408958696917 * ModernHinduCS.hSine(ModernHinduCS.hTropicalLongitude(d));
            double d3 = geoLocation.getLatitude();
            double d4 = ModernHinduCS.hSine(90.0 + ModernHinduCS.hArcSin(d2));
            double d5 = d2 * (ModernHinduCS.hSine(d3) / ModernHinduCS.hSine(90.0 + d3));
            return ModernHinduCS.hArcSin(-1.0 * d5 / d4);
        }

        private static double hSolarSiderealDifference(double d) {
            return ModernHinduCS.hDailyMotion(d) * ModernHinduCS.hRisingSign(d);
        }

        private static double hEquationOfTime(double d) {
            double d2 = ModernHinduCS.hSine(ModernHinduCS.hMeanPosition(d, 365.25878920258134));
            double d3 = d2 * 57.3 * (0.03888888888888889 - Math.abs(d2) / 1080.0);
            return ModernHinduCS.hDailyMotion(d) / 360.0 * (d3 / 360.0) * 365.2587564814815;
        }

        private static double hTropicalLongitude(double d) {
            double d2 = 3.80247937727211E-7 * (d - -1132959.0) - 0.25;
            double d3 = 27.0 - Math.abs(108.0 * (-0.5 + ModernHinduCS.modulo(d2 + 0.5, 1.0)));
            return ModernHinduCS.modulo(ModernHinduCS.hSolarLongitude(d) - d3, 360.0);
        }

        private static double hDailyMotion(double d) {
            double d2 = ModernHinduCS.hMeanPosition(d, 365.25878920258134);
            double d3 = 0.03888888888888889 - 9.25925925925926E-4 * Math.abs(ModernHinduCS.hSine(d2));
            double d4 = Math.floor(d2 / 3.75);
            double d5 = ModernHinduCS.hSineTable(d4 + 1.0) - ModernHinduCS.hSineTable(d4);
            double d6 = 1.0 - 15.28 * d5 * d3;
            return 0.9856026545889308 * d6;
        }

        private static double hRisingSign(double d) {
            int n = (int)Math.floor(ModernHinduCS.hTropicalLongitude(d) / 30.0);
            return RISING_SIGN_FACTORS[(int)ModernHinduCS.modulo(n, 6.0)];
        }

        private static double hSunrise(double d, HinduVariant hinduVariant) {
            if (hinduVariant.useModernAstronomy()) {
                GeoLocation geoLocation = hinduVariant.getLocation();
                PlainDate plainDate = PlainDate.of((long)Math.floor(d), EpochDays.RATA_DIE);
                Moment moment = StdSolarCalculator.CC.sunrise(plainDate, geoLocation.getLatitude(), geoLocation.getLongitude(), 90.0 + hinduVariant.depressionAngle).get();
                double d2 = ((double)moment.getPosixTime() + 18184.4) / 86400.0;
                long l = EpochDays.RATA_DIE.transform((long)Math.floor(d2), EpochDays.UNIX);
                return (double)l + d2 - Math.floor(d2);
            }
            double d3 = d + 0.25 + (UJJAIN.getLongitude() - hinduVariant.getLocation().getLongitude()) / 360.0;
            double d4 = ModernHinduCS.hAscensionalDifference(d, hinduVariant.getLocation());
            double d5 = 0.25 * ModernHinduCS.hSolarSiderealDifference(d) + d4;
            return d3 - ModernHinduCS.hEquationOfTime(d) + 0.002770193582919304 * d5;
        }

        private static double hSunset(double d, HinduVariant hinduVariant) {
            if (hinduVariant.useModernAstronomy()) {
                GeoLocation geoLocation = hinduVariant.getLocation();
                PlainDate plainDate = PlainDate.of((long)Math.floor(d), EpochDays.RATA_DIE);
                Moment moment = StdSolarCalculator.CC.sunset(plainDate, geoLocation.getLatitude(), geoLocation.getLongitude(), 90.0 + hinduVariant.depressionAngle).get();
                double d2 = ((double)moment.getPosixTime() + 18184.4) / 86400.0;
                long l = EpochDays.RATA_DIE.transform((long)Math.floor(d2), EpochDays.UNIX);
                return (double)l + d2 - Math.floor(d2);
            }
            double d3 = d + 0.75 + (UJJAIN.getLongitude() - hinduVariant.getLocation().getLongitude()) / 360.0;
            double d4 = ModernHinduCS.hAscensionalDifference(d, hinduVariant.getLocation());
            double d5 = 0.75 * ModernHinduCS.hSolarSiderealDifference(d) - d4;
            return d3 - ModernHinduCS.hEquationOfTime(d) + 0.002770193582919304 * d5;
        }

        private static double hStandardFromSundial(double d, HinduVariant hinduVariant) {
            double d2;
            double d3;
            double d4;
            double d5 = Math.floor(d);
            double d6 = d - d5;
            int n = (int)Math.floor(4.0 * d6);
            if (n == 0) {
                d4 = ModernHinduCS.hSunset(d5 - 1.0, hinduVariant);
                d3 = ModernHinduCS.hSunrise(d5, hinduVariant);
                d2 = -0.25;
            } else if (n == 3) {
                d4 = ModernHinduCS.hSunset(d5, hinduVariant);
                d3 = ModernHinduCS.hSunrise(d5 + 1.0, hinduVariant);
                d2 = 0.75;
            } else {
                d4 = ModernHinduCS.hSunrise(d5, hinduVariant);
                d3 = ModernHinduCS.hSunset(d5, hinduVariant);
                d2 = 0.25;
            }
            return d4 + 2.0 * (d3 - d4) * (d6 - d2);
        }

        static {
            double[] dArray = new double[]{0.9277777777777778, 0.9972222222222222, 1.075, 1.075, 0.9972222222222222, 0.9277777777777778};
            RISING_SIGN_FACTORS = dArray;
        }
    }
}

