/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.calendar.astro.AstroUtils;
import net.time4j.calendar.astro.EquatorialCoordinates;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.astro.Zodiac;
import net.time4j.tz.ZonalOffset;

public class MoonPosition
implements EquatorialCoordinates,
Serializable {
    private static final int[] A_D = new int[]{0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 0, 1, 0, 2, 0, 0, 4, 0, 4, 2, 2, 1, 1, 2, 2, 4, 2, 0, 2, 2, 1, 2, 0, 0, 2, 2, 2, 4, 0, 3, 2, 4, 0, 2, 2, 2, 4, 0, 4, 1, 2, 0, 1, 3, 4, 2, 0, 1, 2, 2};
    private static final int[] A_M = new int[]{0, 0, 0, 0, 1, 0, 0, -1, 0, -1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, -1, 0, 0, 0, 1, 0, -1, 0, -2, 1, 2, -2, 0, 0, -1, 0, 0, 1, -1, 2, 2, 1, -1, 0, 0, -1, 0, 1, 0, 1, 0, 0, -1, 2, 1, 0, 0};
    private static final int[] A_M2 = new int[]{1, -1, 0, 2, 0, 0, -2, -1, 1, 0, -1, 0, 1, 0, 1, 1, -1, 3, -2, -1, 0, -1, 0, 1, 2, 0, -3, -2, -1, -2, 1, 0, 2, 0, -1, 1, 0, -1, 2, -1, 1, -2, -1, -1, -2, 0, 1, 4, 0, -2, 0, 2, 1, -2, -3, 2, 1, -1, 3, -1};
    private static final int[] A_F = new int[]{0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, -2, 2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, -2, 2, 0, 2, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, -2, -2, 0, 0, 0, 0, 0, 0, 0, -2};
    private static final int[] COEFF_L = new int[]{6288774, 1274027, 658314, 213618, -185116, -114332, 58793, 57066, 53322, 45758, -40923, -34720, -30383, 15327, -12528, 10980, 10675, 10034, 8548, -7888, -6766, -5163, 4987, 4036, 3994, 3861, 3665, -2689, -2602, 2390, -2348, 2236, -2120, -2069, 2048, -1773, -1595, 1215, -1110, -892, -810, 759, -713, -700, 691, 596, 549, 537, 520, -487, -399, -381, 351, -340, 330, 327, -323, 299, 294, 0};
    private static final int[] COEFF_R = new int[]{-20905355, -3699111, -2955968, -569925, 48888, -3149, 246158, -152138, -170733, -204586, -129620, 108743, 104755, 10321, 0, 79661, -34782, -23210, -21636, 24208, 30824, -8379, -16675, -12831, -10445, -11650, 14403, -7003, 0, 10056, 6322, -9884, 5751, 0, -4950, 4130, 0, -3958, 0, 3258, 2616, -1897, -2117, 2354, 0, 0, -1423, -1117, -1571, -1739, 0, -4421, 0, 0, 0, 0, 1165, 0, 0, 8752};
    private static final int[] B_D = new int[]{0, 0, 0, 2, 2, 2, 2, 0, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 1, 0, 4, 4, 0, 4, 2, 2, 2, 2, 0, 2, 2, 2, 2, 4, 2, 2, 0, 2, 1, 1, 0, 2, 1, 2, 0, 4, 4, 1, 4, 1, 4, 2};
    private static final int[] B_M = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, -1, -1, -1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 1, 0, -1, -2, 0, 1, 1, 1, 1, 1, 0, -1, 1, 0, -1, 0, 0, 0, -1, -2};
    private static final int[] B_M2 = new int[]{0, 1, 1, 0, -1, -1, 0, 2, 1, 2, 0, -2, 1, 0, -1, 0, -1, -1, -1, 0, 0, -1, 0, 1, 1, 0, 0, 3, 0, -1, 1, -2, 0, 2, 1, -2, 3, 2, -3, -1, 0, 0, 1, 0, 1, 1, 0, 0, -2, -1, 1, -2, 2, -2, -1, 1, 1, -1, 0, 0};
    private static final int[] B_F = new int[]{1, 1, -1, -1, 1, -1, 1, 1, -1, -1, -1, -1, 1, -1, 1, 1, -1, -1, -1, 1, 3, 1, 1, 1, -1, -1, -1, 1, -1, 1, -3, 1, -3, -1, -1, 1, -1, 1, -1, 1, 1, 1, 1, -1, 3, -1, -1, 1, -1, -1, 1, -1, 1, -1, -1, -1, -1, -1, -1, 1};
    private static final int[] COEFF_B = new int[]{5128122, 280602, 277693, 173237, 55413, 46271, 32573, 17198, 9266, 8822, 8216, 4324, 4200, -3359, 2463, 2211, 2065, -1870, 1828, -1794, -1749, -1565, -1491, -1475, -1410, -1344, -1335, 1107, 1021, 833, 777, 671, 607, 596, 491, -451, 439, 422, 421, -366, -351, 331, 315, 302, -283, -229, 223, 223, -220, -220, -185, 181, -177, 176, 166, -164, 132, -119, 115, 107};
    private static final int[] PERIGEE_D = new int[]{2, 4, 6, 8, 2, 0, 10, 4, 6, 12, 1, 8, 14, 0, 3, 10, 16, 12, 5, 2, 18, 14, 7, 2, 20, 1, 16, 4, 9, 4, 2, 4, 6, 22, 18, 6, 11, 8, 4, 6, 3, 5, 13, 20, 3, 4, 1, 22, 0, 6, 2, 0, 0, 2, 0, 2, 24, 4, 2, 1};
    private static final int[] PERIGEE_F = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, -2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 4, -2, -2, 0, 2, 4, 2, -2, 0, -4, 0, 0};
    private static final int[] PERIGEE_M = new int[]{0, 0, 0, 0, -1, 1, 0, -1, -1, 0, 0, -1, 0, 0, 0, -1, 0, -1, 0, 0, 0, -1, 0, 1, 0, 1, -1, 1, 0, 0, -2, -2, -2, 0, -1, 1, 0, 1, 0, 0, 1, 1, 0, -1, 2, -2, 2, -1, 0, 0, 1, 2, -1, 0, -2, 2, 0, 0, 2, -1};
    private static final double[] PERIGEE_COEFF = new double[]{-1.6769, 0.4589, -0.1856, 0.0883, -0.0773, 0.0502, -0.046, 0.0422, -0.0256, 0.0253, 0.0237, 0.0162, -0.0145, 0.0129, -0.0112, -0.0104, 0.0086, 0.0069, 0.0066, -0.0053, -0.0052, -0.0046, -0.0041, 0.004, 0.0032, -0.0032, 0.0031, -0.0029, 0.0027, 0.0027, -0.0027, 0.0024, -0.0021, -0.0021, -0.0021, 0.0019, -0.0018, -0.0014, -0.0014, -0.0014, 0.0014, -0.0014, 0.0013, 0.0013, 0.0011, -0.0011, -0.001, -9.0E-4, -8.0E-4, 8.0E-4, 8.0E-4, 7.0E-4, 7.0E-4, 7.0E-4, -6.0E-4, -6.0E-4, 6.0E-4, 5.0E-4, 5.0E-4, -4.0E-4};
    private static final double[] PERIGEE_COEFF_T = new double[]{0.0, 0.0, 0.0, 0.0, 1.9E-4, -1.3E-4, 0.0, -1.1E-4};
    private static final int[] APOGEE_D = new int[]{2, 4, 0, 2, 0, 1, 6, 4, 2, 1, 8, 6, 2, 2, 3, 4, 8, 4, 10, 3, 0, 2, 2, 6, 6, 10, 5, 4, 0, 12, 2, 1};
    private static final int[] APOGEE_F = new int[]{0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, -2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, -2, 2, 0, 2, 0};
    private static final int[] APOGEE_M = new int[]{0, 0, 1, -1, 0, 0, 0, -1, 0, 1, 0, -1, 0, -2, 0, 0, -1, -2, 0, 1, 2, 1, 2, 0, -2, -1, 0, 0, 1, 0, -1, -1};
    private static final double[] APOGEE_COEFF = new double[]{0.4392, 0.0684, 0.0456, 0.0426, 0.0212, -0.0189, 0.0144, 0.0113, 0.0047, 0.0036, 0.0035, 0.0034, -0.0034, 0.0022, -0.0017, 0.0013, 0.0011, 0.001, 9.0E-4, 7.0E-4, 6.0E-4, 5.0E-4, 5.0E-4, 4.0E-4, 4.0E-4, 4.0E-4, -4.0E-4, -4.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, -3.0E-4};
    private static final double[] APOGEE_COEFF_T = new double[]{0.0, 0.0, -1.1E-4, -1.1E-4};
    private static final int MIO = 1000000;
    private static final long serialVersionUID = 5736859564589473324L;
    private final double rightAscension;
    private final double declination;
    private final double azimuth;
    private final double elevation;
    private final double distance;

    private MoonPosition(double d, double d2, double d3, double d4, double d5) {
        this.rightAscension = d;
        this.declination = d2;
        this.azimuth = d3;
        this.elevation = d4;
        this.distance = d5;
    }

    public static MoonPosition at(Moment moment, GeoLocation geoLocation) {
        double d;
        double d2;
        double[] dArray = MoonPosition.calculateMeeus47(JulianDay.ofEphemerisTime(moment).getCenturyJ2000());
        double d3 = Math.toRadians(dArray[2]);
        double d4 = Math.toRadians(dArray[3]);
        double d5 = dArray[4];
        double d6 = Math.toRadians(geoLocation.getLatitude());
        double d7 = Math.toRadians(geoLocation.getLongitude());
        double d8 = Math.cos(d6);
        double d9 = Math.sin(d6);
        int n = geoLocation.getAltitude();
        double d10 = JulianDay.ofMeanSolarTime(moment).getMJD();
        double d11 = dArray[0] * Math.cos(Math.toRadians(dArray[1]));
        double d12 = AstroUtils.gmst(d10) + Math.toRadians(d11) + d7 - d3;
        double d13 = d9 * Math.sin(d4) + d8 * Math.cos(d4) * Math.cos(d12);
        double d14 = Math.toDegrees(Math.asin(d13));
        if (d14 >= -0.5 - (d2 = StdSolarCalculator.TIME4J.getGeodeticAngle(geoLocation.getLatitude(), n))) {
            d = Math.toDegrees(Math.asin(6378.14 / d5));
            double d15 = AstroUtils.refractionFactorOfStdAtmosphere(n);
            double d16 = d15 * AstroUtils.getRefraction(d14) / 60.0;
            d14 = d14 - d + d16;
        }
        d = Math.toDegrees(Math.atan2(Math.sin(d12), Math.cos(d12) * d9 - Math.tan(d4) * d8)) + 180.0;
        return new MoonPosition(dArray[2], dArray[3], d, d14, d5);
    }

    public static Zodiac.Event inConstellationOf(Zodiac zodiac) {
        return Zodiac.Event.ofConstellation('L', zodiac);
    }

    public static Zodiac.Event inSignOf(Zodiac zodiac) {
        return Zodiac.Event.ofSign('L', zodiac);
    }

    public static Moment inNextApogeeAfter(Moment moment) {
        return MoonPosition.anomalistic(moment, true);
    }

    public static Moment inNextPerigeeAfter(Moment moment) {
        return MoonPosition.anomalistic(moment, false);
    }

    @Override
    public double getRightAscension() {
        return this.rightAscension;
    }

    @Override
    public double getDeclination() {
        return this.declination;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MoonPosition) {
            MoonPosition moonPosition = (MoonPosition)object;
            return this.rightAscension == moonPosition.rightAscension && this.declination == moonPosition.declination && this.azimuth == moonPosition.azimuth && this.elevation == moonPosition.elevation && this.distance == moonPosition.distance;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.rightAscension) + 31 * Double.hashCode(this.declination) + 37 * Double.hashCode(this.distance);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("moon-position[ra=");
        stringBuilder.append(this.rightAscension);
        stringBuilder.append(",decl=");
        stringBuilder.append(this.declination);
        stringBuilder.append(",azimuth=");
        stringBuilder.append(this.azimuth);
        stringBuilder.append(",elevation=");
        stringBuilder.append(this.elevation);
        stringBuilder.append(",distance=");
        stringBuilder.append(this.distance);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static double[] calculateMeeus47(double d) {
        double d2;
        double d3 = MoonPosition.getMeanLongitude(d);
        double d4 = MoonPosition.getMeanElongation(d);
        double d5 = MoonPosition.getMeanAnomalyOfSun(d);
        double d6 = MoonPosition.getMeanAnomalyOfMoon(d);
        double d7 = MoonPosition.getMeanDistanceOfMoon(d);
        double d8 = 1.0 - (0.002516 + 7.4E-6 * d) * d;
        double d9 = d8 * d8;
        double d10 = 0.0;
        double d11 = 0.0;
        for (int i = A_D.length - 1; i >= 0; --i) {
            double d12;
            switch (A_M[i]) {
                case -1: 
                case 1: {
                    d12 = d8;
                    break;
                }
                case -2: 
                case 2: {
                    d12 = d9;
                    break;
                }
                default: {
                    d12 = 1.0;
                }
            }
            d2 = Math.toRadians((double)A_D[i] * d4 + (double)A_M[i] * d5 + (double)A_M2[i] * d6 + (double)A_F[i] * d7);
            d10 += (double)COEFF_L[i] * d12 * Math.sin(d2);
            d11 += (double)COEFF_R[i] * d12 * Math.cos(d2);
        }
        double d13 = 0.0;
        for (int i = B_D.length - 1; i >= 0; --i) {
            switch (B_M[i]) {
                case -1: 
                case 1: {
                    d2 = d8;
                    break;
                }
                case -2: 
                case 2: {
                    d2 = d9;
                    break;
                }
                default: {
                    d2 = 1.0;
                }
            }
            double d14 = (double)B_D[i] * d4 + (double)B_M[i] * d5 + (double)B_M2[i] * d6 + (double)B_F[i] * d7;
            d13 += (double)COEFF_B[i] * d2 * Math.sin(Math.toRadians(d14));
        }
        double d15 = 119.75 + 131.849 * d;
        double d16 = 53.09 + 479264.29 * d;
        double d17 = 313.45 + 481266.484 * d;
        d10 += 3958.0 * Math.sin(Math.toRadians(d15)) + 1962.0 * Math.sin(Math.toRadians(d3 - d7)) + 318.0 * Math.sin(Math.toRadians(d16));
        d13 += -2235.0 * Math.sin(Math.toRadians(d3)) + 382.0 * Math.sin(Math.toRadians(d17)) + 175.0 * Math.sin(Math.toRadians(d15 - d7)) + 175.0 * Math.sin(Math.toRadians(d15 + d7)) + 127.0 * Math.sin(Math.toRadians(d3 - d6)) - 115.0 * Math.sin(Math.toRadians(d3 + d6));
        double[] dArray = new double[5];
        StdSolarCalculator.nutations(d, dArray);
        double d18 = StdSolarCalculator.meanObliquity(d) + dArray[1];
        double d19 = Math.toRadians(d18);
        double d20 = Math.toRadians(d3 + d10 / 1000000.0 + dArray[0]);
        double d21 = Math.toRadians(d13 / 1000000.0);
        double d22 = 385000.56 + d11 / 1000.0;
        double d23 = Math.atan2(Math.sin(d20) * Math.cos(d19) - Math.tan(d21) * Math.sin(d19), Math.cos(d20));
        double d24 = Math.asin(Math.sin(d21) * Math.cos(d19) + Math.cos(d21) * Math.sin(d19) * Math.sin(d20));
        dArray[1] = d18;
        dArray[2] = AstroUtils.toRange_0_360(Math.toDegrees(d23));
        dArray[3] = Math.toDegrees(d24);
        dArray[4] = d22;
        return dArray;
    }

    static double lunarLongitude(double d, double d2) {
        double d3 = (d - 2451545.0) / 36525.0;
        double d4 = MoonPosition.getMeanLongitude(d3);
        double d5 = MoonPosition.getMeanElongation(d3);
        double d6 = MoonPosition.getMeanAnomalyOfSun(d3);
        double d7 = MoonPosition.getMeanAnomalyOfMoon(d3);
        double d8 = MoonPosition.getMeanDistanceOfMoon(d3);
        double d9 = 1.0 - (0.002516 + 7.4E-6 * d3) * d3;
        double d10 = d9 * d9;
        double d11 = 0.0;
        for (int i = A_D.length - 1; i >= 0; --i) {
            double d12;
            switch (A_M[i]) {
                case -1: 
                case 1: {
                    d12 = d9;
                    break;
                }
                case -2: 
                case 2: {
                    d12 = d10;
                    break;
                }
                default: {
                    d12 = 1.0;
                }
            }
            double d13 = Math.toRadians((double)A_D[i] * d5 + (double)A_M[i] * d6 + (double)A_M2[i] * d7 + (double)A_F[i] * d8);
            d11 += (double)COEFF_L[i] * d12 * Math.sin(d13);
        }
        double d14 = 119.75 + 131.849 * d3;
        double d15 = 53.09 + 479264.29 * d3;
        return AstroUtils.toRange_0_360(d4 + (d11 += 3958.0 * Math.sin(Math.toRadians(d14)) + 1962.0 * Math.sin(Math.toRadians(d4 - d8)) + 318.0 * Math.sin(Math.toRadians(d15))) / 1000000.0 + d2);
    }

    private static double getMeanLongitude(double d) {
        return MoonPosition.normalize(218.3164477 + (481267.88123421 + (-0.0015786 + (1.855835023689734E-6 + -1.5338834862103876E-8 * d) * d) * d) * d);
    }

    static double getMeanElongation(double d) {
        return MoonPosition.normalize(297.8501921 + (445267.1114034 + (-0.0018819 + (1.8319447192361523E-6 - 8.844469995135542E-9 * d) * d) * d) * d);
    }

    static double getMeanAnomalyOfSun(double d) {
        return MoonPosition.normalize(357.5291092 + (35999.0502909 + (-1.536E-4 + 4.083299305839118E-8 * d) * d) * d);
    }

    static double getMeanAnomalyOfMoon(double d) {
        return MoonPosition.normalize(134.9633964 + (477198.8675055 + (0.0087414 + (1.4347408140719379E-5 - 6.797172376291463E-8 * d) * d) * d) * d);
    }

    private static double getMeanDistanceOfMoon(double d) {
        return MoonPosition.normalize(93.272095 + (483202.0175233 + (-0.0036539 + (-2.8360748723766307E-7 + 1.1583324645839848E-9 * d) * d) * d) * d);
    }

    private static Moment calculateMeeus50(int n, boolean bl) {
        double d = (double)n + (bl ? -0.5 : 0.0);
        double d2 = d / 1325.55;
        double d3 = d2 * d2;
        double d4 = 2451534.6698 + 27.55454989 * d + (-6.691E-4 + (-1.098E-6 + 5.2E-9 * d2) * d2) * d3;
        double d5 = MoonPosition.normalize(171.9179 + 335.9106046 * d + (-0.0100383 + (-1.156E-5 + 5.5E-8 * d2) * d2) * d3);
        double d6 = MoonPosition.normalize(347.3477 + 27.1577721 * d + (-8.13E-4 - 1.0E-6 * d2) * d3);
        double d7 = MoonPosition.normalize(316.6109 + 364.5287911 * d + (-0.0125053 - 1.48E-5 * d2) * d3);
        int[] nArray = bl ? APOGEE_D : PERIGEE_D;
        int[] nArray2 = bl ? APOGEE_M : PERIGEE_M;
        int[] nArray3 = bl ? APOGEE_F : PERIGEE_F;
        double[] dArray = bl ? APOGEE_COEFF : PERIGEE_COEFF;
        double[] dArray2 = bl ? APOGEE_COEFF_T : PERIGEE_COEFF_T;
        double d8 = 0.0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            double d9 = (double)nArray[i] * d5 + (double)nArray2[i] * d6 + (double)nArray3[i] * d7;
            double d10 = dArray[i];
            if (i < dArray2.length) {
                d10 += dArray2[i] * d2;
            }
            d8 += d10 * Math.sin(Math.toRadians(d9));
        }
        return (Moment)JulianDay.ofEphemerisTime(d4 + d8).toMoment().with(Moment.PRECISION, TimeUnit.MINUTES);
    }

    private static Moment anomalistic(Moment moment, boolean bl) {
        Moment moment2 = (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
        PlainDate plainDate = moment2.toZonalTimestamp(ZonalOffset.UTC).toDate();
        double d = plainDate.getDayOfYear();
        int n = (int)Math.floor(((double)plainDate.getYear() + d / (double)plainDate.lengthOfYear() - 1999.97) * 13.2555);
        Moment moment3 = MoonPosition.calculateMeeus50(n, bl);
        while (moment3.isBeforeOrEqual(moment2)) {
            moment3 = MoonPosition.calculateMeeus50(++n, bl);
        }
        return moment3;
    }

    private static double normalize(double d) {
        return d - 360.0 * Math.floor(d / 360.0);
    }
}

