/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

public interface GeoLocation {
    public static GeoLocation of(double d, double d2) {
        return GeoLocation.of(d, d2, 0);
    }

    public static GeoLocation of(final double d, final double d2, final int n) {
        if (!Double.isFinite(d)) {
            throw new IllegalArgumentException("Latitude must be a finite value: " + d);
        }
        if (!Double.isFinite(d2)) {
            throw new IllegalArgumentException("Longitude must be a finite value: " + d2);
        }
        if (Double.compare(d, 90.0) > 0 || Double.compare(d, -90.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -90.0 <= latitude <= +90.0: " + d);
        }
        if (Double.compare(d2, 180.0) >= 0 || Double.compare(d2, -180.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -180.0 <= longitude < +180.0: " + d2);
        }
        if (n < 0 || n >= 11000) {
            throw new IllegalArgumentException("Meters out of range 0 <= altitude < +11,000: " + n);
        }
        return new GeoLocation(){

            @Override
            public double getLatitude() {
                return d;
            }

            @Override
            public double getLongitude() {
                return d2;
            }

            @Override
            public int getAltitude() {
                return n;
            }
        };
    }

    public double getLatitude();

    public double getLongitude();

    public int getAltitude();
}

