/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.PlainTime;
import net.time4j.calendar.EthiopianCalendar;
import net.time4j.calendar.EthiopianEra;
import net.time4j.calendar.EthiopianTime;

final class SPXEthio
implements Externalizable {
    static final int DATE = 4;
    static final int TIME = 5;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPXEthio() {
    }

    SPXEthio(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 4: {
                EthiopianCalendar ethiopianCalendar = (EthiopianCalendar)this.obj;
                objectOutput.writeByte(ethiopianCalendar.getEra().ordinal());
                objectOutput.writeInt(ethiopianCalendar.getYear());
                objectOutput.writeByte(ethiopianCalendar.getMonth().getValue());
                objectOutput.writeByte(ethiopianCalendar.getDayOfMonth());
                break;
            }
            case 5: {
                EthiopianTime ethiopianTime = (EthiopianTime)this.obj;
                int n = ethiopianTime.get(EthiopianTime.DIGITAL_HOUR_OF_DAY) * 3600 + ethiopianTime.getMinute() * 60 + ethiopianTime.getSecond();
                objectOutput.writeInt(n);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case 4: {
                EthiopianEra ethiopianEra = EthiopianEra.values()[objectInput.readByte()];
                int n = objectInput.readInt();
                byte by2 = objectInput.readByte();
                byte by3 = objectInput.readByte();
                this.obj = EthiopianCalendar.of(ethiopianEra, n, by2, (int)by3);
                break;
            }
            case 5: {
                int n = objectInput.readInt();
                int n2 = n % 60;
                int n3 = n / 60;
                int n4 = n3 % 60;
                int n5 = n3 / 60;
                PlainTime plainTime = PlainTime.of(n5, n4, n2);
                this.obj = EthiopianTime.from(plainTime);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

