/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.time4j.PlainDate;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.HijriAdjustment;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HijriData;
import net.time4j.calendar.HijriEra;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.EpochDays;
import net.time4j.format.expert.Iso8601Format;

final class AstronomicalHijriData
implements EraYearMonthDaySystem<HijriCalendar> {
    static final AstronomicalHijriData UMALQURA;
    private final String variant;
    private final int adjustment;
    private final String version;
    private final int minYear;
    private final int maxYear;
    private final long minUTC;
    private final long maxUTC;
    private final int[] lengthOfMonth;
    private final long[] firstOfMonth;

    AstronomicalHijriData(HijriData hijriData) {
        this.variant = "islamic-" + hijriData.name();
        this.adjustment = 0;
        this.version = hijriData.version();
        this.minYear = hijriData.minimumYear();
        this.maxYear = hijriData.maximumYear();
        if (this.maxYear < this.minYear) {
            throw new IllegalArgumentException("Maximum year before minimum year.");
        }
        if (hijriData.name().startsWith("islamic")) {
            throw new IllegalArgumentException("Name must not start with \"islamic\".");
        }
        this.minUTC = hijriData.firstGregorianDate().getDaysSinceEpochUTC();
        int n = (this.maxYear - this.minYear + 1) * 12;
        this.lengthOfMonth = new int[n];
        this.firstOfMonth = new long[n];
        long l = 0L;
        int n2 = 0;
        for (int i = this.minYear; i <= this.maxYear; ++i) {
            for (int j = 1; j <= 12; ++j) {
                int n3;
                this.lengthOfMonth[n2] = n3 = hijriData.lengthOfMonth(i, j);
                this.firstOfMonth[n2] = this.minUTC + l;
                l += (long)n3;
                ++n2;
            }
        }
        this.maxUTC = this.minUTC + l - 1L;
    }

    AstronomicalHijriData(String string) throws IOException {
        HijriAdjustment hijriAdjustment = HijriAdjustment.from(string);
        this.variant = string;
        String string2 = hijriAdjustment.getBaseVariant();
        this.adjustment = hijriAdjustment.getValue();
        String string3 = "data/" + string2.replace('-', '_') + ".data";
        URI uRI = ResourceLoader.getInstance().locate("base", AstronomicalHijriData.class, string3);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            inputStream = ResourceLoader.getInstance().load(AstronomicalHijriData.class, string3, true);
        }
        try {
            int n;
            int n2;
            Properties properties = new Properties();
            properties.load(inputStream);
            String string4 = properties.getProperty("type");
            if (!string2.equals(string4)) {
                throw new IOException("Wrong hijri variant: expected=" + string2 + ", found=" + string4);
            }
            this.version = properties.getProperty("version", "1.0");
            String string5 = properties.getProperty("iso-start", "");
            PlainDate plainDate = Iso8601Format.EXTENDED_CALENDAR_DATE.parse(string5);
            this.minUTC = plainDate.get(EpochDays.UTC);
            this.minYear = n2 = Integer.parseInt(properties.getProperty("min", "1"));
            this.maxYear = n = Integer.parseInt(properties.getProperty("max", "0"));
            int n3 = (n - n2 + 1) * 12;
            int[] nArray = new int[n3];
            long[] lArray = new long[n3];
            int n4 = 0;
            long l = this.minUTC;
            for (int i = n2; i <= n; ++i) {
                String string6 = properties.getProperty(String.valueOf(i));
                if (string6 == null) {
                    throw new IOException("Wrong file format: " + string3 + " (missing year=" + i + ")");
                }
                String[] stringArray = string6.split(" ");
                for (int j = 0; j < Math.min(stringArray.length, 12); ++j) {
                    nArray[n4] = Integer.parseInt(stringArray[j]);
                    lArray[n4] = l;
                    l += (long)nArray[n4];
                    ++n4;
                }
                if (stringArray.length >= 12) continue;
                int[] nArray2 = new int[n4];
                long[] lArray2 = new long[n4];
                System.arraycopy(nArray, 0, nArray2, 0, n4);
                System.arraycopy(lArray, 0, lArray2, 0, n4);
                nArray = nArray2;
                lArray = lArray2;
                break;
            }
            this.maxUTC = l - 1L;
            this.lengthOfMonth = nArray;
            this.firstOfMonth = lArray;
        }
        catch (NumberFormatException | ParseException exception) {
            throw new IOException("Wrong file format: " + string3, exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    @Override
    public HijriCalendar transform(long l) {
        long l2 = Math.addExact(l, (long)this.adjustment);
        int n = AstronomicalHijriData.search(l2, this.firstOfMonth);
        if (n >= 0 && (n < this.firstOfMonth.length - 1 || this.firstOfMonth[n] + (long)this.lengthOfMonth[n] > l2)) {
            int n2 = n / 12 + this.minYear;
            int n3 = n % 12 + 1;
            int n4 = (int)(l2 - this.firstOfMonth[n] + 1L);
            return HijriCalendar.of(this.variant, n2, n3, n4);
        }
        throw new IllegalArgumentException("Out of range: " + l);
    }

    @Override
    public long transform(HijriCalendar hijriCalendar) {
        if (!hijriCalendar.getVariant().equals(this.variant)) {
            throw new IllegalArgumentException("Given date does not belong to this calendar system: " + hijriCalendar + " (calendar variants are different).");
        }
        int n = (hijriCalendar.getYear() - this.minYear) * 12 + hijriCalendar.getMonth().getValue() - 1;
        return Math.subtractExact(this.firstOfMonth[n] + (long)hijriCalendar.getDayOfMonth() - 1L, (long)this.adjustment);
    }

    @Override
    public long getMinimumSinceUTC() {
        return Math.subtractExact(this.minUTC, (long)this.adjustment);
    }

    @Override
    public long getMaximumSinceUTC() {
        return Math.subtractExact(this.maxUTC, (long)this.adjustment);
    }

    @Override
    public List<CalendarEra> getEras() {
        HijriEra hijriEra = HijriEra.ANNO_HEGIRAE;
        return Collections.singletonList(hijriEra);
    }

    @Override
    public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
        if (calendarEra != HijriEra.ANNO_HEGIRAE || n < this.minYear || n > this.maxYear || n2 < 1 || n2 > 12 || n3 < 1) {
            return false;
        }
        if ((n - this.minYear) * 12 + n2 - 1 >= this.lengthOfMonth.length) {
            return false;
        }
        return n3 <= this.getLengthOfMonth(calendarEra, n, n2);
    }

    @Override
    public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
        if (calendarEra != HijriEra.ANNO_HEGIRAE) {
            throw new IllegalArgumentException("Wrong era: " + calendarEra);
        }
        int n3 = (n - this.minYear) * 12 + n2 - 1;
        if (n3 < 0 || n3 >= this.lengthOfMonth.length) {
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }
        return this.lengthOfMonth[n3];
    }

    @Override
    public int getLengthOfYear(CalendarEra calendarEra, int n) {
        if (calendarEra != HijriEra.ANNO_HEGIRAE) {
            throw new IllegalArgumentException("Wrong era: " + calendarEra);
        }
        if (n < this.minYear || n > this.maxYear) {
            throw new IllegalArgumentException("Out of bounds: yearOfEra=" + n);
        }
        int n2 = 0;
        for (int i = 1; i <= 12; ++i) {
            int n3 = (n - this.minYear) * 12 + i - 1;
            if (n3 >= this.lengthOfMonth.length) {
                throw new IllegalArgumentException("Year range is not fully covered by underlying data: " + n);
            }
            n2 += this.lengthOfMonth[n3];
        }
        return n2;
    }

    String getVersion() {
        return this.version;
    }

    private static int search(long l, long[] lArray) {
        int n = 0;
        int n2 = lArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (lArray[n3] <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n - 1;
    }

    static {
        try {
            UMALQURA = new AstronomicalHijriData("islamic-umalqura");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

