/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.optimize.gson.FieldSignatureCollector;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineDeserializer;
import proguard.optimize.gson.InlineDeserializers;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.TypeTokenClassBuilder;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;
import proguard.util.MultiValueMap;

public class GsonDeserializationOptimizer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final Map<String, InlineDeserializer> inlineDeserializers = new HashMap<String, InlineDeserializer>();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo deserializationInfo;
    private final boolean supportExposeAnnotation;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private InstructionSequenceBuilder ____;
    private OptimizedJsonInfo.ClassJsonInfo classDeserializationInfo;
    private Map<String, String[]> javaToJsonFieldNames;
    private Map<String, CodeAttributeEditor.Label> caseLabelByJavaFieldName;
    private CodeAttributeEditor.Label endSwitch;

    public GsonDeserializationOptimizer(ClassPool programClassPool, ClassPool libraryClassPool, GsonRuntimeSettings gsonRuntimeSettings, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo deserializationInfo, MultiValueMap<String, String> injectedClassNameMap) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.codeAttributeEditor = codeAttributeEditor;
        this.deserializationInfo = deserializationInfo;
        this.supportExposeAnnotation = gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation;
        this.injectedClassNameMap = injectedClassNameMap;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= 0xFFFFFFFD;
        programClass.u2accessFlags |= 1;
        MemberCounter constructorCounter = new MemberCounter();
        programClass.methodsAccept(new MemberNameFilter("<init>", (MemberVisitor)new MemberDescriptorFilter("()V", (MemberVisitor)new MultiMemberVisitor(new MemberAccessSetter(1), constructorCounter))));
        SimplifiedClassEditor classEditor = new SimplifiedClassEditor(programClass);
        this.____ = new InstructionSequenceBuilder(programClass, this.programClassPool, this.libraryClassPool);
        if (constructorCounter.getCount() == 0) {
            this.addDefaultConstructor(programClass, classEditor);
        }
        int classIndex = this.deserializationInfo.classIndices.get(programClass.getName());
        this.addFromJsonMethod(programClass, classEditor, classIndex);
        this.addFromJsonFieldMethod(programClass, classEditor, classIndex);
        programClass.accept(new MethodLinker());
        classEditor.finishEditing(this.programClassPool, this.libraryClassPool);
    }

    private void addDefaultConstructor(ProgramClass programClass, SimplifiedClassEditor classEditor) {
        classEditor.addMethod(4097, "<init>", "()V", this.____.aload_0().invokespecial(programClass.getSuperName(), "<init>", "()V").return_().instructions()).accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
    }

    private void addFromJsonMethod(ProgramClass programClass, SimplifiedClassEditor classEditor, int classIndex) {
        String methodNameFromJson = "fromJson$" + classIndex;
        ProgramMethod fromJsonMethod = classEditor.addMethod(4097, methodNameFromJson, OptimizedClassConstants.METHOD_TYPE_FROM_JSON, this.____.return_().instructions());
        fromJsonMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        fromJsonMethod.attributesAccept(programClass, new FromJsonCodeAttributeVisitor());
    }

    private void addFromJsonFieldMethod(ProgramClass programClass, SimplifiedClassEditor classEditor, int classIndex) {
        String methodNameFromJsonField = "fromJsonField$" + classIndex;
        ProgramMethod fromJsonFieldMethod = classEditor.addMethod(4100, methodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V", this.____.return_().instructions());
        fromJsonFieldMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        fromJsonFieldMethod.attributesAccept(programClass, new FromJsonFieldCodeAttributeVisitor(this.supportExposeAnnotation));
    }

    static {
        inlineDeserializers.put("B", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Byte.TYPE));
        inlineDeserializers.put("S", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Short.TYPE));
        inlineDeserializers.put("I", new InlineDeserializers.InlinePrimitiveIntegerDeserializer());
        inlineDeserializers.put("Ljava/lang/String;", new InlineDeserializers.InlineStringDeserializer());
    }

    public static class FromJsonFieldCase
    implements Comparable<FromJsonFieldCase> {
        private String javaFieldName;
        private CodeAttributeEditor.Label label;
        private int fieldIndex;

        public FromJsonFieldCase(String javaFieldName, CodeAttributeEditor.Label label, int fieldIndex) {
            this.javaFieldName = javaFieldName;
            this.label = label;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public int compareTo(FromJsonFieldCase fromJsonFieldCase) {
            return this.fieldIndex - fromJsonFieldCase.fieldIndex;
        }
    }

    private class FromJsonFieldCodeAttributeVisitor
    extends SimplifiedVisitor
    implements AttributeVisitor,
    MemberVisitor {
        private int isNullLocalIndex;
        private boolean supportExposeAnnotation;

        FromJsonFieldCodeAttributeVisitor(boolean supportExposeAnnotation) {
            this.supportExposeAnnotation = supportExposeAnnotation;
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            GsonDeserializationOptimizer.this.codeAttributeEditor.reset(1);
            GsonDeserializationOptimizer.this.endSwitch = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            if (GsonDeserializationOptimizer.this.javaToJsonFieldNames.size() > 0) {
                CodeAttributeEditor.Label tokenNotNull = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                CodeAttributeEditor.Label assignIsNull = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                this.isNullLocalIndex = codeAttribute.u2maxLocals;
                GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;").getstatic("com/google/gson/stream/JsonToken", "NULL", "Lcom/google/gson/stream/JsonToken;");
                GsonDeserializationOptimizer.this.____.ifacmpeq(tokenNotNull.offset()).iconst_1().goto_(assignIsNull.offset()).label(tokenNotNull).iconst_0().label(assignIsNull).istore(this.isNullLocalIndex);
                this.generateSwitchTables(clazz);
            }
            if (!clazz.getSuperClass().getName().equals("java/lang/Object")) {
                Integer superClassIndex = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classIndices.get(clazz.getSuperClass().getName());
                String superMethodNameFromJsonField = "fromJsonField$" + superClassIndex;
                GsonDeserializationOptimizer.this.____.aload(0).aload(1).aload(2).iload(3).invokevirtual(clazz.getSuperClass().getName(), superMethodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
            } else {
                GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "skipValue", "()V");
            }
            GsonDeserializationOptimizer.this.____.label(GsonDeserializationOptimizer.this.endSwitch).return_();
            GsonDeserializationOptimizer.this.codeAttributeEditor.replaceInstruction(0, GsonDeserializationOptimizer.this.____.instructions());
            GsonDeserializationOptimizer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }

        private void generateSwitchTables(Clazz clazz) {
            Set<String> exposedJavaFieldNames = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).classDeserializationInfo.exposedJavaFieldNames;
            Set<String> exposedOrAllJavaFieldNames = this.supportExposeAnnotation ? exposedJavaFieldNames : GsonDeserializationOptimizer.this.javaToJsonFieldNames.keySet();
            this.generateSwitchTable(clazz, GsonDeserializationOptimizer.this.javaToJsonFieldNames, exposedOrAllJavaFieldNames);
            if (this.supportExposeAnnotation) {
                CodeAttributeEditor.Label nonExposedCasesEnd = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                GsonDeserializationOptimizer.this.____.aload(1).getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "requireExpose", "Z").ifne(nonExposedCasesEnd.offset());
                HashSet<String> nonExposedJavaFieldNames = new HashSet<String>();
                for (String javaFieldName : GsonDeserializationOptimizer.this.javaToJsonFieldNames.keySet()) {
                    if (exposedJavaFieldNames.contains(javaFieldName)) continue;
                    nonExposedJavaFieldNames.add(javaFieldName);
                }
                this.generateSwitchTable(clazz, GsonDeserializationOptimizer.this.javaToJsonFieldNames, nonExposedJavaFieldNames);
                GsonDeserializationOptimizer.this.____.label(nonExposedCasesEnd);
            }
        }

        private void generateSwitchTable(Clazz clazz, Map<String, String[]> javaToJsonFieldNames, Set<String> javaFieldNamesToProcess) {
            ArrayList<FromJsonFieldCase> fromJsonFieldCases = new ArrayList<FromJsonFieldCase>();
            for (Map.Entry<String, String[]> javaToJsonFieldNameEntry : javaToJsonFieldNames.entrySet()) {
                if (!javaFieldNamesToProcess.contains(javaToJsonFieldNameEntry.getKey())) continue;
                String[] jsonFieldNames = javaToJsonFieldNameEntry.getValue();
                CodeAttributeEditor.Label caseLabel = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                for (String jsonFieldName : jsonFieldNames) {
                    fromJsonFieldCases.add(new FromJsonFieldCase(javaToJsonFieldNameEntry.getKey(), caseLabel, ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.jsonFieldIndices.get(jsonFieldName)));
                }
            }
            Collections.sort(fromJsonFieldCases);
            int[] cases = new int[fromJsonFieldCases.size()];
            int[] jumpOffsets = new int[fromJsonFieldCases.size()];
            GsonDeserializationOptimizer.this.caseLabelByJavaFieldName = new HashMap();
            for (int caseIndex = 0; caseIndex < fromJsonFieldCases.size(); ++caseIndex) {
                FromJsonFieldCase fromJsonFieldCase = (FromJsonFieldCase)fromJsonFieldCases.get(caseIndex);
                cases[caseIndex] = fromJsonFieldCase.fieldIndex;
                jumpOffsets[caseIndex] = fromJsonFieldCase.label.offset();
                GsonDeserializationOptimizer.this.caseLabelByJavaFieldName.put(fromJsonFieldCase.javaFieldName, fromJsonFieldCase.label);
            }
            CodeAttributeEditor.Label defaultCase = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            GsonDeserializationOptimizer.this.____.iload(3).lookupswitch(defaultCase.offset(), cases, jumpOffsets);
            clazz.fieldsAccept(new MemberAccessFilter(0, 4104, this));
            GsonDeserializationOptimizer.this.____.label(defaultCase);
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            CodeAttributeEditor.Label fromJsonFieldCaseLabel = (CodeAttributeEditor.Label)GsonDeserializationOptimizer.this.caseLabelByJavaFieldName.get(programField.getName(programClass));
            if (fromJsonFieldCaseLabel != null) {
                CodeAttributeEditor.Label isNull = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                GsonDeserializationOptimizer.this.____.label(fromJsonFieldCaseLabel).iload(this.isNullLocalIndex).ifeq(isNull.offset());
                String fieldDescriptor = programField.getDescriptor(programClass);
                FieldSignatureCollector signatureAttributeCollector = new FieldSignatureCollector();
                programField.attributesAccept(programClass, signatureAttributeCollector);
                InlineDeserializer inlineDeserializer = (InlineDeserializer)inlineDeserializers.get(fieldDescriptor);
                if (inlineDeserializer != null && inlineDeserializer.canDeserialize(GsonDeserializationOptimizer.this.gsonRuntimeSettings)) {
                    inlineDeserializer.deserialize(programClass, programField, GsonDeserializationOptimizer.this.codeAttributeEditor, GsonDeserializationOptimizer.this.____, GsonDeserializationOptimizer.this.gsonRuntimeSettings);
                } else {
                    String fieldTypeName;
                    String fieldClassName;
                    if (ClassUtil.isInternalPrimitiveType(fieldDescriptor)) {
                        fieldTypeName = fieldClassName = ClassUtil.internalNumericClassNameFromPrimitiveType(fieldDescriptor.charAt(0));
                    } else {
                        fieldClassName = ClassUtil.internalClassNameFromClassType(fieldDescriptor);
                        fieldTypeName = fieldDescriptor;
                    }
                    String typeTokenClassName = null;
                    if (signatureAttributeCollector.getFieldSignature() != null) {
                        ProgramClass typeTokenClass = new TypeTokenClassBuilder(programClass, programField, signatureAttributeCollector.getFieldSignature()).build(GsonDeserializationOptimizer.this.programClassPool);
                        GsonDeserializationOptimizer.this.programClassPool.addClass(typeTokenClass);
                        typeTokenClass.accept(new ClassReferenceInitializer(GsonDeserializationOptimizer.this.programClassPool, GsonDeserializationOptimizer.this.libraryClassPool));
                        typeTokenClassName = typeTokenClass.getName();
                        GsonDeserializationOptimizer.this.injectedClassNameMap.put(programClass.getName(), typeTokenClassName);
                    }
                    if (typeTokenClassName == null) {
                        GsonDeserializationOptimizer.this.____.aload(0).aload(1).ldc(fieldTypeName, GsonDeserializationOptimizer.this.programClassPool.getClass(fieldClassName)).invokevirtual("com/google/gson/Gson", "getAdapter", "(Ljava/lang/Class;)Lcom/google/gson/TypeAdapter;");
                    } else {
                        GsonDeserializationOptimizer.this.____.aload(0).aload(1).new_(typeTokenClassName).dup().invokespecial(typeTokenClassName, "<init>", "()V").invokevirtual("com/google/gson/Gson", "getAdapter", "(Lcom/google/gson/reflect/TypeToken;)Lcom/google/gson/TypeAdapter;");
                    }
                    GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/TypeAdapter", "read", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;").checkcast(fieldTypeName, GsonDeserializationOptimizer.this.programClassPool.getClass(fieldClassName));
                    switch (fieldDescriptor.charAt(0)) {
                        case 'Z': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                            break;
                        }
                        case 'B': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Byte", "byteValue", "()B");
                            break;
                        }
                        case 'C': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Character", "charValue", "()C");
                            break;
                        }
                        case 'S': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Short", "shortValue", "()S");
                            break;
                        }
                        case 'I': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Integer", "intValue", "()I");
                            break;
                        }
                        case 'J': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Long", "longValue", "()J");
                            break;
                        }
                        case 'F': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Float", "floatValue", "()F");
                            break;
                        }
                        case 'D': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Double", "doubleValue", "()D");
                        }
                    }
                    GsonDeserializationOptimizer.this.____.putfield(programClass, programField);
                }
                GsonDeserializationOptimizer.this.____.goto_(GsonDeserializationOptimizer.this.endSwitch.offset());
                GsonDeserializationOptimizer.this.____.label(isNull);
                if (!ClassUtil.isInternalPrimitiveType(fieldDescriptor)) {
                    GsonDeserializationOptimizer.this.____.aload(0).aconst_null().putfield(programClass, programField);
                }
                GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextNull", "()V").goto_(GsonDeserializationOptimizer.this.endSwitch.offset());
            }
        }
    }

    private class FromJsonCodeAttributeVisitor
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private FromJsonCodeAttributeVisitor() {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            GsonDeserializationOptimizer.this.codeAttributeEditor.reset(1);
            GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "beginObject", "()V");
            int nextFieldIndexLocalIndex = codeAttribute.u2maxLocals;
            CodeAttributeEditor.Label startWhile = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label endJsonObject = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            GsonDeserializationOptimizer.this.____.label(startWhile).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "hasNext", "()Z").ifeq(endJsonObject.offset());
            GsonDeserializationOptimizer.this.____.aload(3).aload(2).invokeinterface("proguard/optimize/gson/_OptimizedJsonReader", "b", "(Lcom/google/gson/stream/JsonReader;)I").istore(nextFieldIndexLocalIndex);
            GsonDeserializationOptimizer.this.classDeserializationInfo = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classJsonInfos.get(clazz.getName());
            GsonDeserializationOptimizer.this.javaToJsonFieldNames = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).classDeserializationInfo.javaToJsonFieldNames;
            Integer classIndex = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classIndices.get(clazz.getName());
            String methodNameFromJsonField = "fromJsonField$" + classIndex;
            GsonDeserializationOptimizer.this.____.aload(0).aload(1).aload(2).iload(nextFieldIndexLocalIndex).invokevirtual(clazz.getName(), methodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
            GsonDeserializationOptimizer.this.____.goto_(startWhile.offset());
            GsonDeserializationOptimizer.this.____.label(endJsonObject).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "endObject", "()V").return_();
            GsonDeserializationOptimizer.this.codeAttributeEditor.replaceInstruction(0, GsonDeserializationOptimizer.this.____.instructions());
            GsonDeserializationOptimizer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }
}

