/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import proguard.Configuration;
import proguard.backport.DefaultInterfaceMethodConverter;
import proguard.backport.LambdaExpressionConverter;
import proguard.backport.StaticInterfaceMethodConverter;
import proguard.backport.StringConcatenationConverter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.BootstrapMethodsAttributeShrinker;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVersionSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Backporter {
    private final Configuration configuration;

    public Backporter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, MultiValueMap<String, String> injectedClassNameMap) {
        int targetClassVersion = this.configuration.targetClassVersion;
        if (this.configuration.verbose) {
            System.out.println("Backporting class files...");
        }
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        InstructionCounter replacedStringConcatCounter = new InstructionCounter();
        ClassCounter lambdaExpressionCounter = new ClassCounter();
        MemberCounter staticInterfaceMethodCounter = new MemberCounter();
        MemberCounter defaultInterfaceMethodCounter = new MemberCounter();
        InstructionCounter replacedMethodCallCounter = new InstructionCounter();
        if (targetClassVersion < 0x350000) {
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
            programClassPool.classesAccept(new ClassVersionFilter(0x350000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new MultiClassVisitor(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(codeAttributeEditor, new StringConcatenationConverter(replacedStringConcatCounter, codeAttributeEditor)))), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(programClassPool, libraryClassPool)))))));
        }
        if (targetClassVersion < 0x340000) {
            ClassPool filteredClasses = new ClassPool();
            programClassPool.classesAccept(new ClassVersionFilter(0x340000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new ClassPoolFiller(filteredClasses))))));
            filteredClasses.classesAccept(new MultiClassVisitor(new LambdaExpressionConverter(programClassPool, libraryClassPool, injectedClassNameMap, lambdaExpressionCounter), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(programClassPool, libraryClassPool)));
            ClassPool interfaceClasses = new ClassPool();
            programClassPool.classesAccept(new ClassVersionFilter(0x340000, new ClassAccessFilter(512, 0, new ClassPoolFiller(interfaceClasses))));
            ClassPool modifiedClasses = new ClassPool();
            ClassPoolFiller modifiedClassCollector = new ClassPoolFiller(modifiedClasses);
            interfaceClasses.classesAccept(new MultiClassVisitor(new StaticInterfaceMethodConverter(programClassPool, libraryClassPool, injectedClassNameMap, modifiedClassCollector, staticInterfaceMethodCounter), new DefaultInterfaceMethodConverter(modifiedClassCollector, defaultInterfaceMethodCounter)));
            modifiedClasses.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool));
        }
        if (targetClassVersion < 0x330000) {
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(programClassPool, libraryClassPool);
            Instruction[][][] instructions = new Instruction[][][]{{____.invokestatic("java/util/Objects", "requireNonNull", "(Ljava/lang/Object;)Ljava/lang/Object;").__(), ____.dup().invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;").pop().__()}, {____.invokevirtual("java/util/Throwable", "addSuppressed", "(Ljava/lang/Throwable;)V").__(), ____.pop().pop().__()}};
            Constant[] constants = ____.constants();
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(null, codeAttributeEditor, new InstructionSequencesReplacer(constants, instructions, null, codeAttributeEditor, (InstructionVisitor)replacedMethodCallCounter)))));
        }
        if (targetClassVersion != 0) {
            programClassPool.classesAccept(new ClassVersionSetter(targetClassVersion));
        }
        if (this.configuration.verbose) {
            System.out.println("  Number of converted string concatenations:     " + replacedStringConcatCounter.getCount());
            System.out.println("  Number of converted lambda expressions:        " + lambdaExpressionCounter.getCount());
            System.out.println("  Number of converted static interface methods:  " + staticInterfaceMethodCounter.getCount());
            System.out.println("  Number of converted default interface methods: " + defaultInterfaceMethodCounter.getCount());
            System.out.println("  Number of replaced Java 7+ method calls:       " + replacedMethodCallCounter.getCount());
        }
    }
}

