/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassVersionFilter
implements ClassVisitor {
    private final int minimumClassVersion;
    private final int maximumClassVersion;
    private final ClassVisitor classVisitor;

    public ClassVersionFilter(int minimumClassVersion, ClassVisitor classVisitor) {
        this(minimumClassVersion, Integer.MAX_VALUE, classVisitor);
    }

    public ClassVersionFilter(int minimumClassVersion, int maximumClassVersion, ClassVisitor classVisitor) {
        this.minimumClassVersion = minimumClassVersion;
        this.maximumClassVersion = maximumClassVersion;
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.u4version >= this.minimumClassVersion && programClass.u4version <= this.maximumClassVersion) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }
}

