/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InterfaceDeleter;
import proguard.classfile.editor.SubclassAdder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SubclassFilter;
import proguard.optimize.peephole.ClassMerger;

public class TargetClassChanger
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final boolean DEBUG = false;

    public void visitProgramClass(ProgramClass programClass) {
        Clazz targetClass;
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        boolean[] delete = null;
        for (int index = 0; index < programClass.u2interfacesCount; ++index) {
            Clazz interfaceClass = programClass.getInterface(index);
            if (interfaceClass == null || !programClass.equals(interfaceClass) && !this.containsInterfaceClass(programClass, index, interfaceClass)) continue;
            if (delete == null) {
                delete = new boolean[programClass.u2interfacesCount];
            }
            delete[index] = true;
        }
        if (delete != null) {
            new InterfaceDeleter(delete).visitProgramClass(programClass);
        }
        if ((targetClass = ClassMerger.getTargetClass(programClass)) != null) {
            programClass.u2thisClass = this.addNewClassConstant(programClass, programClass.getName(), programClass);
            programClass.subClasses = null;
        } else {
            ReferencedClassVisitor subclassAdder = new ReferencedClassVisitor(new SubclassFilter(programClass, new SubclassAdder(programClass)));
            programClass.superClassConstantAccept(subclassAdder);
            programClass.interfaceConstantsAccept(subclassAdder);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.referencedClass = this.updateReferencedClass(programField.referencedClass);
        programField.attributesAccept(programClass, this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.updateReferencedClasses(programMethod.referencedClasses);
        programMethod.attributesAccept(programClass, this);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        libraryField.referencedClass = this.updateReferencedClass(libraryField.referencedClass);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.updateReferencedClasses(libraryMethod.referencedClasses);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Clazz referencedClass = stringConstant.referencedClass;
        Clazz newReferencedClass = this.updateReferencedClass(referencedClass);
        if (referencedClass != newReferencedClass) {
            stringConstant.referencedClass = newReferencedClass;
            stringConstant.referencedMember = this.updateReferencedMember(stringConstant.referencedMember, stringConstant.getString(clazz), null, newReferencedClass);
        }
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Clazz referencedClass = refConstant.referencedClass;
        Clazz newReferencedClass = this.updateReferencedClass(referencedClass);
        if (referencedClass != newReferencedClass) {
            refConstant.referencedClass = newReferencedClass;
            refConstant.referencedMember = this.updateReferencedMember(refConstant.referencedMember, refConstant.getName(clazz), refConstant.getType(clazz), newReferencedClass);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.updateReferencedClass(classConstant.referencedClass);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.updateReferencedClasses(signatureAttribute.referencedClasses);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClass = this.updateReferencedClass(localVariableInfo.referencedClass);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.updateReferencedClasses(localVariableTypeInfo.referencedClasses);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.updateReferencedClasses(annotation.referencedClasses);
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        Clazz referencedClass = elementValue.referencedClass;
        Clazz newReferencedClass = this.updateReferencedClass(referencedClass);
        if (referencedClass != newReferencedClass) {
            elementValue.referencedClass = newReferencedClass;
            elementValue.referencedMethod = (Method)this.updateReferencedMember(elementValue.referencedMethod, elementValue.getMethodName(clazz), null, newReferencedClass);
        }
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.visitAnyElementValue(clazz, annotation, constantElementValue);
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.visitAnyElementValue(clazz, annotation, enumConstantElementValue);
        this.updateReferencedClasses(enumConstantElementValue.referencedClasses);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.visitAnyElementValue(clazz, annotation, classElementValue);
        this.updateReferencedClasses(classElementValue.referencedClasses);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.visitAnyElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.visitAnyElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private boolean containsInterfaceClass(Clazz clazz, int interfaceCount, Clazz interfaceClass) {
        for (int index = 0; index < interfaceCount; ++index) {
            if (!interfaceClass.equals(clazz.getInterface(index))) continue;
            return true;
        }
        return false;
    }

    private void updateReferencedClasses(Clazz[] referencedClasses) {
        if (referencedClasses == null) {
            return;
        }
        for (int index = 0; index < referencedClasses.length; ++index) {
            referencedClasses[index] = this.updateReferencedClass(referencedClasses[index]);
        }
    }

    private Clazz updateReferencedClass(Clazz referencedClass) {
        if (referencedClass == null) {
            return null;
        }
        Clazz targetClazz = ClassMerger.getTargetClass(referencedClass);
        return targetClazz != null ? targetClazz : referencedClass;
    }

    private Member updateReferencedMember(Member referencedMember, String name, String type, Clazz newReferencedClass) {
        if (referencedMember == null) {
            return null;
        }
        return referencedMember instanceof Field ? newReferencedClass.findField(name, type) : newReferencedClass.findMethod(name, type);
    }

    private int addNewClassConstant(ProgramClass programClass, String className, Clazz referencedClass) {
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
        int nameIndex = constantPoolEditor.addUtf8Constant(className);
        int classConstantIndex = constantPoolEditor.addConstant(new ClassConstant(nameIndex, referencedClass));
        return classConstantIndex;
    }
}

