/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class SubclassFilter
implements ClassVisitor {
    private final Clazz subclass;
    private final ClassVisitor classVisitor;

    public SubclassFilter(Clazz subclass, ClassVisitor classVisitor) {
        this.subclass = subclass;
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (!this.present(programClass.subClasses)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (!this.present(libraryClass.subClasses)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean present(Clazz[] subclasses) {
        if (subclasses == null) {
            return false;
        }
        for (int index = 0; index < subclasses.length; ++index) {
            if (!subclasses[index].equals(this.subclass)) continue;
            return true;
        }
        return false;
    }
}

