/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class AnnotationUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor,
ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private final UsageMarker usageMarker;
    private boolean attributeUsed;
    private boolean annotationUsed;
    private boolean classUsed;
    private boolean methodUsed;

    public AnnotationUsageMarker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        this.attributeUsed = false;
        annotationsAttribute.annotationsAccept(clazz, this);
        if (this.attributeUsed) {
            this.usageMarker.markAsUsed(annotationsAttribute);
            this.markConstant(clazz, annotationsAttribute.u2attributeNameIndex);
        }
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        this.attributeUsed = false;
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
        if (this.attributeUsed) {
            this.usageMarker.markAsUsed(parameterAnnotationsAttribute);
            this.markConstant(clazz, parameterAnnotationsAttribute.u2attributeNameIndex);
        }
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
        this.usageMarker.markAsUsed(annotationDefaultAttribute);
        this.markConstant(clazz, annotationDefaultAttribute.u2attributeNameIndex);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        if (this.isReferencedClassUsed(annotation)) {
            this.usageMarker.markAsUsed(annotation);
            this.markConstant(clazz, annotation.u2typeIndex);
            annotation.elementValuesAccept(clazz, this);
            this.annotationUsed = true;
            this.attributeUsed = true;
        }
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        if (this.isReferencedMethodUsed(constantElementValue)) {
            this.usageMarker.markAsUsed(constantElementValue);
            this.markConstant(clazz, constantElementValue.u2elementNameIndex);
            this.markConstant(clazz, constantElementValue.u2constantValueIndex);
        }
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        if (this.isReferencedMethodUsed(enumConstantElementValue)) {
            this.classUsed = true;
            enumConstantElementValue.referencedClassesAccept(this);
            if (this.classUsed) {
                this.usageMarker.markAsUsed(enumConstantElementValue);
                this.markConstant(clazz, enumConstantElementValue.u2elementNameIndex);
                this.markConstant(clazz, enumConstantElementValue.u2typeNameIndex);
                this.markConstant(clazz, enumConstantElementValue.u2constantNameIndex);
            }
        }
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        if (this.isReferencedMethodUsed(classElementValue)) {
            this.classUsed = true;
            classElementValue.referencedClassesAccept(this);
            if (this.classUsed) {
                this.usageMarker.markAsUsed(classElementValue);
                this.markConstant(clazz, classElementValue.u2elementNameIndex);
                this.markConstant(clazz, classElementValue.u2classInfoIndex);
            }
        }
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        if (this.isReferencedMethodUsed(annotationElementValue)) {
            boolean oldAnnotationUsed = this.annotationUsed;
            this.annotationUsed = false;
            annotationElementValue.annotationAccept(clazz, this);
            if (this.annotationUsed) {
                this.usageMarker.markAsUsed(annotationElementValue);
                this.markConstant(clazz, annotationElementValue.u2elementNameIndex);
            }
            this.annotationUsed = oldAnnotationUsed;
        }
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        if (this.isReferencedMethodUsed(arrayElementValue)) {
            arrayElementValue.elementValuesAccept(clazz, annotation, this);
            this.usageMarker.markAsUsed(arrayElementValue);
            this.markConstant(clazz, arrayElementValue.u2elementNameIndex);
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.usageMarker.markAsUsed(constant);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.classUsed = this.usageMarker.isUsed(classConstant);
        if (!this.classUsed) {
            this.classUsed = true;
            classConstant.referencedClassAccept(this);
            if (this.classUsed) {
                this.usageMarker.markAsUsed(classConstant);
                this.markConstant(clazz, classConstant.u2nameIndex);
            }
        }
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.classUsed = this.usageMarker.isUsed(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.classUsed = true;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.methodUsed = this.usageMarker.isUsed(programMethod);
    }

    public void visitLibraryMethod(LibraryClass LibraryClass2, LibraryMethod libraryMethod) {
        this.classUsed = true;
    }

    private boolean isReferencedClassUsed(Annotation annotation) {
        this.classUsed = true;
        annotation.referencedClassAccept(this);
        return this.classUsed;
    }

    private boolean isReferencedMethodUsed(ElementValue elementValue) {
        this.methodUsed = true;
        elementValue.referencedMethodAccept(this);
        return this.methodUsed;
    }

    private void markConstant(Clazz clazz, int index) {
        if (index > 0) {
            clazz.constantPoolEntryAccept(index, this);
        }
    }
}

