/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationSimplifier
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final int POS_ZERO_FLOAT_BITS = Float.floatToIntBits(0.0f);
    private static final long POS_ZERO_DOUBLE_BITS = Double.doubleToLongBits(0.0);
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false);

    public EvaluationSimplifier() {
        this(new PartialEvaluator(), null);
    }

    public EvaluationSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor extraInstructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while simplifying instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case -128: 
            case -126: 
            case -120: 
            case -117: 
            case -114: 
            case -111: 
            case -110: 
            case -109: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                this.replaceIntegerPushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case -127: 
            case -125: 
            case -123: 
            case -116: 
            case -113: 
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                this.replaceLongPushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case -122: 
            case -119: 
            case -112: 
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: {
                this.replaceFloatPushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case -121: 
            case -118: 
            case -115: 
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: {
                this.replaceDoublePushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case 50: {
                this.replaceReferencePushInstruction(clazz, offset, simpleInstruction);
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int variableIndex = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.replaceIntegerPushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.replaceLongPushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.replaceFloatPushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.replaceDoublePushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.replaceReferencePushInstruction(clazz, offset, variableInstruction);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.deleteReferencePopInstruction(clazz, offset, variableInstruction);
                break;
            }
            case -87: {
                this.replaceBranchInstruction(clazz, offset, variableInstruction);
            }
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: 
            case -76: {
                this.replaceAnyPushInstruction(clazz, offset, constantInstruction);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                if (constantInstruction.stackPushCount(clazz) <= 0 || this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, constantInstruction)) break;
                this.replaceAnyPushInstruction(clazz, offset, constantInstruction);
                break;
            }
            case -64: {
                this.replaceReferencePushInstruction(clazz, offset, constantInstruction);
            }
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -89: 
            case -56: {
                break;
            }
            case -88: 
            case -55: {
                this.replaceJsrInstruction(clazz, offset, branchInstruction);
                break;
            }
            default: {
                this.replaceBranchInstruction(clazz, offset, branchInstruction);
            }
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        this.replaceBranchInstruction(clazz, offset, switchInstruction);
        if (!this.codeAttributeEditor.isModified(offset)) {
            this.replaceSwitchInstruction(clazz, offset, switchInstruction);
        }
    }

    private void replaceAnyPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            switch (pushedValue.computationalType()) {
                case 1: {
                    this.replaceIntegerPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 2: {
                    this.replaceLongPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 3: {
                    this.replaceFloatPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 4: {
                    this.replaceDoublePushInstruction(clazz, offset, instruction);
                    break;
                }
                case 5: {
                    this.replaceReferencePushInstruction(clazz, offset, instruction);
                }
            }
        }
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceIntegerPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            int value = pushedValue.integerValue().value();
            if (value << 16 >> 16 == value) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)17, value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction replacementInstruction = new ConstantInstruction(18, constantPoolEditor.addIntegerConstant(value)).shrink();
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)21, variableIndex);
                break;
            }
        }
    }

    private void replaceLongPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceLongPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceLongPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            long value = pushedValue.longValue().value();
            if (value == 0L || value == 1L) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)9, (int)value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction replacementInstruction = new ConstantInstruction(20, constantPoolEditor.addLongConstant(value)).shrink();
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex)) || variables.load(variableIndex + 1) == null || variables.load(variableIndex + 1).computationalType() != 7) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)22, variableIndex);
            }
        }
    }

    private void replaceFloatPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceFloatPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceFloatPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            float value = pushedValue.floatValue().value();
            if (value == 0.0f && Float.floatToIntBits(value) == POS_ZERO_FLOAT_BITS || value == 1.0f || value == 2.0f) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)11, (int)value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction replacementInstruction = new ConstantInstruction(18, constantPoolEditor.addFloatConstant(value)).shrink();
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)23, variableIndex);
            }
        }
    }

    private void replaceDoublePushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceDoublePushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceDoublePushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            double value = pushedValue.doubleValue().value();
            if (value == 0.0 && Double.doubleToLongBits(value) == POS_ZERO_DOUBLE_BITS || value == 1.0) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)14, (int)value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction replacementInstruction = new ConstantInstruction(20, constantPoolEditor.addDoubleConstant(value)).shrink();
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex)) || variables.load(variableIndex + 1) == null || variables.load(variableIndex + 1).computationalType() != 7) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)24, variableIndex);
            }
        }
    }

    private void replaceReferencePushInstruction(Clazz clazz, int offset, Instruction instruction) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)1, 0);
        }
    }

    private void replaceConstantPushInstruction(Clazz clazz, int offset, Instruction instruction, byte replacementOpcode, int value) {
        Instruction replacementInstruction = new SimpleInstruction(replacementOpcode, value).shrink();
        this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
    }

    private void replaceVariablePushInstruction(Clazz clazz, int offset, Instruction instruction, byte replacementOpcode, int variableIndex) {
        Instruction replacementInstruction = new VariableInstruction(replacementOpcode, variableIndex).shrink();
        this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
    }

    private void replaceJsrInstruction(Clazz clazz, int offset, BranchInstruction branchInstruction) {
        int subroutineStart = offset + branchInstruction.branchOffset;
        if (!this.partialEvaluator.isSubroutineReturning(subroutineStart) || this.partialEvaluator.branchOrigins(subroutineStart).instructionOffsetCount() == 1) {
            this.replaceBranchInstruction(clazz, offset, branchInstruction);
        } else if (!this.partialEvaluator.isTraced(offset + branchInstruction.length(offset))) {
            this.replaceByInfiniteLoop(clazz, offset + branchInstruction.length(offset), branchInstruction);
        }
    }

    private void deleteReferencePopInstruction(Clazz clazz, int offset, Instruction instruction) {
        if (this.partialEvaluator.isSubroutineStart(offset) && (!this.partialEvaluator.isSubroutineReturning(offset) || this.partialEvaluator.branchOrigins(offset).instructionOffsetCount() == 1)) {
            this.codeAttributeEditor.deleteInstruction(offset);
        }
    }

    private void replaceBranchInstruction(Clazz clazz, int offset, Instruction instruction) {
        int branchOffset;
        InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
        if (branchTargets != null && branchTargets.instructionOffsetCount() == 1 && (branchOffset = branchTargets.instructionOffset(0) - offset) != instruction.length(offset)) {
            Instruction replacementInstruction = new BranchInstruction(-56, branchOffset).shrink();
            this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
        }
    }

    private void replaceSwitchInstruction(Clazz clazz, int offset, SwitchInstruction switchInstruction) {
        InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
        int defaultOffset = branchTargets.instructionOffset(branchTargets.instructionOffsetCount() - 1) - offset;
        SwitchInstruction replacementInstruction = null;
        int[] jumpOffsets = switchInstruction.jumpOffsets;
        for (int index = 0; index < jumpOffsets.length; ++index) {
            if (branchTargets.contains(offset + jumpOffsets[index])) continue;
            jumpOffsets[index] = defaultOffset;
            replacementInstruction = switchInstruction;
        }
        if (!branchTargets.contains(offset + switchInstruction.defaultOffset)) {
            switchInstruction.defaultOffset = defaultOffset;
            replacementInstruction = switchInstruction;
        }
        if (replacementInstruction != null) {
            this.replaceInstruction(clazz, offset, switchInstruction, replacementInstruction);
        }
    }

    private void replaceByInfiniteLoop(Clazz clazz, int offset, Instruction instruction) {
        BranchInstruction replacementInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void replaceInstruction(Clazz clazz, int offset, Instruction instruction, Instruction replacementInstruction) {
        int popCount = instruction.stackPopCount(clazz) - replacementInstruction.stackPopCount(clazz);
        this.insertPopInstructions(offset, popCount);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void insertPopInstructions(int offset, int popCount) {
        switch (popCount) {
            case 0: {
                break;
            }
            case 1: {
                SimpleInstruction popInstruction = new SimpleInstruction(87);
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstruction);
                break;
            }
            case 2: {
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstruction);
                break;
            }
            default: {
                Instruction[] popInstructions = new Instruction[popCount / 2 + popCount % 2];
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                for (int index = 0; index < popCount / 2; ++index) {
                    popInstructions[index] = popInstruction;
                }
                if (popCount % 2 == 1) {
                    popInstruction = new SimpleInstruction(87);
                    popInstructions[popCount / 2] = popInstruction;
                }
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstructions);
                break;
            }
        }
    }
}

