/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class BranchTargetFinder
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    public static final int UNKNOWN = -1;
    public static final int NO_SUBROUTINE = -2;
    private static final short INSTRUCTION = 1;
    private static final short BRANCH_ORIGIN = 2;
    private static final short BRANCH_TARGET = 4;
    private static final short AFTER_BRANCH = 8;
    private static final short EXCEPTION_START = 16;
    private static final short EXCEPTION_END = 32;
    private static final short EXCEPTION_HANDLER = 64;
    private static final short SUBROUTINE_INVOCATION = 128;
    private static final short SUBROUTINE_RETURNING = 256;
    private static final int MAXIMUM_CREATION_OFFSETS = 32;
    private short[] instructionMarks = new short[1025];
    private int[] subroutineStarts = new int[1024];
    private int[] subroutineEnds = new int[1024];
    private int[] creationOffsets = new int[1024];
    private int[] initializationOffsets = new int[1024];
    private int superInitializationOffset;
    private boolean containsSubroutines;
    private boolean repeat;
    private int currentSubroutineStart;
    private int[] recentCreationOffsets = new int[32];
    private int recentCreationOffsetIndex;
    private boolean isInitializer;

    public boolean isInstruction(int offset) {
        return (this.instructionMarks[offset] & 1) != 0;
    }

    public boolean isTarget(int offset) {
        return offset == 0 || (this.instructionMarks[offset] & 0x74) != 0;
    }

    public boolean isBranchOrigin(int offset) {
        return (this.instructionMarks[offset] & 2) != 0;
    }

    public boolean isBranchTarget(int offset) {
        return (this.instructionMarks[offset] & 4) != 0;
    }

    public boolean isAfterBranch(int offset) {
        return (this.instructionMarks[offset] & 8) != 0;
    }

    public boolean isExceptionStart(int offset) {
        return (this.instructionMarks[offset] & 0x10) != 0;
    }

    public boolean isExceptionEnd(int offset) {
        return (this.instructionMarks[offset] & 0x20) != 0;
    }

    public boolean isExceptionHandler(int offset) {
        return (this.instructionMarks[offset] & 0x40) != 0;
    }

    public boolean isSubroutineInvocation(int offset) {
        return (this.instructionMarks[offset] & 0x80) != 0;
    }

    public boolean isSubroutineStart(int offset) {
        return this.subroutineStarts[offset] == offset;
    }

    public boolean isSubroutine(int offset) {
        return this.subroutineStarts[offset] >= 0;
    }

    public boolean isSubroutineReturning(int offset) {
        return (this.instructionMarks[offset] & 0x100) != 0;
    }

    public int subroutineStart(int offset) {
        return this.subroutineStarts[offset];
    }

    public int subroutineEnd(int offset) {
        return this.subroutineEnds[offset];
    }

    public boolean isNew(int offset) {
        return this.initializationOffsets[offset] != -2;
    }

    public int initializationOffset(int offset) {
        return this.initializationOffsets[offset];
    }

    public boolean isInitializer() {
        return this.superInitializationOffset != -2;
    }

    public int superInitializationOffset() {
        return this.superInitializationOffset;
    }

    public boolean isInitializer(int offset) {
        return this.creationOffsets[offset] != -2;
    }

    public int creationOffset(int offset) {
        return this.creationOffsets[offset];
    }

    public boolean containsSubroutines() {
        return this.containsSubroutines;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.subroutineStarts.length < codeLength) {
            this.instructionMarks = new short[codeLength + 1];
            this.subroutineStarts = new int[codeLength];
            this.subroutineEnds = new int[codeLength];
            this.creationOffsets = new int[codeLength];
            this.initializationOffsets = new int[codeLength];
            Arrays.fill(this.subroutineStarts, 0, codeLength, -1);
            Arrays.fill(this.subroutineEnds, 0, codeLength, -1);
            Arrays.fill(this.creationOffsets, 0, codeLength, -2);
            Arrays.fill(this.initializationOffsets, 0, codeLength, -2);
        } else {
            Arrays.fill(this.instructionMarks, 0, codeLength, (short)0);
            Arrays.fill(this.subroutineStarts, 0, codeLength, -1);
            Arrays.fill(this.subroutineEnds, 0, codeLength, -1);
            Arrays.fill(this.creationOffsets, 0, codeLength, -2);
            Arrays.fill(this.initializationOffsets, 0, codeLength, -2);
            this.instructionMarks[codeLength] = 0;
        }
        this.superInitializationOffset = -2;
        this.containsSubroutines = false;
        do {
            this.repeat = false;
            this.currentSubroutineStart = -2;
            this.recentCreationOffsetIndex = 0;
            if (method.getName(clazz).equals("<init>")) {
                this.recentCreationOffsets[this.recentCreationOffsetIndex++] = -1;
            }
            codeAttribute.instructionsAccept(clazz, method, this);
        } while (this.repeat);
        this.instructionMarks[codeLength] = 4;
        codeAttribute.exceptionsAccept(clazz, method, this);
        if (this.containsSubroutines) {
            int subroutineStart;
            int offset;
            int previousSubroutineStart = -2;
            for (offset = 0; offset < codeLength; ++offset) {
                if (!this.isInstruction(offset)) continue;
                subroutineStart = this.subroutineStarts[offset];
                if (subroutineStart >= 0 && this.isSubroutineReturning(offset)) {
                    int n = subroutineStart;
                    this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x100);
                }
                if (previousSubroutineStart >= 0) {
                    this.subroutineEnds[previousSubroutineStart] = offset;
                }
                previousSubroutineStart = subroutineStart;
            }
            if (previousSubroutineStart >= 0) {
                this.subroutineEnds[previousSubroutineStart] = codeLength;
            }
            for (offset = 0; offset < codeLength; ++offset) {
                if (!this.isSubroutine(offset)) continue;
                subroutineStart = this.subroutineStarts[offset];
                if (this.isSubroutineReturning(subroutineStart)) {
                    int n = offset;
                    this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x100);
                }
                this.subroutineEnds[offset] = this.subroutineEnds[subroutineStart];
            }
        }
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        byte opcode = simpleInstruction.opcode;
        if (opcode == -84 || opcode == -83 || opcode == -82 || opcode == -81 || opcode == -80 || opcode == -65) {
            this.markBranchOrigin(offset);
            this.markAfterBranchOrigin(offset + simpleInstruction.length(offset));
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        if (constantInstruction.opcode == -69) {
            this.recentCreationOffsets[this.recentCreationOffsetIndex++] = offset;
        } else {
            this.isInitializer = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.isInitializer) {
                int recentCreationOffset;
                this.creationOffsets[offset] = recentCreationOffset = this.recentCreationOffsets[--this.recentCreationOffsetIndex];
                if (recentCreationOffset == -1) {
                    this.superInitializationOffset = offset;
                } else {
                    this.initializationOffsets[recentCreationOffset] = offset;
                }
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        if (variableInstruction.opcode == -87) {
            this.containsSubroutines = true;
            this.markBranchOrigin(offset);
            int n2 = offset;
            this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x100);
            this.markAfterBranchOrigin(offset + variableInstruction.length(offset));
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        int branchOffset = branchInstruction.branchOffset;
        int targetOffset = offset + branchOffset;
        this.markBranchOrigin(offset);
        this.checkSubroutine(offset);
        this.markBranchTarget(offset, branchOffset);
        byte opcode = branchInstruction.opcode;
        if (opcode == -88 || opcode == -55) {
            this.containsSubroutines = true;
            int n = offset;
            this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x80);
            this.markBranchSubroutineStart(offset, branchOffset, targetOffset);
        } else if (this.currentSubroutineStart != -1) {
            this.markBranchSubroutineStart(offset, branchOffset, this.currentSubroutineStart);
        }
        if (opcode == -89 || opcode == -56) {
            this.markAfterBranchOrigin(offset + branchInstruction.length(offset));
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        this.markBranchOrigin(offset);
        this.checkSubroutine(offset);
        this.markBranch(offset, switchInstruction.defaultOffset);
        this.markBranches(offset, switchInstruction.jumpOffsets);
        this.markAfterBranchOrigin(offset + switchInstruction.length(offset));
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.isInitializer = methodrefConstant.getName(clazz).equals("<init>");
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startPC;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x10);
        int n2 = exceptionInfo.u2endPC;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x20);
        int n3 = exceptionInfo.u2handlerPC;
        this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 0x40);
    }

    private void markBranches(int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            this.markBranch(offset, jumpOffsets[index]);
        }
    }

    private void markBranch(int offset, int jumpOffset) {
        this.markBranchTarget(offset, jumpOffset);
        if (this.currentSubroutineStart != -1) {
            this.markBranchSubroutineStart(offset, jumpOffset, this.currentSubroutineStart);
        }
    }

    private void markBranchOrigin(int offset) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 3);
    }

    private void markBranchTarget(int offset, int jumpOffset) {
        int targetOffset;
        int n = targetOffset = offset + jumpOffset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 4);
    }

    private void markBranchSubroutineStart(int offset, int jumpOffset, int subroutineStart) {
        int targetOffset = offset + jumpOffset;
        if (this.subroutineStarts[targetOffset] == -1) {
            if (jumpOffset < 0) {
                if (subroutineStart > targetOffset) {
                    subroutineStart = targetOffset;
                }
                this.repeat = true;
            }
            this.subroutineStarts[targetOffset] = subroutineStart;
        }
    }

    private void markAfterBranchOrigin(int nextOffset) {
        int n = nextOffset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 8);
        this.currentSubroutineStart = -1;
    }

    private void checkSubroutine(int offset) {
        if (this.subroutineStarts[offset] != -1) {
            this.currentSubroutineStart = this.subroutineStarts[offset];
        } else if (this.currentSubroutineStart != -1) {
            this.subroutineStarts[offset] = this.currentSubroutineStart;
            if (this.currentSubroutineStart >= 0) {
                this.subroutineEnds[this.currentSubroutineStart] = offset;
            }
        }
    }
}

