/*
 * Decompiled with CFR 0.152.
 */
package net.ricecode.similarity;

import net.ricecode.similarity.SimilarityStrategy;

public class LevenshteinDistanceStrategy
implements SimilarityStrategy {
    public double score(String first, String second) {
        int maxLength = Math.max(first.length(), second.length());
        if (maxLength == 0) {
            return 1.0;
        }
        return (double)(maxLength - this.computeEditDistance(first, second)) / (double)maxLength;
    }

    protected int computeEditDistance(String first, String second) {
        first = first.toLowerCase();
        second = second.toLowerCase();
        int[] costs = new int[second.length() + 1];
        for (int i = 0; i <= first.length(); ++i) {
            int previousValue = i;
            for (int j = 0; j <= second.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int useValue = costs[j - 1];
                if (first.charAt(i - 1) != second.charAt(j - 1)) {
                    useValue = Math.min(Math.min(useValue, previousValue), costs[j]) + 1;
                }
                costs[j - 1] = previousValue;
                previousValue = useValue;
            }
            if (i <= 0) continue;
            costs[second.length()] = previousValue;
        }
        return costs[second.length()];
    }
}

