/*
 * Decompiled with CFR 0.152.
 */
package net.ricecode.similarity;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import net.ricecode.similarity.SimilarityStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiceCoefficientStrategy
implements SimilarityStrategy {
    @Override
    public double score(String first, String second) {
        Set<String> s1 = this.splitIntoBigrams(first);
        Set<String> s2 = this.splitIntoBigrams(second);
        int n1 = s1.size();
        int n2 = s2.size();
        s1.retainAll(s2);
        int nt = s1.size();
        return 2.0 * (double)nt / (double)(n1 + n2);
    }

    private Set<String> splitIntoBigrams(String s) {
        ArrayList<String> bigrams = new ArrayList<String>();
        if (s.length() < 2) {
            bigrams.add(s);
        } else {
            for (int i = 1; i < s.length(); ++i) {
                StringBuilder sb = new StringBuilder();
                sb.append(s.charAt(i - 1));
                sb.append(s.charAt(i));
                bigrams.add(sb.toString());
            }
        }
        return new TreeSet<String>(bigrams);
    }
}

