/*
 * Decompiled with CFR 0.152.
 */
package net.raidstone.wgevents.events;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegionsEnteredEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled = false;
    private final UUID uuid;
    private final Set<ProtectedRegion> regions;
    private final Set<String> regionsNames;

    public RegionsEnteredEvent(UUID playerUUID, @Nullable Set<ProtectedRegion> regions) {
        this.uuid = playerUUID;
        this.regionsNames = new HashSet<String>();
        this.regions = new HashSet<ProtectedRegion>();
        if (regions != null) {
            this.regions.addAll(regions);
            for (ProtectedRegion region : regions) {
                this.regionsNames.add(region.getId());
            }
        }
    }

    @Contract(pure=true)
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @NotNull
    public Set<ProtectedRegion> getRegions() {
        return this.regions;
    }

    @NotNull
    public Set<String> getRegionsNames() {
        return this.regionsNames;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

