/*
 * Decompiled with CFR 0.152.
 */
package net.raidstone.wgevents.events;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegionLeftEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled = false;
    private final UUID uuid;
    private final ProtectedRegion region;
    private final String regionName;

    public RegionLeftEvent(UUID playerUUID, @NotNull ProtectedRegion region) {
        this.uuid = playerUUID;
        this.region = region;
        this.regionName = region.getId();
    }

    @Contract(pure=true)
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @NotNull
    public String getRegionName() {
        return this.regionName;
    }

    @NotNull
    public ProtectedRegion getRegion() {
        return this.region;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

