/*
 * Decompiled with CFR 0.152.
 */
package net.raidstone.wgevents;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.raidstone.wgevents.Entry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldGuardEvents
extends JavaPlugin
implements Listener {
    static RegionContainer container;

    public void onEnable() {
        Logger log = Bukkit.getLogger();
        PluginManager pm = Bukkit.getPluginManager();
        Plugin p = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (p == null) {
            log.severe("[WorldGuardEvents] WorldGuard wasn't found. Disabling WorldGuardEvents.");
            pm.disablePlugin((Plugin)this);
            return;
        }
        String version = WorldGuard.getVersion();
        if (version.isEmpty()) {
            log.severe("[WorldGuardEvents] WorldGuard's version not detected. Are you sure it's installed properly ?");
            log.severe("[WorldGuardEvents] Disabling WorldGuardEvents.");
            pm.disablePlugin((Plugin)this);
            return;
        }
        if (!version.startsWith("7.")) {
            log.warning("[WorldGuardEvents] Detected WorldGuard version \"" + version + "\".");
            log.warning("[WorldGuardEvents] This plugin is meant to work with WorldGuard version \"7.0.0\" or higher,");
            log.warning("[WorldGuardEvents] and may not work properly with any other major revision.");
            log.warning("[WorldGuardEvents] Please update WorldGuard if your version is below \"7.0.0\" or wait for");
            log.warning("[WorldGuardEvents] an update of WorldGuardEvents to support WorldGuard " + version + ".");
        }
        if (!WorldGuard.getInstance().getPlatform().getSessionManager().registerHandler((Handler.Factory)Entry.factory, null)) {
            log.severe("[WorldGuardEvents] Could not register the entry handler !");
            log.severe("[WorldGuardEvents] Please report this error. The plugin will now be disabled.");
            pm.disablePlugin((Plugin)this);
            return;
        }
        container = WorldGuard.getInstance().getPlatform().getRegionContainer();
    }

    public void onDisable() {
        container = null;
    }

    @Nonnull
    public static Set<ProtectedRegion> getRegions(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null || !player.isOnline()) {
            return Collections.emptySet();
        }
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)player.getLocation()));
        return set.getRegions();
    }

    @Nonnull
    public static Set<String> getRegionsNames(UUID playerUUID) {
        return WorldGuardEvents.getRegions(playerUUID).stream().map(ProtectedRegion::getId).collect(Collectors.toSet());
    }

    public static boolean isPlayerInAllRegions(UUID playerUUID, Set<String> regionNames) {
        Set<String> regions = WorldGuardEvents.getRegionsNames(playerUUID);
        if (regions.isEmpty()) {
            throw new IllegalArgumentException("You need to check for at least one region !");
        }
        return regions.containsAll(regionNames.stream().map(String::toLowerCase).collect(Collectors.toSet()));
    }

    public static boolean isPlayerInAnyRegion(UUID playerUUID, Set<String> regionNames) {
        Set<String> regions = WorldGuardEvents.getRegionsNames(playerUUID);
        if (regions.isEmpty()) {
            throw new IllegalArgumentException("You need to check for at least one region !");
        }
        for (String region : regionNames) {
            if (!regions.contains(region.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerInAnyRegion(UUID playerUUID, String ... regionName) {
        return WorldGuardEvents.isPlayerInAnyRegion(playerUUID, new HashSet<String>(Arrays.asList(regionName)));
    }

    public static boolean isPlayerInAllRegions(UUID playerUUID, String ... regionName) {
        return WorldGuardEvents.isPlayerInAllRegions(playerUUID, new HashSet<String>(Arrays.asList(regionName)));
    }
}

