/*
 * Decompiled with CFR 0.152.
 */
package net.raidstone.wgevents;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.raidstone.wgevents.events.RegionEnteredEvent;
import net.raidstone.wgevents.events.RegionLeftEvent;
import net.raidstone.wgevents.events.RegionsEnteredEvent;
import net.raidstone.wgevents.events.RegionsLeftEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class Listeners
implements Listener {
    private RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
    private HashMap<UUID, Set<ProtectedRegion>> playerRegions = new HashMap();

    private Set<ProtectedRegion> getRegions(UUID u) {
        Player p = Bukkit.getPlayer((UUID)u);
        if (p == null) {
            return new HashSet<ProtectedRegion>();
        }
        com.sk89q.worldedit.util.Location l = BukkitAdapter.adapt((Location)p.getLocation());
        World w = BukkitAdapter.adapt((org.bukkit.World)p.getLocation().getWorld());
        RegionQuery q = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        ApplicableRegionSet ars = q.getApplicableRegions(l);
        return ars.getRegions();
    }

    void changeRegions(UUID u, Set<ProtectedRegion> actual) {
        Event re;
        this.playerRegions.putIfAbsent(u, new HashSet());
        int previousSize = this.playerRegions.get(u).size();
        int actualSize = actual.size();
        if (actual.size() == this.playerRegions.get(u).size() && actual.containsAll((Collection)this.playerRegions.get(u))) {
            return;
        }
        Set<ProtectedRegion> previous = this.playerRegions.get(u);
        boolean joined = false;
        boolean left = false;
        if (actualSize == previousSize) {
            joined = true;
            left = true;
        } else if (actualSize < previousSize) {
            left = true;
        } else {
            joined = true;
        }
        if (left) {
            HashSet<ProtectedRegion> leftregions = new HashSet<ProtectedRegion>(previous);
            leftregions.removeAll(actual);
            RegionsLeftEvent rle = new RegionsLeftEvent(u, leftregions);
            Bukkit.getPluginManager().callEvent((Event)rle);
            for (ProtectedRegion region : leftregions) {
                re = new RegionLeftEvent(u, region);
                Bukkit.getPluginManager().callEvent(re);
            }
        }
        if (joined) {
            HashSet<ProtectedRegion> enteredregions = new HashSet<ProtectedRegion>(actual);
            enteredregions.removeAll(previous);
            RegionsEnteredEvent ree = new RegionsEnteredEvent(u, enteredregions);
            Bukkit.getPluginManager().callEvent((Event)ree);
            for (ProtectedRegion region : enteredregions) {
                re = new RegionEnteredEvent(u, region);
                Bukkit.getPluginManager().callEvent(re);
            }
        }
        this.playerRegions.put(u, actual);
    }

    private void quit(UUID u) {
        HashSet<ProtectedRegion> empty = new HashSet<ProtectedRegion>();
        this.changeRegions(u, empty);
    }

    private void changeWorld(UUID u) {
        this.changeRegions(u, this.getRegions(u));
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.changeRegions(event.getPlayer().getUniqueId(), this.getRegions(event.getPlayer().getUniqueId()));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.quit(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        this.quit(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.changeRegions(uuid, this.getRegions(uuid));
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        this.quit(event.getEntity().getUniqueId());
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.changeWorld(event.getPlayer().getUniqueId());
    }
}

