/*
 * Decompiled with CFR 0.152.
 */
package net.projecttl.inventory.gui;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.projecttl.inventory.InventoryGUI;
import net.projecttl.inventory.gui.InventoryBuilder;
import net.projecttl.inventory.gui.LinkedInventoryBuilder;
import net.projecttl.inventory.util.InventoryType;
import net.projecttl.inventory.util.LinkedSlot;
import net.projecttl.inventory.util.ObservableHashMap;
import net.projecttl.inventory.util.SlotHandler;
import org.bukkit.Bukkit;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010'\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020\u000eH\u0016J\t\u0010)\u001a\u00020\u0004H\u00c6\u0003J\t\u0010*\u001a\u00020\u0006H\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J'\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\b\u0010-\u001a\u00020\u000eH\u0016J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u00020!H\u00d6\u0001J\u0010\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u000205H\u0003J\u0010\u00106\u001a\u00020\u000e2\u0006\u00104\u001a\u000207H\u0003J\u0010\u00108\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\rH\u0003J\u0010\u00109\u001a\u00020\u000e2\u0006\u00104\u001a\u00020:H\u0003J!\u0010;\u001a\u00020\u000e2\u0017\u0010<\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010=\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?H\u0016J1\u0010=\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?2\u0017\u0010<\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0016J\t\u0010@\u001a\u00020AH\u00d6\u0001R(\u0010\n\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006B"}, d2={"Lnet/projecttl/inventory/gui/LinkedInventoryBuilder;", "Lorg/bukkit/event/Listener;", "Lnet/projecttl/inventory/gui/InventoryBuilder;", "player", "Lorg/bukkit/entity/Player;", "slotType", "Lnet/projecttl/inventory/util/InventoryType;", "title", "Lnet/kyori/adventure/text/Component;", "(Lorg/bukkit/entity/Player;Lnet/projecttl/inventory/util/InventoryType;Lnet/kyori/adventure/text/Component;)V", "closeHandlers", "Ljava/util/ArrayList;", "Lkotlin/Function1;", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "", "Lkotlin/ExtensionFunctionType;", "getCloseHandlers", "()Ljava/util/ArrayList;", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "<set-?>", "Lorg/bukkit/inventory/Inventory;", "inventory", "getInventory", "()Lorg/bukkit/inventory/Inventory;", "getPlayer", "()Lorg/bukkit/entity/Player;", "getSlotType", "()Lnet/projecttl/inventory/util/InventoryType;", "slots", "Lnet/projecttl/inventory/util/ObservableHashMap;", "", "Lnet/projecttl/inventory/util/LinkedSlot;", "getSlots", "()Lnet/projecttl/inventory/util/ObservableHashMap;", "getTitle", "()Lnet/kyori/adventure/text/Component;", "build", "close", "component1", "component2", "component3", "copy", "destroy", "equals", "", "other", "", "hashCode", "listener", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "listener2", "Lorg/bukkit/event/inventory/InventoryMoveItemEvent;", "listener3", "listener4", "Lorg/bukkit/event/player/PlayerSwapHandItemsEvent;", "onClose", "handler", "slot", "item", "Lorg/bukkit/inventory/ItemStack;", "toString", "", "InventoryGUI-api"})
@SourceDebugExtension(value={"SMAP\nLinkedInventoryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkedInventoryBuilder.kt\nnet/projecttl/inventory/gui/LinkedInventoryBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n1855#3,2:122\n*S KotlinDebug\n*F\n+ 1 LinkedInventoryBuilder.kt\nnet/projecttl/inventory/gui/LinkedInventoryBuilder\n*L\n85#1:122,2\n*E\n"})
public final class LinkedInventoryBuilder
implements Listener,
InventoryBuilder {
    @NotNull
    private final Player player;
    @NotNull
    private final InventoryType slotType;
    @NotNull
    private final Component title;
    @NotNull
    private final ObservableHashMap<Integer, LinkedSlot> slots;
    @NotNull
    private final UUID id;
    private Inventory inventory;
    @NotNull
    private final ArrayList<Function1<InventoryCloseEvent, Unit>> closeHandlers;

    public LinkedInventoryBuilder(@NotNull Player player, @NotNull InventoryType slotType, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)slotType), (String)"slotType");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.player = player;
        this.slotType = slotType;
        this.title = title;
        this.slots = new ObservableHashMap();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.id = uUID;
        this.closeHandlers = new ArrayList();
        ((Map)InventoryGUI.INSTANCE.getInventoryIds()).put(this.getId(), this);
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public InventoryType getSlotType() {
        return this.slotType;
    }

    @Override
    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public ObservableHashMap<Integer, LinkedSlot> getSlots() {
        return this.slots;
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        Inventory inventory = this.inventory;
        if (inventory != null) {
            return inventory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inventory");
        return null;
    }

    @NotNull
    public final ArrayList<Function1<InventoryCloseEvent, Unit>> getCloseHandlers() {
        return this.closeHandlers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void slot(int slot2, @NotNull ItemStack item, @NotNull Function1<? super InventoryClickEvent, Unit> handler) {
        void $this$slot_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Map map = this.getSlots();
        Integer n = slot2;
        Object object = new SlotHandler();
        SlotHandler slotHandler = object;
        ItemStack itemStack = item;
        boolean bl = false;
        $this$slot_u24lambda_u240.onClick(handler);
        SlotHandler slotHandler2 = object;
        ItemStack itemStack2 = itemStack;
        object = new LinkedSlot(itemStack2, slotHandler2);
        map.put(n, object);
    }

    @Override
    public void onClose(@NotNull Function1<? super InventoryCloseEvent, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.closeHandlers.add(handler);
    }

    @Override
    public void slot(int slot2, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.slot(slot2, item, (Function1<? super InventoryClickEvent, Unit>)((Function1)slot.2.INSTANCE));
    }

    @Override
    public void close() {
        if (this.inventory != null) {
            this.getInventory().close();
        }
    }

    @Override
    @NotNull
    public Inventory build() {
        Inventory inventory = Bukkit.createInventory(null, (int)this.getSlotType().getSize(), (Component)this.getTitle());
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"createInventory(...)");
        this.inventory = inventory;
        for (Map.Entry slot2 : ((ObservableHashMap)this.getSlots()).entrySet()) {
            Inventory inventory2 = this.getInventory();
            Object k = slot2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            inventory2.setItem(((Number)k).intValue(), ((LinkedSlot)slot2.getValue()).getStack());
        }
        ((ObservableHashMap)this.getSlots()).addObserver((Function1)new Function1<Pair<? extends Integer, ? extends LinkedSlot>, Unit>(this){
            final /* synthetic */ LinkedInventoryBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pair<Integer, LinkedSlot> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.this$0.getInventory().setItem(((Number)it.getFirst()).intValue(), ((LinkedSlot)it.getSecond()).getStack());
            }
        });
        this.getPlayer().openInventory(this.getInventory());
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, InventoryGUI.INSTANCE.getPlugin());
        return this.getInventory();
    }

    @Override
    public void destroy() {
    }

    @EventHandler
    private final void listener(InventoryClickEvent event) {
        if (Intrinsics.areEqual((Object)event.getView().title(), (Object)this.getTitle()) && ((Map)InventoryGUI.INSTANCE.getInventoryIds()).containsKey(this.getId()) && event.getCurrentItem() != null && Intrinsics.areEqual((Object)event.getView().getPlayer(), (Object)this.getPlayer()) && Intrinsics.areEqual((Object)event.getInventory(), (Object)this.getInventory())) {
            for (Map.Entry slot2 : ((ObservableHashMap)this.getSlots()).entrySet()) {
                Integer n = (Integer)slot2.getKey();
                int n2 = event.getRawSlot();
                if (n == null || n != n2) continue;
                event.setCancelled(true);
                Iterable $this$forEach$iv = ((LinkedSlot)slot2.getValue()).getHandler().getClick();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    it.invoke((Object)event);
                }
            }
        }
    }

    @EventHandler
    private final void listener2(InventoryMoveItemEvent event) {
        if (((Map)InventoryGUI.INSTANCE.getInventoryIds()).containsKey(this.getId())) {
            Object object = event.getSource().getHolder();
            Boolean bl = object != null && (object = object.getInventory()) != null && (object = object.getViewers()) != null ? Boolean.valueOf(object.contains(this.getPlayer())) : null;
            Intrinsics.checkNotNull(bl);
            if (bl.booleanValue() && event.getSource().getHolder() instanceof Container) {
                InventoryHolder inventoryHolder = event.getSource().getHolder();
                Intrinsics.checkNotNull((Object)inventoryHolder, (String)"null cannot be cast to non-null type org.bukkit.block.Container");
                if (Intrinsics.areEqual((Object)((Container)inventoryHolder).customName(), (Object)this.getTitle())) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    private final void listener3(InventoryCloseEvent event) {
        for (Function1<InventoryCloseEvent, Unit> closeHandler : this.closeHandlers) {
            closeHandler.invoke((Object)event);
        }
        if (Intrinsics.areEqual((Object)event.getView().getPlayer(), (Object)this.getPlayer()) && ((Map)InventoryGUI.INSTANCE.getInventoryIds()).containsKey(this.getId())) {
            InventoryGUI.INSTANCE.getInventoryIds().remove(this.getId());
        }
    }

    @EventHandler
    private final void listener4(PlayerSwapHandItemsEvent event) {
        if (Intrinsics.areEqual((Object)event.getPlayer().getInventory(), (Object)this.getInventory())) {
            event.setCancelled(true);
        }
    }

    @NotNull
    public final Player component1() {
        return this.player;
    }

    @NotNull
    public final InventoryType component2() {
        return this.slotType;
    }

    @NotNull
    public final Component component3() {
        return this.title;
    }

    @NotNull
    public final LinkedInventoryBuilder copy(@NotNull Player player, @NotNull InventoryType slotType, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)slotType), (String)"slotType");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return new LinkedInventoryBuilder(player, slotType, title);
    }

    public static /* synthetic */ LinkedInventoryBuilder copy$default(LinkedInventoryBuilder linkedInventoryBuilder, Player player, InventoryType inventoryType, Component component, int n, Object object) {
        if ((n & 1) != 0) {
            player = linkedInventoryBuilder.player;
        }
        if ((n & 2) != 0) {
            inventoryType = linkedInventoryBuilder.slotType;
        }
        if ((n & 4) != 0) {
            component = linkedInventoryBuilder.title;
        }
        return linkedInventoryBuilder.copy(player, inventoryType, component);
    }

    @NotNull
    public String toString() {
        return "LinkedInventoryBuilder(player=" + this.player + ", slotType=" + this.slotType + ", title=" + this.title + ")";
    }

    public int hashCode() {
        int result = this.player.hashCode();
        result = result * 31 + this.slotType.hashCode();
        result = result * 31 + this.title.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinkedInventoryBuilder)) {
            return false;
        }
        LinkedInventoryBuilder linkedInventoryBuilder = (LinkedInventoryBuilder)other;
        if (!Intrinsics.areEqual((Object)this.player, (Object)linkedInventoryBuilder.player)) {
            return false;
        }
        if (this.slotType != linkedInventoryBuilder.slotType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.title, (Object)linkedInventoryBuilder.title);
    }
}

