/*
 * Decompiled with CFR 0.152.
 */
package net.projecttl.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.projecttl.inventory.InventoryGUI;
import net.projecttl.inventory.gui.InventoryBuilder;
import net.projecttl.inventory.gui.SimpleInventoryBuilder;
import net.projecttl.inventory.util.InventoryType;
import net.projecttl.inventory.util.Slot;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\u001f2\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001f0\u001b\u00a2\u0006\u0002\b9J1\u0010:\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u00112\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001f0\u001b\u00a2\u0006\u0002\b9J)\u0010;\u001a\u00020\u001f2!\u0010<\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001f0\u001bJ\u0014\u0010=\u001a\u00020\u001f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0%J\u0010\u0010>\u001a\u00020\u001f2\b\b\u0002\u0010?\u001a\u00020-J\u0010\u0010@\u001a\u00020\u001f2\b\b\u0002\u0010A\u001a\u00020-R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R5\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001f0\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R \u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u0010\u0019R\u001a\u00103\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0017\"\u0004\b5\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006B"}, d2={"Lnet/projecttl/inventory/Animation;", "", "player", "Lorg/bukkit/entity/Player;", "slotType", "Lnet/projecttl/inventory/util/InventoryType;", "title", "Lnet/kyori/adventure/text/Component;", "(Lorg/bukkit/entity/Player;Lnet/projecttl/inventory/util/InventoryType;Lnet/kyori/adventure/text/Component;)V", "base", "Lnet/projecttl/inventory/gui/InventoryBuilder;", "getBase", "()Lnet/projecttl/inventory/gui/InventoryBuilder;", "setBase", "(Lnet/projecttl/inventory/gui/InventoryBuilder;)V", "frames", "Ljava/util/TreeMap;", "", "Lnet/projecttl/inventory/gui/SimpleInventoryBuilder;", "getFrames", "()Ljava/util/TreeMap;", "lastAvailableTicks", "getLastAvailableTicks", "()I", "setLastAvailableTicks", "(I)V", "onPlayAnimation", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "ticks", "", "getOnPlayAnimation", "()Lkotlin/jvm/functions/Function1;", "setOnPlayAnimation", "(Lkotlin/jvm/functions/Function1;)V", "onStopEvent", "Lkotlin/Function0;", "getOnStopEvent", "()Lkotlin/jvm/functions/Function0;", "setOnStopEvent", "(Lkotlin/jvm/functions/Function0;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "running", "", "getSlotType", "()Lnet/projecttl/inventory/util/InventoryType;", "taskId", "getTaskId", "setTaskId", "tick", "getTick", "setTick", "getTitle", "()Lnet/kyori/adventure/text/Component;", "init", "Lkotlin/ExtensionFunctionType;", "frame", "onPlay", "func", "onStop", "start", "resetTicks", "stop", "closeGui", "InventoryGUI-api"})
public final class Animation {
    @NotNull
    private final Player player;
    @NotNull
    private final InventoryType slotType;
    @NotNull
    private final Component title;
    public InventoryBuilder base;
    private boolean running;
    public Function0<Unit> onStopEvent;
    public Function1<? super Integer, Unit> onPlayAnimation;
    private int tick;
    private int lastAvailableTicks;
    @NotNull
    private final TreeMap<Integer, SimpleInventoryBuilder> frames;
    private int taskId;

    public Animation(@NotNull Player player, @NotNull InventoryType slotType, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)slotType), (String)"slotType");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.player = player;
        this.slotType = slotType;
        this.title = title;
        this.lastAvailableTicks = -1;
        this.frames = new TreeMap();
        this.taskId = -1;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final InventoryType getSlotType() {
        return this.slotType;
    }

    @NotNull
    public final Component getTitle() {
        return this.title;
    }

    @NotNull
    public final InventoryBuilder getBase() {
        InventoryBuilder inventoryBuilder = this.base;
        if (inventoryBuilder != null) {
            return inventoryBuilder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"base");
        return null;
    }

    public final void setBase(@NotNull InventoryBuilder inventoryBuilder) {
        Intrinsics.checkNotNullParameter((Object)inventoryBuilder, (String)"<set-?>");
        this.base = inventoryBuilder;
    }

    @NotNull
    public final Function0<Unit> getOnStopEvent() {
        Function0<Unit> function0 = this.onStopEvent;
        if (function0 != null) {
            return function0;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onStopEvent");
        return null;
    }

    public final void setOnStopEvent(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.onStopEvent = function0;
    }

    @NotNull
    public final Function1<Integer, Unit> getOnPlayAnimation() {
        Function1<? super Integer, Unit> function1 = this.onPlayAnimation;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onPlayAnimation");
        return null;
    }

    public final void setOnPlayAnimation(@NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onPlayAnimation = function1;
    }

    public final int getTick() {
        return this.tick;
    }

    public final void setTick(int n) {
        this.tick = n;
    }

    public final int getLastAvailableTicks() {
        return this.lastAvailableTicks;
    }

    public final void setLastAvailableTicks(int n) {
        this.lastAvailableTicks = n;
    }

    @NotNull
    public final TreeMap<Integer, SimpleInventoryBuilder> getFrames() {
        return this.frames;
    }

    public final int getTaskId() {
        return this.taskId;
    }

    public final void setTaskId(int n) {
        this.taskId = n;
    }

    public final void base(@NotNull Function1<? super SimpleInventoryBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        SimpleInventoryBuilder simpleInventoryBuilder = new SimpleInventoryBuilder(this.player, this.slotType, this.title);
        init.invoke((Object)simpleInventoryBuilder);
        this.setBase(simpleInventoryBuilder);
    }

    public final void frame(int tick, @NotNull Component title, @NotNull Function1<? super SimpleInventoryBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        Map map = this.frames;
        Integer n = tick;
        SimpleInventoryBuilder simpleInventoryBuilder = new SimpleInventoryBuilder(this.player, this.slotType, title);
        init.invoke((Object)simpleInventoryBuilder);
        map.put(n, simpleInventoryBuilder);
    }

    public static /* synthetic */ void frame$default(Animation animation, int n, Component component, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            component = animation.title;
        }
        animation.frame(n, component, (Function1<? super SimpleInventoryBuilder, Unit>)function1);
    }

    public final void onStop(@NotNull Function0<Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.setOnStopEvent(func);
    }

    public final void onPlay(@NotNull Function1<? super Integer, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.setOnPlayAnimation(func);
    }

    public final void start(boolean resetTicks) {
        if (resetTicks) {
            this.tick = 0;
        }
        this.running = true;
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(InventoryGUI.INSTANCE.getPlugin(), () -> Animation.start$lambda$1(this), 0L, 1L);
    }

    public static /* synthetic */ void start$default(Animation animation, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        animation.start(bl);
    }

    public final void stop(boolean closeGui) {
        if (closeGui && this.lastAvailableTicks != -1) {
            SimpleInventoryBuilder simpleInventoryBuilder = this.frames.get(this.lastAvailableTicks);
            if (simpleInventoryBuilder != null) {
                simpleInventoryBuilder.close();
            }
        }
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
    }

    public static /* synthetic */ void stop$default(Animation animation, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        animation.stop(bl);
    }

    private static final void start$lambda$1(Animation this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.running) {
            if (((Map)this$0.frames).containsKey(this$0.tick)) {
                Inventory inventory;
                this$0.lastAvailableTicks = this$0.tick;
                Inventory inv = this$0.getBase().build();
                SimpleInventoryBuilder simpleInventoryBuilder = this$0.frames.get(this$0.tick);
                HashMap<Integer, Slot> hashMap = simpleInventoryBuilder != null ? simpleInventoryBuilder.getSlots() : null;
                Intrinsics.checkNotNull(hashMap);
                HashMap<Integer, Slot> slots = hashMap;
                Inventory $this$start_u24lambda_u241_u24lambda_u240 = inventory = inv;
                boolean bl = false;
                for (Map.Entry<Integer, Slot> slot2 : slots.entrySet()) {
                    Integer n = slot2.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"<get-key>(...)");
                    $this$start_u24lambda_u241_u24lambda_u240.setItem(((Number)n).intValue(), slot2.getValue().getStack());
                }
                this$0.player.openInventory(inv);
                if (this$0.onPlayAnimation != null) {
                    this$0.getOnPlayAnimation().invoke((Object)this$0.tick);
                }
                Integer n = this$0.frames.lastKey();
                if (n != null && this$0.tick == n) {
                    this$0.running = false;
                }
            }
            int n = this$0.tick;
            this$0.tick = n + 1;
        } else if (this$0.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this$0.taskId);
            if (this$0.onStopEvent != null) {
                this$0.getOnStopEvent().invoke();
            }
        }
    }
}

