/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.chunk;

import java.util.Arrays;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.instance.Chunk;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ChunkUpdateLimitChecker {
    private final int historySize;
    private final long[] chunkHistory;

    public ChunkUpdateLimitChecker(int historySize) {
        this.historySize = Math.max(0, historySize);
        this.chunkHistory = new long[this.historySize];
        this.clearHistory();
    }

    public boolean isEnabled() {
        return this.historySize > 0;
    }

    public boolean addToHistory(Chunk chunk) {
        if (!this.isEnabled()) {
            return true;
        }
        long index = CoordConversion.chunkIndex(chunk.getChunkX(), chunk.getChunkZ());
        boolean result = true;
        int lastIndex = this.historySize - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            if (this.chunkHistory[i] == index) {
                result = false;
            }
            if (i == lastIndex) continue;
            this.chunkHistory[i] = this.chunkHistory[i + 1];
        }
        this.chunkHistory[lastIndex] = index;
        return result;
    }

    public void clearHistory() {
        Arrays.fill(this.chunkHistory, Long.MAX_VALUE);
    }
}

