/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public final class PacketSendingUtils {
    public static void sendPacket(@NotNull Audience audience, @NotNull ServerPacket packet) {
        Audience audience2 = audience;
        Objects.requireNonNull(audience2);
        Audience audience3 = audience2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, PacketGroupingAudience.class, ForwardingAudience.Single.class, ForwardingAudience.class}, (Object)audience3, n)) {
            case 0: {
                Player player = (Player)audience3;
                player.sendPacket(packet);
                break;
            }
            case 1: {
                PacketGroupingAudience groupingAudience = (PacketGroupingAudience)audience3;
                PacketSendingUtils.sendGroupedPacket(groupingAudience.getPlayers(), packet);
                break;
            }
            case 2: {
                ForwardingAudience.Single singleAudience = (ForwardingAudience.Single)audience3;
                PacketSendingUtils.sendPacket(singleAudience.audience(), packet);
                break;
            }
            case 3: {
                ForwardingAudience forwardingAudience = (ForwardingAudience)audience3;
                for (Audience member : forwardingAudience.audiences()) {
                    PacketSendingUtils.sendPacket(member, packet);
                }
                break;
            }
        }
    }

    public static void sendGroupedPacket(@NotNull Collection<Player> players, @NotNull ServerPacket packet, @NotNull Predicate<Player> predicate) {
        SendablePacket sendablePacket = PacketSendingUtils.groupedPacket(packet);
        players.forEach(player -> {
            if (predicate.test((Player)player)) {
                player.sendPacket(sendablePacket);
            }
        });
    }

    public static void sendGroupedPacket(@NotNull Collection<Player> players, @NotNull ServerPacket packet) {
        SendablePacket sendablePacket = PacketSendingUtils.groupedPacket(packet);
        players.forEach(player -> player.sendPacket(sendablePacket));
    }

    public static void broadcastPlayPacket(@NotNull ServerPacket packet) {
        PacketSendingUtils.sendGroupedPacket(MinecraftServer.getConnectionManager().getOnlinePlayers(), packet);
    }

    static SendablePacket groupedPacket(ServerPacket packet) {
        return PacketSendingUtils.shouldUseCachePacket(packet) ? new CachedPacket(packet) : packet;
    }

    static boolean shouldUseCachePacket(@NotNull ServerPacket packet) {
        if (!MinestomAdventure.AUTOMATIC_COMPONENT_TRANSLATION) {
            return ServerFlag.GROUPED_PACKET;
        }
        if (!(packet instanceof ServerPacket.ComponentHolding)) {
            return ServerFlag.GROUPED_PACKET;
        }
        ServerPacket.ComponentHolding holder = (ServerPacket.ComponentHolding)((Object)packet);
        return !PacketSendingUtils.containsTranslatableComponents(holder);
    }

    private static boolean containsTranslatableComponents(@NotNull ComponentHolder<?> holder) {
        for (Component component : holder.components()) {
            if (!PacketSendingUtils.isTranslatable(component)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTranslatable(@NotNull Component component) {
        if (component instanceof TranslatableComponent) {
            return true;
        }
        List children = component.children();
        if (children.isEmpty()) {
            return false;
        }
        for (Component child : children) {
            if (!PacketSendingUtils.isTranslatable(child)) continue;
            return true;
        }
        return false;
    }
}

