/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.TickThread;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class AcquirableCollection<E>
implements Collection<Acquirable<E>> {
    private final Collection<Acquirable<E>> acquirableCollection;

    public AcquirableCollection(Collection<Acquirable<E>> acquirableCollection) {
        this.acquirableCollection = acquirableCollection;
    }

    public void acquireSync(@NotNull Consumer<E> consumer) {
        Thread currentThread = Thread.currentThread();
        Map threadEntitiesMap = AcquirableCollection.retrieveOptionalThreadMap(this.acquirableCollection, currentThread, consumer);
        for (Map.Entry entry : threadEntitiesMap.entrySet()) {
            TickThread tickThread = entry.getKey();
            List values = entry.getValue();
            ReentrantLock lock = AcquirableImpl.enter(currentThread, tickThread);
            for (Object value : values) {
                consumer.accept(value);
            }
            AcquirableImpl.leave(lock);
        }
    }

    @NotNull
    public Stream<E> unwrap() {
        return this.acquirableCollection.stream().map(Acquirable::unwrap);
    }

    @Override
    public int size() {
        return this.acquirableCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.acquirableCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.acquirableCollection.contains(o);
    }

    @Override
    @NotNull
    public Iterator<Acquirable<E>> iterator() {
        return this.acquirableCollection.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.acquirableCollection.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.acquirableCollection.toArray(a);
    }

    @Override
    public boolean add(Acquirable<E> eAcquirable) {
        return this.acquirableCollection.add(eAcquirable);
    }

    @Override
    public boolean remove(Object o) {
        return this.acquirableCollection.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.acquirableCollection.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Acquirable<E>> c) {
        return this.acquirableCollection.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.acquirableCollection.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.acquirableCollection.retainAll(c);
    }

    @Override
    public void clear() {
        this.acquirableCollection.clear();
    }

    protected static <T> Map<TickThread, List<T>> retrieveOptionalThreadMap(@NotNull Collection<Acquirable<T>> collection, @NotNull Thread currentThread, @NotNull Consumer<T> consumer) {
        HashMap<TickThread, List<T>> threadCacheMap = new HashMap<TickThread, List<T>>();
        for (Acquirable<T> element : collection) {
            T value = element.unwrap();
            TickThread elementThread = element.assignedThread();
            if (currentThread == elementThread) {
                consumer.accept(value);
                continue;
            }
            List threadCacheList = threadCacheMap.computeIfAbsent(elementThread, tickThread -> new ArrayList());
            threadCacheList.add(value);
        }
        return threadCacheMap;
    }
}

