/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.minestom.server.ServerFlag;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.configuration.RegistryDataPacket;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
final class DynamicRegistryImpl<T>
implements DynamicRegistry<T> {
    private static final UnsupportedOperationException UNSAFE_REMOVE_EXCEPTION = new UnsupportedOperationException("Unsafe remove is disabled. Enable by setting the system property 'minestom.registry.unsafe-ops' to 'true'");
    private Registries registries = null;
    private CachedPacket vanillaRegistryDataPacket = new CachedPacket(() -> this.createRegistryDataPacket(this.registries, true));
    private final ReentrantLock lock = new ReentrantLock();
    private final List<T> entryById = new CopyOnWriteArrayList<T>();
    private final Map<NamespaceID, T> entryByName = new ConcurrentHashMap<NamespaceID, T>();
    private final List<NamespaceID> idByName = new CopyOnWriteArrayList<NamespaceID>();
    private final List<DataPack> packById = new CopyOnWriteArrayList<DataPack>();
    private final String id;
    private final BinaryTagSerializer<T> nbtType;

    DynamicRegistryImpl(@NotNull String id, @Nullable BinaryTagSerializer<T> nbtType) {
        this.id = id;
        this.nbtType = nbtType;
    }

    @Override
    @NotNull
    public String id() {
        return this.id;
    }

    public @UnknownNullability BinaryTagSerializer<T> nbtType() {
        return this.nbtType;
    }

    @Override
    @Nullable
    public T get(int id) {
        if (id < 0 || id >= this.entryById.size()) {
            return null;
        }
        return this.entryById.get(id);
    }

    @Override
    @Nullable
    public T get(@NotNull NamespaceID namespace) {
        return this.entryByName.get(namespace);
    }

    @Override
    @Nullable
    public DynamicRegistry.Key<T> getKey(@NotNull T value) {
        int index = this.entryById.indexOf(value);
        return index == -1 ? null : this.getKey(index);
    }

    @Override
    @Nullable
    public DynamicRegistry.Key<T> getKey(int id) {
        if (id < 0 || id >= this.entryById.size()) {
            return null;
        }
        return DynamicRegistry.Key.of(this.idByName.get(id));
    }

    @Override
    @Nullable
    public NamespaceID getName(int id) {
        if (id < 0 || id >= this.entryById.size()) {
            return null;
        }
        return this.idByName.get(id);
    }

    @Override
    @Nullable
    public DataPack getPack(int id) {
        if (id < 0 || id >= this.packById.size()) {
            return null;
        }
        return this.packById.get(id);
    }

    @Override
    public int getId(@NotNull NamespaceID id) {
        return this.idByName.indexOf(id);
    }

    @Override
    @NotNull
    public List<T> values() {
        return Collections.unmodifiableList(this.entryById);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DynamicRegistry.Key<T> register(@NotNull NamespaceID namespaceId, @NotNull T object, @Nullable DataPack pack) {
        this.lock.lock();
        try {
            int id = this.idByName.indexOf(namespaceId);
            this.entryByName.put(namespaceId, object);
            if (id == -1) {
                this.idByName.add(namespaceId);
                this.entryById.add(object);
                this.packById.add(pack);
            } else {
                this.idByName.set(id, namespaceId);
                this.entryById.set(id, object);
                this.packById.set(id, pack);
            }
            if (this.vanillaRegistryDataPacket != null) {
                this.vanillaRegistryDataPacket.invalidate();
            }
            DynamicRegistry.Key key = DynamicRegistry.Key.of(namespaceId);
            return key;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull NamespaceID namespaceId) throws UnsupportedOperationException {
        if (!ServerFlag.REGISTRY_UNSAFE_OPS) {
            throw UNSAFE_REMOVE_EXCEPTION;
        }
        this.lock.lock();
        try {
            int id = this.idByName.indexOf(namespaceId);
            if (id == -1) {
                boolean bl = false;
                return bl;
            }
            this.entryById.remove(id);
            this.entryByName.remove(namespaceId);
            this.idByName.remove(id);
            this.packById.remove(id);
            if (this.vanillaRegistryDataPacket != null) {
                this.vanillaRegistryDataPacket.invalidate();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NotNull
    public SendablePacket registryDataPacket(@NotNull Registries registries, boolean excludeVanilla) {
        if (excludeVanilla) {
            if (this.registries != registries) {
                this.vanillaRegistryDataPacket.invalidate();
                this.registries = registries;
            }
            return this.vanillaRegistryDataPacket;
        }
        return this.createRegistryDataPacket(registries, false);
    }

    @NotNull
    private RegistryDataPacket createRegistryDataPacket(@NotNull Registries registries, boolean excludeVanilla) {
        Check.notNull(this.nbtType, "Cannot create registry data packet for server-only registry");
        BinaryTagSerializer.ContextWithRegistries context = new BinaryTagSerializer.ContextWithRegistries(registries, true);
        ArrayList<RegistryDataPacket.Entry> entries = new ArrayList<RegistryDataPacket.Entry>(this.entryById.size());
        for (int i = 0; i < this.entryById.size(); ++i) {
            CompoundBinaryTag data = null;
            T entry = this.entryById.get(i);
            DataPack pack = this.packById.get(i);
            if (!excludeVanilla || pack != DataPack.MINECRAFT_CORE) {
                data = (CompoundBinaryTag)this.nbtType.write(context, entry);
            }
            entries.add(new RegistryDataPacket.Entry(this.getKey(i).name(), (BinaryTag)data));
        }
        return new RegistryDataPacket(this.id, entries);
    }

    static <T extends ProtocolObject> void loadStaticRegistry(@NotNull DynamicRegistry<T> registry, @NotNull Registry.Resource resource, @NotNull Registry.Container.Loader<T> loader, @Nullable Comparator<String> idComparator) {
        ArrayList<Map.Entry<String, Map<String, Object>>> entries = new ArrayList<Map.Entry<String, Map<String, Object>>>(Registry.load(resource).entrySet());
        if (idComparator != null) {
            entries.sort(Map.Entry.comparingByKey(idComparator));
        }
        for (Map.Entry entry : entries) {
            String namespace = (String)entry.getKey();
            Registry.Properties properties = Registry.Properties.fromMap((Map)entry.getValue());
            registry.register(namespace, loader.get(namespace, properties), DataPack.MINECRAFT_CORE);
        }
    }

    static <T extends ProtocolObject> void loadStaticSnbtRegistry(@NotNull Registries registries, @NotNull DynamicRegistryImpl<T> registry, @NotNull Registry.Resource resource) {
        Check.argCondition(!resource.fileName().endsWith(".snbt"), "Resource must be an SNBT file: {0}", resource.fileName());
        try (InputStream resourceStream = Registry.loadRegistryFile(resource);){
            Check.notNull(resourceStream, "Resource {0} does not exist!", new Object[]{resource});
            BinaryTag tag = TagStringIOExt.readTag(new String(resourceStream.readAllBytes(), StandardCharsets.UTF_8));
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new IllegalStateException("Root tag must be a compound tag");
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)tag;
            BinaryTagSerializer.ContextWithRegistries context = new BinaryTagSerializer.ContextWithRegistries(registries, false);
            for (Map.Entry entry : compound) {
                String namespace = (String)entry.getKey();
                ProtocolObject value = (ProtocolObject)registry.nbtType.read(context, (BinaryTag)entry.getValue());
                Check.notNull(value, "Failed to read value for namespace {0}", namespace);
                registry.register(namespace, value, DataPack.MINECRAFT_CORE);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    record KeyImpl<T>(@NotNull NamespaceID namespace) implements DynamicRegistry.Key<T>
    {
        @Override
        public String toString() {
            return this.namespace.asString();
        }

        @Override
        public int hashCode() {
            return this.namespace.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            KeyImpl key = (KeyImpl)obj;
            return this.namespace.equals(key.namespace);
        }
    }
}

