/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TabCompletePacket(int transactionId, int start, int length, @NotNull List<Match> matches) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final int MAX_ENTRIES = Short.MAX_VALUE;
    public static final NetworkBuffer.Type<TabCompletePacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, TabCompletePacket::transactionId, NetworkBuffer.VAR_INT, TabCompletePacket::start, NetworkBuffer.VAR_INT, TabCompletePacket::length, Match.SERIALIZER.list(Short.MAX_VALUE), TabCompletePacket::matches, TabCompletePacket::new);

    public TabCompletePacket(int transactionId, int start, int length, @NotNull List<Match> matches) {
        matches = List.copyOf(matches);
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        if (this.matches.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> components = new ArrayList<Component>(this.matches.size());
        for (Match match : this.matches) {
            if (match.tooltip == null) continue;
            components.add(match.tooltip);
        }
        return components;
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        if (this.matches.isEmpty()) {
            return this;
        }
        List<Match> updatedMatches = this.matches.stream().map(match -> match.copyWithOperator((UnaryOperator)operator)).toList();
        return new TabCompletePacket(this.transactionId, this.start, this.length, updatedMatches);
    }

    public record Match(@NotNull String match, @Nullable Component tooltip) implements ComponentHolder<Match>
    {
        public static final NetworkBuffer.Type<Match> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, Match::match, NetworkBuffer.COMPONENT.optional(), Match::tooltip, Match::new);

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.tooltip != null ? List.of(this.tooltip) : List.of();
        }

        @Override
        @NotNull
        public Match copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.tooltip != null ? new Match(this.match, (Component)operator.apply(this.tooltip)) : this;
        }
    }
}

