/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import java.util.function.Function;
import net.minestom.server.command.ArgumentParserType;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record DeclareCommandsPacket(@NotNull List<Node> nodes, int rootIndex) implements ServerPacket.Play
{
    public static final int MAX_NODES = Short.MAX_VALUE;
    public static final NetworkBuffer.Type<DeclareCommandsPacket> SERIALIZER = NetworkBufferTemplate.template(Node.SERIALIZER.list(Short.MAX_VALUE), DeclareCommandsPacket::nodes, NetworkBuffer.VAR_INT, DeclareCommandsPacket::rootIndex, DeclareCommandsPacket::new);
    public static final int NODE_TYPE = 3;
    public static final int IS_EXECUTABLE = 4;
    public static final int HAS_REDIRECT = 8;
    public static final int HAS_SUGGESTION_TYPE = 16;

    public DeclareCommandsPacket(@NotNull List<Node> nodes, int rootIndex) {
        nodes = List.copyOf(nodes);
    }

    public static byte getFlag(@NotNull NodeType type, boolean executable, boolean redirect, boolean suggestionType) {
        byte result = (byte)type.ordinal();
        if (executable) {
            result = (byte)(result | 4);
        }
        if (redirect) {
            result = (byte)(result | 8);
        }
        if (suggestionType) {
            result = (byte)(result | 0x10);
        }
        return result;
    }

    public static enum NodeType {
        ROOT,
        LITERAL,
        ARGUMENT,
        NONE;

    }

    public static final class Node {
        public byte flags;
        public int[] children = new int[0];
        public int redirectedNode;
        public String name = "";
        public ArgumentParserType parser;
        public byte[] properties;
        public String suggestionsType = "";
        public static final NetworkBuffer.Type<Node> SERIALIZER = new NetworkBuffer.Type<Node>(){

            @Override
            public void write(@NotNull NetworkBuffer writer, Node value) {
                writer.write(NetworkBuffer.BYTE, value.flags);
                if (value.children != null && value.children.length > 262114) {
                    throw new RuntimeException("Children length " + value.children.length + " is bigger than the maximum allowed 262114");
                }
                writer.write(NetworkBuffer.VAR_INT_ARRAY, value.children);
                if ((value.flags & 8) != 0) {
                    writer.write(NetworkBuffer.VAR_INT, value.redirectedNode);
                }
                if (value.isLiteral() || value.isArgument()) {
                    writer.write(NetworkBuffer.STRING, value.name);
                }
                if (value.isArgument()) {
                    writer.write(ArgumentParserType.NETWORK_TYPE, value.parser);
                    if (value.properties != null) {
                        writer.write(NetworkBuffer.RAW_BYTES, value.properties);
                    }
                }
                if ((value.flags & 0x10) != 0) {
                    writer.write(NetworkBuffer.STRING, value.suggestionsType);
                }
            }

            @Override
            public Node read(@NotNull NetworkBuffer reader) {
                Node node = new Node();
                node.flags = reader.read(NetworkBuffer.BYTE);
                node.children = reader.read(NetworkBuffer.VAR_INT_ARRAY);
                if ((node.flags & 8) != 0) {
                    node.redirectedNode = reader.read(NetworkBuffer.VAR_INT);
                }
                if (node.isLiteral() || node.isArgument()) {
                    node.name = reader.read(NetworkBuffer.STRING);
                }
                if (node.isArgument()) {
                    node.parser = reader.read(ArgumentParserType.NETWORK_TYPE);
                    node.properties = node.getProperties(reader, node.parser);
                }
                if ((node.flags & 0x10) != 0) {
                    node.suggestionsType = reader.read(NetworkBuffer.STRING);
                }
                return node;
            }
        };

        private byte[] getProperties(@NotNull NetworkBuffer reader, @NotNull ArgumentParserType parser) {
            Function<Function, byte[]> minMaxExtractor = via -> reader.extractBytes(extractor -> {
                byte flags = extractor.read(NetworkBuffer.BYTE);
                if ((flags & 1) == 1) {
                    via.apply(extractor);
                }
                if ((flags & 2) == 2) {
                    via.apply(extractor);
                }
            });
            return switch (parser) {
                case ArgumentParserType.DOUBLE -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.DOUBLE));
                case ArgumentParserType.INTEGER -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.INT));
                case ArgumentParserType.FLOAT -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.FLOAT));
                case ArgumentParserType.LONG -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.LONG));
                case ArgumentParserType.STRING -> reader.extractBytes(b -> b.read(NetworkBuffer.VAR_INT));
                case ArgumentParserType.ENTITY, ArgumentParserType.SCORE_HOLDER -> reader.extractBytes(b -> b.read(NetworkBuffer.BYTE));
                case ArgumentParserType.TIME -> reader.extractBytes(b -> b.read(NetworkBuffer.INT));
                case ArgumentParserType.RESOURCE_OR_TAG, ArgumentParserType.RESOURCE_OR_TAG_KEY, ArgumentParserType.RESOURCE, ArgumentParserType.RESOURCE_KEY -> reader.extractBytes(b -> b.read(NetworkBuffer.STRING));
                default -> new byte[]{};
            };
        }

        private boolean isLiteral() {
            return (this.flags & 1) != 0;
        }

        private boolean isArgument() {
            return (this.flags & 2) != 0;
        }
    }
}

