/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.advancements.FrameType;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AdvancementsPacket(boolean reset, @NotNull List<AdvancementMapping> advancementMappings, @NotNull List<String> identifiersToRemove, @NotNull List<ProgressMapping> progressMappings) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final int MAX_ADVANCEMENTS = Short.MAX_VALUE;
    public static final NetworkBuffer.Type<AdvancementsPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.BOOLEAN, AdvancementsPacket::reset, AdvancementMapping.SERIALIZER.list(Short.MAX_VALUE), AdvancementsPacket::advancementMappings, NetworkBuffer.STRING.list(Short.MAX_VALUE), AdvancementsPacket::identifiersToRemove, ProgressMapping.SERIALIZER.list(Short.MAX_VALUE), AdvancementsPacket::progressMappings, AdvancementsPacket::new);

    public AdvancementsPacket(boolean reset, @NotNull List<AdvancementMapping> advancementMappings, @NotNull List<String> identifiersToRemove, @NotNull List<ProgressMapping> progressMappings) {
        advancementMappings = List.copyOf(advancementMappings);
        identifiersToRemove = List.copyOf(identifiersToRemove);
        progressMappings = List.copyOf(progressMappings);
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        List<DisplayData> displayData = this.advancementMappings.stream().map(AdvancementMapping::value).map(Advancement::displayData).filter(Objects::nonNull).toList();
        List<Component> titles = displayData.stream().map(DisplayData::title).toList();
        List<Component> descriptions = displayData.stream().map(DisplayData::description).toList();
        ArrayList<Component> list = new ArrayList<Component>();
        list.addAll(titles);
        list.addAll(descriptions);
        return List.copyOf(list);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new AdvancementsPacket(this.reset, this.advancementMappings.stream().map(mapping -> mapping.copyWithOperator((UnaryOperator)operator)).toList(), this.identifiersToRemove, this.progressMappings);
    }

    public record AdvancementMapping(@NotNull String key, @NotNull Advancement value) implements ComponentHolder<AdvancementMapping>
    {
        public static final NetworkBuffer.Type<AdvancementMapping> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, AdvancementMapping::key, Advancement.SERIALIZER, AdvancementMapping::value, AdvancementMapping::new);

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.value.components();
        }

        @Override
        @NotNull
        public AdvancementMapping copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.value.displayData == null ? this : new AdvancementMapping(this.key, (Advancement)this.value.copyWithOperator((UnaryOperator)operator));
        }
    }

    public record ProgressMapping(@NotNull String key, @NotNull AdvancementProgress progress) {
        public static final NetworkBuffer.Type<ProgressMapping> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, ProgressMapping::key, AdvancementProgress.SERIALIZER, ProgressMapping::progress, ProgressMapping::new);
    }

    public record CriterionProgress(@Nullable Long dateOfAchieving) {
        public static final NetworkBuffer.Type<CriterionProgress> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.LONG.optional(), CriterionProgress::dateOfAchieving, CriterionProgress::new);
    }

    public record Criteria(@NotNull String criterionIdentifier, @NotNull CriterionProgress criterionProgress) {
        public static final NetworkBuffer.Type<Criteria> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, Criteria::criterionIdentifier, CriterionProgress.SERIALIZER, Criteria::criterionProgress, Criteria::new);
    }

    public record AdvancementProgress(@NotNull @NotNull List<@NotNull Criteria> criteria) {
        public static final NetworkBuffer.Type<AdvancementProgress> SERIALIZER = NetworkBufferTemplate.template(Criteria.SERIALIZER.list(Short.MAX_VALUE), AdvancementProgress::criteria, AdvancementProgress::new);

        public AdvancementProgress(@NotNull List<Criteria> criteria) {
            criteria = List.copyOf(criteria);
        }
    }

    public record DisplayData(@NotNull Component title, @NotNull Component description, @NotNull ItemStack icon, @NotNull FrameType frameType, int flags, @Nullable String backgroundTexture, float x, float y) implements ComponentHolder<DisplayData>
    {
        public static final NetworkBuffer.Type<DisplayData> SERIALIZER = new NetworkBuffer.Type<DisplayData>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, DisplayData value) {
                buffer.write(NetworkBuffer.COMPONENT, value.title);
                buffer.write(NetworkBuffer.COMPONENT, value.description);
                buffer.write(ItemStack.NETWORK_TYPE, value.icon);
                buffer.write(NetworkBuffer.Enum(FrameType.class), value.frameType);
                buffer.write(NetworkBuffer.INT, value.flags);
                if ((value.flags & 1) != 0) {
                    assert (value.backgroundTexture != null);
                    buffer.write(NetworkBuffer.STRING, value.backgroundTexture);
                }
                buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.x));
                buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.y));
            }

            @Override
            public DisplayData read(@NotNull NetworkBuffer buffer) {
                Component title = buffer.read(NetworkBuffer.COMPONENT);
                Component description = buffer.read(NetworkBuffer.COMPONENT);
                ItemStack icon = buffer.read(ItemStack.NETWORK_TYPE);
                FrameType frameType = FrameType.values()[buffer.read(NetworkBuffer.VAR_INT)];
                Integer flags = buffer.read(NetworkBuffer.INT);
                String backgroundTexture = (flags & 1) != 0 ? buffer.read(NetworkBuffer.STRING) : null;
                Float x = buffer.read(NetworkBuffer.FLOAT);
                Float y = buffer.read(NetworkBuffer.FLOAT);
                return new DisplayData(title, description, icon, frameType, flags, backgroundTexture, x.floatValue(), y.floatValue());
            }
        };

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.title, this.description);
        }

        @Override
        @NotNull
        public DisplayData copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new DisplayData((Component)operator.apply(this.title), (Component)operator.apply(this.description), this.icon, this.frameType, this.flags, this.backgroundTexture, this.x, this.y);
        }
    }

    public record Requirement(@NotNull List<String> requirements) {
        public static final NetworkBuffer.Type<Requirement> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING.list(Short.MAX_VALUE), Requirement::requirements, Requirement::new);

        public Requirement(@NotNull List<String> requirements) {
            requirements = List.copyOf(requirements);
        }
    }

    public record Advancement(@Nullable String parentIdentifier, @Nullable DisplayData displayData, @NotNull List<Requirement> requirements, boolean sendTelemetryData) implements ComponentHolder<Advancement>
    {
        public static final NetworkBuffer.Type<Advancement> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING.optional(), Advancement::parentIdentifier, DisplayData.SERIALIZER.optional(), Advancement::displayData, Requirement.SERIALIZER.list(Short.MAX_VALUE), Advancement::requirements, NetworkBuffer.BOOLEAN, Advancement::sendTelemetryData, Advancement::new);

        public Advancement(@Nullable String parentIdentifier, @Nullable DisplayData displayData, @NotNull List<Requirement> requirements, boolean sendTelemetryData) {
            requirements = List.copyOf(requirements);
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.displayData != null ? this.displayData.components() : List.of();
        }

        @Override
        @NotNull
        public Advancement copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.displayData == null ? this : new Advancement(this.parentIdentifier, (DisplayData)this.displayData.copyWithOperator((UnaryOperator)operator), this.requirements, this.sendTelemetryData);
        }
    }
}

