/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferUnsafe;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.ObjectPool;
import net.minestom.server.utils.nbt.BinaryTagReader;
import net.minestom.server.utils.nbt.BinaryTagWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class NetworkBufferImpl
implements NetworkBuffer {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final long DUMMY_ADDRESS = -1L;
    private final BufferCleaner state;
    private long address;
    private long capacity;
    private long readIndex;
    private long writeIndex;
    boolean readOnly;
    BinaryTagWriter nbtWriter;
    BinaryTagReader nbtReader;
    @Nullable
    final NetworkBuffer.AutoResize autoResize;
    @Nullable
    final Registries registries;
    ByteBuffer nioBuffer = null;
    private static final ObjectPool<Deflater> DEFLATER_POOL = ObjectPool.pool(Deflater::new);
    private static final ObjectPool<Inflater> INFLATER_POOL = ObjectPool.pool(Inflater::new);
    private static final boolean ENDIAN_CONVERSION = ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN;

    NetworkBufferImpl(long address, long capacity, long readIndex, long writeIndex, @Nullable NetworkBuffer.AutoResize autoResize, @Nullable Registries registries) {
        this.address = address;
        this.capacity = capacity;
        this.readIndex = readIndex;
        this.writeIndex = writeIndex;
        this.autoResize = autoResize;
        this.registries = registries;
        this.state = new BufferCleaner(new AtomicLong(address));
        if (address != -1L) {
            CLEANER.register(this, this.state);
        }
    }

    @Override
    public <T> void write(@NotNull NetworkBuffer.Type<T> type, @UnknownNullability T value) {
        this.assertReadOnly();
        type.write(this, value);
    }

    @Override
    public <T> @UnknownNullability T read(@NotNull NetworkBuffer.Type<T> type) {
        this.assertDummy();
        return type.read(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void writeAt(long index, @NotNull NetworkBuffer.Type<T> type, @UnknownNullability T value) {
        this.assertReadOnly();
        long oldWriteIndex = this.writeIndex;
        this.writeIndex = index;
        try {
            this.write(type, value);
        }
        finally {
            this.writeIndex = oldWriteIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> @UnknownNullability T readAt(long index, @NotNull NetworkBuffer.Type<T> type) {
        this.assertDummy();
        long oldReadIndex = this.readIndex;
        this.readIndex = index;
        try {
            T t = this.read(type);
            return t;
        }
        finally {
            this.readIndex = oldReadIndex;
        }
    }

    @Override
    public void copyTo(long srcOffset, byte @NotNull [] dest, long destOffset, long length) {
        this.assertDummy();
        NetworkBufferImpl.assertOverflow(srcOffset + length);
        NetworkBufferImpl.assertOverflow(destOffset + length);
        if (length == 0L) {
            return;
        }
        if ((long)dest.length < destOffset + length) {
            throw new IndexOutOfBoundsException("Destination array is too small: " + dest.length + " < " + (destOffset + length));
        }
        NetworkBufferUnsafe.UNSAFE.copyMemory(null, this.address + srcOffset, dest, NetworkBufferUnsafe.BYTE_ARRAY_OFFSET + destOffset, length);
    }

    @Override
    public byte @NotNull [] extractBytes(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> extractor) {
        this.assertDummy();
        long startingPosition = this.readIndex();
        extractor.accept(this);
        long endingPosition = this.readIndex();
        long length = endingPosition - startingPosition;
        NetworkBufferImpl.assertOverflow(length);
        byte[] output = new byte[(int)length];
        this.copyTo(startingPosition, output, 0L, output.length);
        return output;
    }

    @Override
    @NotNull
    public NetworkBuffer clear() {
        return this.index(0L, 0L);
    }

    @Override
    public long writeIndex() {
        return this.writeIndex;
    }

    @Override
    public long readIndex() {
        return this.readIndex;
    }

    @Override
    @NotNull
    public NetworkBuffer writeIndex(long writeIndex) {
        this.writeIndex = writeIndex;
        return this;
    }

    @Override
    @NotNull
    public NetworkBuffer readIndex(long readIndex) {
        this.readIndex = readIndex;
        return this;
    }

    @Override
    @NotNull
    public NetworkBuffer index(long readIndex, long writeIndex) {
        this.readIndex = readIndex;
        this.writeIndex = writeIndex;
        return this;
    }

    @Override
    public long advanceWrite(long length) {
        long oldWriteIndex = this.writeIndex;
        this.writeIndex = oldWriteIndex + length;
        return oldWriteIndex;
    }

    @Override
    public long advanceRead(long length) {
        long oldReadIndex = this.readIndex;
        this.readIndex = oldReadIndex + length;
        return oldReadIndex;
    }

    @Override
    public long readableBytes() {
        return this.writeIndex - this.readIndex;
    }

    @Override
    public long writableBytes() {
        return this.capacity() - this.writeIndex;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public void readOnly() {
        this.readOnly = true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void resize(long newSize) {
        long newAddress;
        this.assertDummy();
        this.assertReadOnly();
        if (newSize < this.capacity) {
            throw new IllegalArgumentException("New size is smaller than the current size");
        }
        if (newSize == this.capacity) {
            throw new IllegalArgumentException("New size is the same as the current size");
        }
        this.address = newAddress = NetworkBufferUnsafe.UNSAFE.reallocateMemory(this.address, newSize);
        this.capacity = newSize;
        this.state.address.set(newAddress);
    }

    @Override
    public void ensureWritable(long length) {
        this.assertReadOnly();
        if (this.writableBytes() >= length) {
            return;
        }
        long newCapacity = this.newCapacity(length, this.capacity());
        this.resize(newCapacity);
    }

    private long newCapacity(long length, long capacity) {
        long targetSize = this.writeIndex + length;
        NetworkBuffer.AutoResize strategy = this.autoResize;
        if (strategy == null) {
            throw new IndexOutOfBoundsException("Buffer is full and cannot be resized: " + capacity + " -> " + targetSize);
        }
        long newCapacity = strategy.resize(capacity, targetSize);
        if (newCapacity == capacity) {
            throw new IndexOutOfBoundsException("Buffer is full has been resized to the same capacity: " + capacity + " -> " + targetSize);
        }
        return newCapacity;
    }

    @Override
    public void compact() {
        this.assertDummy();
        this.assertReadOnly();
        ByteBuffer nioBuffer = this.bufferSlice((int)this.readIndex, (int)this.readableBytes());
        nioBuffer.compact();
        this.writeIndex -= this.readIndex;
        this.readIndex = 0L;
    }

    @Override
    public NetworkBuffer copy(long index, long length, long readIndex, long writeIndex) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, length, this.capacity);
        long newAddress = NetworkBufferUnsafe.UNSAFE.allocateMemory(length);
        if (newAddress == 0L) {
            throw new OutOfMemoryError("Failed to allocate memory");
        }
        NetworkBufferUnsafe.UNSAFE.copyMemory(this.address + index, newAddress, length);
        return new NetworkBufferImpl(newAddress, length, readIndex, writeIndex, this.autoResize, this.registries);
    }

    @Override
    public int readChannel(ReadableByteChannel channel) throws IOException {
        this.assertDummy();
        this.assertReadOnly();
        NetworkBufferImpl.assertOverflow(this.writeIndex + this.writableBytes());
        ByteBuffer buffer = this.bufferSlice((int)this.writeIndex, (int)this.writableBytes());
        int count = channel.read(buffer);
        if (count == -1) {
            throw new EOFException("Disconnected");
        }
        this.advanceWrite(count);
        return count;
    }

    @Override
    public boolean writeChannel(SocketChannel channel) throws IOException {
        this.assertDummy();
        long readableBytes = this.readableBytes();
        if (readableBytes == 0L) {
            return true;
        }
        NetworkBufferImpl.assertOverflow(this.readIndex + readableBytes);
        ByteBuffer buffer = this.bufferSlice((int)this.readIndex, (int)readableBytes);
        if (!buffer.hasRemaining()) {
            return true;
        }
        int count = channel.write(buffer);
        if (count == -1) {
            throw new EOFException("Disconnected");
        }
        this.advanceRead(count);
        return !buffer.hasRemaining();
    }

    @Override
    public void cipher(Cipher cipher, long start, long length) {
        this.assertDummy();
        NetworkBufferImpl.assertOverflow(start + length);
        ByteBuffer input = this.bufferSlice((int)start, (int)length);
        try {
            cipher.update(input, input.duplicate());
        }
        catch (ShortBufferException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long compress(long start, long length, NetworkBuffer output) {
        this.assertDummy();
        NetworkBufferImpl.impl(output).assertReadOnly();
        NetworkBufferImpl.assertOverflow(start + length);
        ByteBuffer input = this.bufferSlice((int)start, (int)length);
        ByteBuffer outputBuffer = NetworkBufferImpl.impl(output).bufferSlice((int)output.writeIndex(), (int)output.writableBytes());
        Deflater deflater = DEFLATER_POOL.get();
        try {
            deflater.setInput(input);
            deflater.finish();
            int bytes = deflater.deflate(outputBuffer);
            deflater.reset();
            output.advanceWrite(bytes);
            long l = bytes;
            return l;
        }
        finally {
            DEFLATER_POOL.add(deflater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long decompress(long start, long length, NetworkBuffer output) throws DataFormatException {
        this.assertDummy();
        NetworkBufferImpl.impl(output).assertReadOnly();
        NetworkBufferImpl.assertOverflow(start + length);
        ByteBuffer input = this.bufferSlice((int)start, (int)length);
        ByteBuffer outputBuffer = NetworkBufferImpl.impl(output).bufferSlice((int)output.writeIndex(), (int)output.writableBytes());
        Inflater inflater = INFLATER_POOL.get();
        try {
            inflater.setInput(input);
            int bytes = inflater.inflate(outputBuffer);
            inflater.reset();
            output.advanceWrite(bytes);
            long l = bytes;
            return l;
        }
        finally {
            INFLATER_POOL.add(inflater);
        }
    }

    @Override
    @Nullable
    public Registries registries() {
        return this.registries;
    }

    private ByteBuffer bufferSlice(int position, int length) {
        ByteBuffer nioBuffer = this.nioBuffer;
        if (nioBuffer == null) {
            this.nioBuffer = nioBuffer = ByteBuffer.allocateDirect(0).order(ByteOrder.BIG_ENDIAN);
        }
        NetworkBufferUnsafe.updateAddress(nioBuffer, this.address);
        NetworkBufferUnsafe.updateCapacity(nioBuffer, (int)this.capacity);
        nioBuffer.limit(position + length).position(position);
        return nioBuffer;
    }

    public String toString() {
        return String.format("NetworkBuffer{r%d|w%d->%d, registries=%s, autoResize=%s, readOnly=%s}", this.readIndex, this.writeIndex, this.capacity, this.registries != null, this.autoResize != null, this.readOnly);
    }

    private boolean isDummy() {
        return this.address == -1L;
    }

    void _putBytes(long index, byte[] value) {
        if (this.isDummy()) {
            return;
        }
        this.assertReadOnly();
        Objects.checkFromIndexSize(index, (long)value.length, this.capacity);
        NetworkBufferUnsafe.UNSAFE.copyMemory(value, NetworkBufferUnsafe.BYTE_ARRAY_OFFSET, null, this.address + index, value.length);
    }

    void _getBytes(long index, byte[] value) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, (long)value.length, this.capacity);
        NetworkBufferUnsafe.UNSAFE.copyMemory(null, this.address + index, value, NetworkBufferUnsafe.BYTE_ARRAY_OFFSET, value.length);
    }

    void _putByte(long index, byte value) {
        if (this.isDummy()) {
            return;
        }
        this.assertReadOnly();
        Objects.checkFromIndexSize(index, 1L, this.capacity);
        NetworkBufferUnsafe.UNSAFE.putByte(this.address + index, value);
    }

    byte _getByte(long index) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, 1L, this.capacity);
        return NetworkBufferUnsafe.UNSAFE.getByte(this.address + index);
    }

    void _putShort(long index, short value) {
        if (this.isDummy()) {
            return;
        }
        this.assertReadOnly();
        Objects.checkFromIndexSize(index, 2L, this.capacity);
        if (ENDIAN_CONVERSION) {
            value = Short.reverseBytes(value);
        }
        NetworkBufferUnsafe.UNSAFE.putShort(this.address + index, value);
    }

    short _getShort(long index) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, 2L, this.capacity);
        short value = NetworkBufferUnsafe.UNSAFE.getShort(this.address + index);
        return ENDIAN_CONVERSION ? Short.reverseBytes(value) : value;
    }

    void _putInt(long index, int value) {
        if (this.isDummy()) {
            return;
        }
        this.assertReadOnly();
        Objects.checkFromIndexSize(index, 4L, this.capacity);
        if (ENDIAN_CONVERSION) {
            value = Integer.reverseBytes(value);
        }
        NetworkBufferUnsafe.UNSAFE.putInt(this.address + index, value);
    }

    int _getInt(long index) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, 4L, this.capacity);
        int value = NetworkBufferUnsafe.UNSAFE.getInt(this.address + index);
        return ENDIAN_CONVERSION ? Integer.reverseBytes(value) : value;
    }

    void _putLong(long index, long value) {
        if (this.isDummy()) {
            return;
        }
        this.assertReadOnly();
        Objects.checkFromIndexSize(index, 8L, this.capacity);
        if (ENDIAN_CONVERSION) {
            value = Long.reverseBytes(value);
        }
        NetworkBufferUnsafe.UNSAFE.putLong(this.address + index, value);
    }

    long _getLong(long index) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, 8L, this.capacity);
        long value = NetworkBufferUnsafe.UNSAFE.getLong(this.address + index);
        return ENDIAN_CONVERSION ? Long.reverseBytes(value) : value;
    }

    void _putFloat(long index, float value) {
        if (this.isDummy()) {
            return;
        }
        this.assertReadOnly();
        Objects.checkFromIndexSize(index, 4L, this.capacity);
        int intValue = Float.floatToIntBits(value);
        if (ENDIAN_CONVERSION) {
            intValue = Integer.reverseBytes(intValue);
        }
        NetworkBufferUnsafe.UNSAFE.putInt(this.address + index, intValue);
    }

    float _getFloat(long index) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, 4L, this.capacity);
        int intValue = NetworkBufferUnsafe.UNSAFE.getInt(this.address + index);
        if (ENDIAN_CONVERSION) {
            intValue = Integer.reverseBytes(intValue);
        }
        return Float.intBitsToFloat(intValue);
    }

    void _putDouble(long index, double value) {
        if (this.isDummy()) {
            return;
        }
        this.assertReadOnly();
        Objects.checkFromIndexSize(index, 8L, this.capacity);
        long longValue = Double.doubleToLongBits(value);
        if (ENDIAN_CONVERSION) {
            longValue = Long.reverseBytes(longValue);
        }
        NetworkBufferUnsafe.UNSAFE.putLong(this.address + index, longValue);
    }

    double _getDouble(long index) {
        this.assertDummy();
        Objects.checkFromIndexSize(index, 8L, this.capacity);
        long longValue = NetworkBufferUnsafe.UNSAFE.getLong(this.address + index);
        if (ENDIAN_CONVERSION) {
            longValue = Long.reverseBytes(longValue);
        }
        return Double.longBitsToDouble(longValue);
    }

    static NetworkBuffer wrap(byte @NotNull [] bytes, long readIndex, long writeIndex, @Nullable Registries registries) {
        NetworkBuffer buffer = new Builder(bytes.length).registry(registries).build();
        buffer.writeAt(0L, NetworkBuffer.RAW_BYTES, bytes);
        buffer.index(readIndex, writeIndex);
        return buffer;
    }

    static void copy(NetworkBuffer srcBuffer, long srcOffset, NetworkBuffer dstBuffer, long dstOffset, long length) {
        NetworkBufferImpl src = NetworkBufferImpl.impl(srcBuffer);
        NetworkBufferImpl dst = NetworkBufferImpl.impl(dstBuffer);
        dst.assertReadOnly();
        Objects.checkFromIndexSize(srcOffset, length, src.capacity);
        Objects.checkFromIndexSize(dstOffset, length, dst.capacity);
        long srcAddress = src.address + srcOffset;
        long dstAddress = dst.address + dstOffset;
        NetworkBufferUnsafe.UNSAFE.copyMemory(srcAddress, dstAddress, length);
    }

    public static boolean equals(NetworkBuffer buffer1, NetworkBuffer buffer2) {
        NetworkBufferImpl impl1 = NetworkBufferImpl.impl(buffer1);
        NetworkBufferImpl impl2 = NetworkBufferImpl.impl(buffer2);
        int capacity = (int)impl1.capacity;
        if ((long)capacity != impl2.capacity) {
            return false;
        }
        long address1 = impl1.address;
        long address2 = impl2.address;
        for (long i = 0L; i < (long)capacity; ++i) {
            if (NetworkBufferUnsafe.UNSAFE.getByte(address1 + i) == NetworkBufferUnsafe.UNSAFE.getByte(address2 + i)) continue;
            return false;
        }
        return true;
    }

    void assertReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Buffer is read-only");
        }
    }

    void assertDummy() {
        if (this.isDummy()) {
            throw new UnsupportedOperationException("Buffer is a dummy buffer");
        }
    }

    static NetworkBufferImpl dummy(Registries registries) {
        return new NetworkBufferImpl(-1L, Long.MAX_VALUE, 0L, 0L, null, registries);
    }

    static NetworkBufferImpl impl(NetworkBuffer buffer) {
        return (NetworkBufferImpl)buffer;
    }

    private static void assertOverflow(long value) {
        try {
            Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            throw new RuntimeException("Method does not support long values: " + value);
        }
    }

    private record BufferCleaner(AtomicLong address) implements Runnable
    {
        @Override
        public void run() {
            NetworkBufferUnsafe.UNSAFE.freeMemory(this.address.get());
        }
    }

    static final class Builder
    implements NetworkBuffer.Builder {
        private final long initialSize;
        private NetworkBuffer.AutoResize autoResize;
        private Registries registries;

        public Builder(long initialSize) {
            this.initialSize = initialSize;
        }

        @Override
        public @NotNull NetworkBuffer.Builder autoResize(@Nullable NetworkBuffer.AutoResize autoResize) {
            this.autoResize = autoResize;
            return this;
        }

        @Override
        public @NotNull NetworkBuffer.Builder registry(Registries registries) {
            this.registries = registries;
            return this;
        }

        @Override
        @NotNull
        public NetworkBuffer build() {
            long address = NetworkBufferUnsafe.UNSAFE.allocateMemory(this.initialSize);
            return new NetworkBufferImpl(address, this.initialSize, 0L, 0L, this.autoResize, this.registries);
        }
    }
}

