/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.map.framebuffers;

import net.minestom.server.map.Framebuffer;
import net.minestom.server.map.LargeFramebuffer;
import net.minestom.server.map.framebuffers.LargeFramebufferDefaultView;

public class LargeDirectFramebuffer
implements LargeFramebuffer {
    private final int width;
    private final int height;
    private final byte[] colors;

    public LargeDirectFramebuffer(int width, int height) {
        this.width = width;
        this.height = height;
        this.colors = new byte[width * height];
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public Framebuffer createSubView(int left, int top) {
        return new LargeFramebufferDefaultView(this, left, top);
    }

    public LargeDirectFramebuffer setMapColor(int x, int y, byte color) {
        if (!this.bounds(x, y)) {
            throw new IndexOutOfBoundsException("Invalid x;y coordinate: " + x + ";" + y);
        }
        this.colors[y * this.width + x] = color;
        return this;
    }

    @Override
    public byte getMapColor(int x, int y) {
        if (!this.bounds(x, y)) {
            throw new IndexOutOfBoundsException("Invalid x;y coordinate: " + x + ";" + y);
        }
        return this.colors[y * this.width + x];
    }

    private boolean bounds(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public byte[] getColors() {
        return this.colors;
    }
}

