/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.UnaryOperator;
import net.minestom.server.Viewable;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryItemChangeEvent;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.InventoryClickHandler;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.TransactionOption;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.inventory.click.InventoryClickProcessor;
import net.minestom.server.inventory.condition.InventoryCondition;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.CloseWindowPacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public abstract sealed class AbstractInventory
implements InventoryClickHandler,
Taggable,
Viewable
permits Inventory, PlayerInventory {
    private static final VarHandle ITEM_UPDATER = MethodHandles.arrayElementVarHandle(ItemStack[].class);
    private final int size;
    protected final ItemStack[] itemStacks;
    protected final List<InventoryCondition> inventoryConditions = new CopyOnWriteArrayList<InventoryCondition>();
    protected final InventoryClickProcessor clickProcessor = new InventoryClickProcessor();
    private final TagHandler tagHandler = TagHandler.newHandler();
    protected final Set<Player> viewers = new CopyOnWriteArraySet<Player>();
    protected final Set<Player> unmodifiableViewers = Collections.unmodifiableSet(this.viewers);

    protected AbstractInventory(int size) {
        this.size = size;
        this.itemStacks = new ItemStack[this.getSize()];
        Arrays.fill(this.itemStacks, ItemStack.AIR);
    }

    public abstract byte getWindowId();

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.unmodifiableViewers;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        if (!this.viewers.add(player)) {
            return false;
        }
        this.update(player);
        return true;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        if (!this.viewers.remove(player)) {
            return false;
        }
        ItemStack cursorItem = player.getInventory().getCursorItem();
        player.getInventory().setCursorItem(ItemStack.AIR);
        if (!cursorItem.isAir() && !player.dropItem(cursorItem)) {
            player.getInventory().addItemStack(cursorItem);
        }
        if (player.didCloseInventory()) {
            player.sendPacket(new CloseWindowPacket(this.getWindowId()));
        }
        return true;
    }

    public void setItemStack(int slot, @NotNull ItemStack itemStack) {
        this.setItemStack(slot, itemStack, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemStack(int slot, @NotNull ItemStack itemStack, boolean sendPacket) {
        ItemStack previous;
        Check.argCondition(!MathUtils.isBetween(slot, 0, this.getSize() - 1), "Inventory does not have the slot " + slot);
        AbstractInventory abstractInventory = this;
        synchronized (abstractInventory) {
            previous = this.itemStacks[slot];
            if (itemStack.equals(previous)) {
                return;
            }
            this.UNSAFE_itemInsert(slot, itemStack, previous, sendPacket);
        }
        EventDispatcher.call(new InventoryItemChangeEvent(this, slot, previous, itemStack));
    }

    protected void UNSAFE_itemInsert(int slot, @NotNull ItemStack item, @NotNull ItemStack previous, boolean sendPacket) {
        this.itemStacks[slot] = item;
        if (sendPacket) {
            this.sendSlotRefresh(slot, item, previous);
        }
    }

    public void sendSlotRefresh(int slot, @NotNull ItemStack item, @NotNull ItemStack previous) {
        this.sendPacketToViewers(new SetSlotPacket(this.getWindowId(), 0, (short)slot, item));
    }

    @NotNull
    public synchronized <T> T processItemStack(@NotNull ItemStack itemStack, @NotNull TransactionType type, @NotNull TransactionOption<T> option) {
        return option.fill(type, this, itemStack);
    }

    @NotNull
    public synchronized <T> @NotNull List<@NotNull T> processItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionType type, @NotNull TransactionOption<T> option) {
        ArrayList result = new ArrayList(itemStacks.size());
        itemStacks.forEach(itemStack -> {
            Object transactionResult = this.processItemStack((ItemStack)itemStack, type, option);
            result.add(transactionResult);
        });
        return result;
    }

    @NotNull
    public <T> T addItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        return this.processItemStack(itemStack, TransactionType.ADD, option);
    }

    public boolean addItemStack(@NotNull ItemStack itemStack) {
        return this.addItemStack(itemStack, TransactionOption.ALL_OR_NOTHING);
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> addItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionOption<T> option) {
        return this.processItemStacks(itemStacks, TransactionType.ADD, option);
    }

    @NotNull
    public <T> T takeItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        return this.processItemStack(itemStack, TransactionType.TAKE, option);
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> takeItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionOption<T> option) {
        return this.processItemStacks(itemStacks, TransactionType.TAKE, option);
    }

    public synchronized void replaceItemStack(int slot, @NotNull @NotNull UnaryOperator<@NotNull ItemStack> operator) {
        ItemStack currentItem = this.getItemStack(slot);
        this.setItemStack(slot, (ItemStack)operator.apply(currentItem));
    }

    public synchronized void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.setItemStack(i, ItemStack.AIR, false);
        }
        this.update();
    }

    public void update() {
        this.viewers.forEach(this::update);
    }

    public void update(@NotNull Player player) {
        player.sendPacket(new WindowItemsPacket(this.getWindowId(), 0, List.of(this.itemStacks), player.getInventory().getCursorItem()));
    }

    @NotNull
    public ItemStack getItemStack(int slot) {
        return ITEM_UPDATER.getVolatile(this.itemStacks, slot);
    }

    @NotNull
    public ItemStack[] getItemStacks() {
        return (ItemStack[])this.itemStacks.clone();
    }

    public int getSize() {
        return this.size;
    }

    public int getInnerSize() {
        return this.getSize();
    }

    @NotNull
    public @NotNull List<@NotNull InventoryCondition> getInventoryConditions() {
        return this.inventoryConditions;
    }

    public void addInventoryCondition(@NotNull InventoryCondition inventoryCondition) {
        this.inventoryConditions.add(inventoryCondition);
    }

    public void copyContents(@NotNull ItemStack[] itemStacks) {
        Check.argCondition(itemStacks.length != this.getSize(), "The size of the array has to be of the same size as the inventory: " + this.getSize());
        for (int i = 0; i < itemStacks.length; ++i) {
            ItemStack itemStack = itemStacks[i];
            Check.notNull(itemStack, "The item array cannot contain any null element!");
            this.setItemStack(i, itemStack);
        }
    }

    @Override
    @NotNull
    public TagHandler tagHandler() {
        return this.tagHandler;
    }
}

