/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.predicate;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.gamedata.tags.TagManager;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public sealed interface BlockTypeFilter
extends Predicate<Block> {
    public static final NetworkBuffer.Type<BlockTypeFilter> NETWORK_TYPE = new NetworkBuffer.Type<BlockTypeFilter>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, BlockTypeFilter value) {
            BlockTypeFilter blockTypeFilter = value;
            Objects.requireNonNull(blockTypeFilter);
            BlockTypeFilter blockTypeFilter2 = blockTypeFilter;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Blocks.class, Tag.class}, (Object)blockTypeFilter2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Blocks blocks = (Blocks)blockTypeFilter2;
                    buffer.write(NetworkBuffer.VAR_INT, blocks.blocks.size() + 1);
                    for (Block block : blocks.blocks) {
                        buffer.write(NetworkBuffer.VAR_INT, block.id());
                    }
                    break;
                }
                case 1: {
                    Tag tag = (Tag)blockTypeFilter2;
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    buffer.write(NetworkBuffer.STRING, tag.tag.name());
                }
            }
        }

        @Override
        public BlockTypeFilter read(@NotNull NetworkBuffer buffer) {
            int count = buffer.read(NetworkBuffer.VAR_INT) - 1;
            if (count == -1) {
                return new Tag(buffer.read(NetworkBuffer.STRING));
            }
            ArrayList<Block> blocks = new ArrayList<Block>(count);
            for (int i = 0; i < count; ++i) {
                blocks.add(Block.fromBlockId(buffer.read(NetworkBuffer.VAR_INT)));
            }
            return new Blocks(blocks);
        }
    };
    public static final BinaryTagSerializer<BlockTypeFilter> NBT_TYPE = new BinaryTagSerializer<BlockTypeFilter>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull BlockTypeFilter value) {
            BlockTypeFilter blockTypeFilter = value;
            Objects.requireNonNull(blockTypeFilter);
            BlockTypeFilter blockTypeFilter2 = blockTypeFilter;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Blocks.class, Tag.class}, (Object)blockTypeFilter2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Blocks blocks = (Blocks)blockTypeFilter2;
                    if (blocks.blocks.size() == 1) {
                        yield StringBinaryTag.stringBinaryTag((String)blocks.blocks.get(0).name());
                    }
                    ListBinaryTag.Builder builder = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.STRING);
                    for (Block block : blocks.blocks) {
                        builder.add((BinaryTag)StringBinaryTag.stringBinaryTag((String)block.name()));
                    }
                    yield builder.build();
                }
                case 1 -> {
                    Tag tag = (Tag)blockTypeFilter2;
                    yield StringBinaryTag.stringBinaryTag((String)("#" + tag.tag.name()));
                }
            };
        }

        @Override
        @NotNull
        public BlockTypeFilter read(@NotNull BinaryTag tag) {
            BinaryTag binaryTag = tag;
            Objects.requireNonNull(binaryTag);
            BinaryTag binaryTag2 = binaryTag;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListBinaryTag.class, StringBinaryTag.class}, (Object)binaryTag2, n)) {
                case 0 -> {
                    ListBinaryTag list = (ListBinaryTag)binaryTag2;
                    ArrayList<Block> blocks = new ArrayList<Block>(list.size());
                    for (BinaryTag binaryTag : list) {
                        if (!(binaryTag instanceof StringBinaryTag)) continue;
                        StringBinaryTag string = (StringBinaryTag)binaryTag;
                        blocks.add(Objects.requireNonNull(Block.fromNamespaceId(string.value())));
                    }
                    yield new Blocks(blocks);
                }
                case 1 -> {
                    StringBinaryTag string = (StringBinaryTag)binaryTag2;
                    String value = string.value();
                    if (value.startsWith("#")) {
                        yield new Tag(value.substring(1));
                    }
                    yield new Blocks(Objects.requireNonNull(Block.fromNamespaceId(value)));
                }
                default -> throw new IllegalArgumentException("Invalid tag type: " + String.valueOf(tag.type()));
            };
        }
    };

    public record Tag(@NotNull net.minestom.server.gamedata.tags.Tag tag) implements BlockTypeFilter
    {
        private static final TagManager TAG_MANAGER = Objects.requireNonNull(MinecraftServer.getTagManager());

        public Tag(@NotNull String namespaceId) {
            this(Objects.requireNonNull(TAG_MANAGER.getTag(Tag.BasicType.BLOCKS, namespaceId), "No such block tag: " + namespaceId));
        }

        @Override
        public boolean test(Block block) {
            return this.tag.contains(block.namespace());
        }
    }

    public record Blocks(@NotNull List<Block> blocks) implements BlockTypeFilter
    {
        public Blocks(@NotNull List<Block> blocks) {
            blocks = List.copyOf(blocks);
        }

        public Blocks(Block ... blocks) {
            this(List.of(blocks));
        }

        @Override
        public boolean test(@NotNull Block block) {
            int blockId = block.id();
            for (Block b : this.blocks) {
                if (blockId != b.id()) continue;
                return true;
            }
            return false;
        }
    }
}

