/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.banner;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BannerPatternImpl
extends Record
implements BannerPattern {
    @NotNull
    private final NamespaceID assetId;
    @NotNull
    private final String translationKey;
    @Nullable
    private final Registry.BannerPatternEntry registry;
    static final BinaryTagSerializer<BannerPattern> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        throw new UnsupportedOperationException("BannerPattern is read-only");
    }, bannerPattern -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", bannerPattern.assetId().asString())).putString("translation_key", bannerPattern.translationKey())).build());

    BannerPatternImpl(@NotNull NamespaceID assetId, @NotNull String translationKey, @Nullable Registry.BannerPatternEntry registry) {
        Check.argCondition(assetId == null, "missing asset id");
        Check.argCondition(translationKey == null || translationKey.isEmpty(), "missing translation key");
        this.assetId = assetId;
        this.translationKey = translationKey;
        this.registry = registry;
    }

    BannerPatternImpl(@NotNull Registry.BannerPatternEntry registry) {
        this(registry.assetId(), registry.translationKey(), registry);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BannerPatternImpl.class, "assetId;translationKey;registry", "assetId", "translationKey", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BannerPatternImpl.class, "assetId;translationKey;registry", "assetId", "translationKey", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BannerPatternImpl.class, "assetId;translationKey;registry", "assetId", "translationKey", "registry"}, this, o);
    }

    @Override
    @NotNull
    public NamespaceID assetId() {
        return this.assetId;
    }

    @Override
    @NotNull
    public String translationKey() {
        return this.translationKey;
    }

    @Override
    @Nullable
    public Registry.BannerPatternEntry registry() {
        return this.registry;
    }
}

