/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.gamedata.tags;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.entity.EntityType;
import net.minestom.server.game.GameEvent;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.Material;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.FluidRegistries;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Tag
implements ProtocolObject,
Keyed {
    private final NamespaceID name;
    private final Set<NamespaceID> values;

    public Tag(@NotNull NamespaceID name) {
        this.name = name;
        this.values = new HashSet<NamespaceID>();
    }

    public Tag(@NotNull NamespaceID name, @NotNull Set<NamespaceID> values) {
        this.name = name;
        this.values = new HashSet<NamespaceID>(values);
    }

    public boolean contains(@NotNull NamespaceID id) {
        return this.values.contains(id);
    }

    @NotNull
    public Set<NamespaceID> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    @NotNull
    public NamespaceID namespace() {
        return this.name;
    }

    @Contract(pure=true)
    @NotNull
    public String name() {
        return this.namespace().asString();
    }

    @Contract(pure=true)
    @NotNull
    public Key key() {
        return this.namespace();
    }

    @Deprecated
    public NamespaceID getName() {
        return this.name;
    }

    public String toString() {
        return "#" + this.name.asString();
    }

    public static enum BasicType {
        BLOCKS("minecraft:block", Registry.Resource.BLOCK_TAGS, (blockName, registries) -> Optional.ofNullable(Block.fromNamespaceId(blockName)).map(Block::id)),
        ITEMS("minecraft:item", Registry.Resource.ITEM_TAGS, (itemName, registries) -> Optional.ofNullable(Material.fromNamespaceId(itemName)).map(Material::id)),
        FLUIDS("minecraft:fluid", Registry.Resource.FLUID_TAGS, (name, registries) -> Optional.of(name).map(FluidRegistries::getFluid).map(Enum::ordinal)),
        ENTITY_TYPES("minecraft:entity_type", Registry.Resource.ENTITY_TYPE_TAGS, (entityName, registries) -> Optional.ofNullable(EntityType.fromNamespaceId(entityName)).map(EntityType::id)),
        GAME_EVENTS("minecraft:game_event", Registry.Resource.GAMEPLAY_TAGS, (eventName, registries) -> Optional.ofNullable(GameEvent.fromNamespaceId(eventName)).map(StaticProtocolObject::id)),
        SOUND_EVENTS("minecraft:sound_event", null, null),
        POTION_EFFECTS("minecraft:potion_effect", null, null),
        ENCHANTMENTS("minecraft:enchantment", Registry.Resource.ENCHANTMENT_TAGS, (name, registries) -> Optional.of(DynamicRegistry.Key.of(name)).map(DynamicRegistry.Key::namespace).map(registries.enchantment()::getId)),
        BIOMES("minecraft:worldgen/biome", Registry.Resource.BIOME_TAGS, (name, registries) -> Optional.of(DynamicRegistry.Key.of(name)).map(DynamicRegistry.Key::namespace).map(registries.biome()::getId));

        private static final BasicType[] VALUES;
        private final String identifier;
        private final Registry.Resource resource;
        private final BiFunction<String, Registries, Optional<Integer>> function;

        private BasicType(@Nullable String identifier, Registry.Resource resource, BiFunction<String, Registries, Optional<Integer>> function) {
            this.identifier = identifier;
            this.resource = resource;
            this.function = function;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        public Registry.Resource getResource() {
            return this.resource;
        }

        public BiFunction<String, Registries, Optional<Integer>> getFunction() {
            return this.function;
        }

        @Nullable
        public static BasicType fromIdentifer(@NotNull String identifier) {
            for (BasicType value : VALUES) {
                if (!value.identifier.equals(identifier)) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = BasicType.values();
        }
    }
}

