/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.util.function.Function;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.event.Event;
import net.minestom.server.event.trait.BlockEvent;
import net.minestom.server.event.trait.EntityEvent;
import net.minestom.server.event.trait.InstanceEvent;
import net.minestom.server.event.trait.InventoryEvent;
import net.minestom.server.event.trait.ItemEvent;
import net.minestom.server.event.trait.PlayerEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EventFilter<E extends Event, H> {
    public static final EventFilter<Event, ?> ALL = EventFilter.from(Event.class, null, null);
    public static final EventFilter<EntityEvent, Entity> ENTITY = EventFilter.from(EntityEvent.class, Entity.class, EntityEvent::getEntity);
    public static final EventFilter<PlayerEvent, Player> PLAYER = EventFilter.from(PlayerEvent.class, Player.class, PlayerEvent::getPlayer);
    public static final EventFilter<ItemEvent, ItemStack> ITEM = EventFilter.from(ItemEvent.class, ItemStack.class, ItemEvent::getItemStack);
    public static final EventFilter<InstanceEvent, Instance> INSTANCE = EventFilter.from(InstanceEvent.class, Instance.class, InstanceEvent::getInstance);
    public static final EventFilter<InventoryEvent, AbstractInventory> INVENTORY = EventFilter.from(InventoryEvent.class, AbstractInventory.class, InventoryEvent::getInventory);
    public static final EventFilter<BlockEvent, Block> BLOCK = EventFilter.from(BlockEvent.class, Block.class, BlockEvent::getBlock);

    public static <E extends Event, H> EventFilter<E, H> from(final @NotNull Class<E> eventType, final @Nullable Class<H> handlerType, final @Nullable Function<E, H> handlerGetter) {
        return new EventFilter<E, H>(){

            @Override
            @Nullable
            public H getHandler(@NotNull E event) {
                return handlerGetter != null ? (Object)handlerGetter.apply(event) : null;
            }

            @Override
            @NotNull
            public Class<E> eventType() {
                return eventType;
            }

            @Override
            @Nullable
            public Class<H> handlerType() {
                return handlerType;
            }
        };
    }

    @Nullable
    public H getHandler(@NotNull E var1);

    @ApiStatus.Internal
    @Nullable
    default public H castHandler(@NotNull Object event) {
        return this.getHandler((Event)event);
    }

    @NotNull
    public Class<E> eventType();

    @Nullable
    public Class<H> handlerType();
}

