/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding;

import net.minestom.server.coordinate.Point;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PNode {
    private double g;
    private double h;
    private PNode parent;
    private double pointX;
    private double pointY;
    private double pointZ;
    private int hashCode;
    private Type type;

    public PNode(double px, double py, double pz, double g, double h, @Nullable PNode parent) {
        this(px, py, pz, g, h, Type.WALK, parent);
    }

    public PNode(double px, double py, double pz, double g, double h, @NotNull Type type, @Nullable PNode parent) {
        this.g = g;
        this.h = h;
        this.parent = parent;
        this.type = type;
        this.pointX = px;
        this.pointY = py;
        this.pointZ = pz;
        this.hashCode = PNode.cantor((int)Math.floor(px), PNode.cantor((int)Math.floor(py), (int)Math.floor(pz)));
    }

    public PNode(Point point, double g, double h, Type walk, @Nullable PNode parent) {
        this(point.x(), point.y(), point.z(), g, h, walk, parent);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PNode)) {
            return false;
        }
        PNode other = (PNode)obj;
        return this.hashCode == other.hashCode;
    }

    public String toString() {
        return "PNode{point=" + this.pointX + ", " + this.pointY + ", " + this.pointZ + ", d=" + (this.g + this.h) + ", type=" + String.valueOf((Object)this.type) + "}";
    }

    @ApiStatus.Internal
    public double x() {
        return this.pointX;
    }

    @ApiStatus.Internal
    public double y() {
        return this.pointY;
    }

    @ApiStatus.Internal
    public double z() {
        return this.pointZ;
    }

    public int blockX() {
        return (int)Math.floor(this.pointX);
    }

    public int blockY() {
        return (int)Math.floor(this.pointY);
    }

    public int blockZ() {
        return (int)Math.floor(this.pointZ);
    }

    @ApiStatus.Internal
    @NotNull
    public Type getType() {
        return this.type;
    }

    @ApiStatus.Internal
    public double g() {
        return this.g;
    }

    @ApiStatus.Internal
    public double h() {
        return this.h;
    }

    @ApiStatus.Internal
    public void setG(double v) {
        this.g = v;
    }

    @ApiStatus.Internal
    public void setH(double heuristic) {
        this.h = heuristic;
    }

    @ApiStatus.Internal
    public void setType(@NotNull Type newType) {
        this.type = newType;
    }

    @ApiStatus.Internal
    public void setPoint(double px, double py, double pz) {
        this.pointX = px;
        this.pointY = py;
        this.pointZ = pz;
        this.hashCode = PNode.cantor((int)Math.floor(px), PNode.cantor((int)Math.floor(py), (int)Math.floor(pz)));
    }

    @ApiStatus.Internal
    @Nullable
    public PNode parent() {
        return this.parent;
    }

    @ApiStatus.Internal
    public void setParent(@Nullable PNode current) {
        this.parent = current;
    }

    private static int cantor(int a, int b) {
        int ca = a >= 0 ? 2 * a : -2 * a - 1;
        int cb = b >= 0 ? 2 * b : -2 * b - 1;
        return (ca + cb + 1) * (ca + cb) / 2 + cb;
    }

    public static enum Type {
        WALK,
        JUMP,
        FALL,
        CLIMB,
        CLIMB_WALL,
        SWIM,
        FLY,
        REPATH;

    }
}

