/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityPose;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMeta {
    private final WeakReference<Entity> entityRef;
    protected final MetadataHolder metadata;

    public EntityMeta(@Nullable Entity entity, @NotNull MetadataHolder metadata) {
        this.entityRef = new WeakReference<Entity>(entity);
        this.metadata = metadata;
    }

    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        this.metadata.setNotifyAboutChanges(notifyAboutChanges);
    }

    public boolean isOnFire() {
        return this.metadata.get(MetadataDef.IS_ON_FIRE);
    }

    public void setOnFire(boolean value) {
        this.metadata.set(MetadataDef.IS_ON_FIRE, value);
    }

    public boolean isSneaking() {
        return this.metadata.get(MetadataDef.IS_CROUCHING);
    }

    public void setSneaking(boolean value) {
        this.metadata.set(MetadataDef.IS_CROUCHING, value);
    }

    public boolean isSprinting() {
        return this.metadata.get(MetadataDef.IS_SPRINTING);
    }

    public void setSprinting(boolean value) {
        this.metadata.set(MetadataDef.IS_SPRINTING, value);
    }

    public boolean isSwimming() {
        return this.metadata.get(MetadataDef.IS_SWIMMING);
    }

    public void setSwimming(boolean value) {
        this.metadata.set(MetadataDef.IS_SWIMMING, value);
    }

    public boolean isInvisible() {
        return this.metadata.get(MetadataDef.IS_INVISIBLE);
    }

    public void setInvisible(boolean value) {
        this.metadata.set(MetadataDef.IS_INVISIBLE, value);
    }

    public boolean isHasGlowingEffect() {
        return this.metadata.get(MetadataDef.HAS_GLOWING_EFFECT);
    }

    public void setHasGlowingEffect(boolean value) {
        this.metadata.set(MetadataDef.HAS_GLOWING_EFFECT, value);
    }

    public boolean isFlyingWithElytra() {
        return this.metadata.get(MetadataDef.IS_FLYING_WITH_ELYTRA);
    }

    public void setFlyingWithElytra(boolean value) {
        this.metadata.set(MetadataDef.IS_FLYING_WITH_ELYTRA, value);
    }

    public int getAirTicks() {
        return this.metadata.get(MetadataDef.AIR_TICKS);
    }

    public void setAirTicks(int value) {
        this.metadata.set(MetadataDef.AIR_TICKS, value);
    }

    @Nullable
    public Component getCustomName() {
        return this.metadata.get(MetadataDef.CUSTOM_NAME);
    }

    public void setCustomName(@Nullable Component value) {
        this.metadata.set(MetadataDef.CUSTOM_NAME, value);
    }

    public boolean isCustomNameVisible() {
        return this.metadata.get(MetadataDef.CUSTOM_NAME_VISIBLE);
    }

    public void setCustomNameVisible(boolean value) {
        this.metadata.set(MetadataDef.CUSTOM_NAME_VISIBLE, value);
    }

    public boolean isSilent() {
        return this.metadata.get(MetadataDef.IS_SILENT);
    }

    public void setSilent(boolean value) {
        this.metadata.set(MetadataDef.IS_SILENT, value);
    }

    public boolean isHasNoGravity() {
        return this.metadata.get(MetadataDef.HAS_NO_GRAVITY);
    }

    public void setHasNoGravity(boolean value) {
        this.metadata.set(MetadataDef.HAS_NO_GRAVITY, value);
    }

    @NotNull
    public EntityPose getPose() {
        return this.metadata.get(MetadataDef.POSE);
    }

    public void setPose(@NotNull EntityPose value) {
        this.metadata.set(MetadataDef.POSE, value);
    }

    public int getTickFrozen() {
        return this.metadata.get(MetadataDef.TICKS_FROZEN);
    }

    public void setTickFrozen(int tickFrozen) {
        this.metadata.set(MetadataDef.TICKS_FROZEN, tickFrozen);
    }

    protected void consumeEntity(Consumer<Entity> consumer) {
        Entity entity = (Entity)this.entityRef.get();
        if (entity != null) {
            consumer.accept(entity);
        }
    }
}

