/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataDef;

final class MetadataDefImpl {
    static final Map<String, Integer> MAX_INDEX = new HashMap<String, Integer>();

    MetadataDefImpl() {
    }

    static <T> MetadataDef.Entry.Index<T> index(int index, Function<T, Metadata.Entry<T>> function, T defaultValue) {
        String caller = MetadataDefImpl.caller();
        MetadataDefImpl.storeMaxIndex(caller, index);
        int superIndex = MetadataDefImpl.findSuperIndex(caller);
        return new MetadataDef.Entry.Index<T>(superIndex + index, function, defaultValue);
    }

    static MetadataDef.Entry.BitMask bitMask(int index, byte bitMask, boolean defaultValue) {
        String caller = MetadataDefImpl.caller();
        MetadataDefImpl.storeMaxIndex(caller, index);
        int superIndex = MetadataDefImpl.findSuperIndex(caller);
        return new MetadataDef.Entry.BitMask(superIndex + index, bitMask, defaultValue);
    }

    static MetadataDef.Entry.ByteMask byteMask(int index, byte byteMask, int offset, byte defaultValue) {
        String caller = MetadataDefImpl.caller();
        MetadataDefImpl.storeMaxIndex(caller, index);
        int superIndex = MetadataDefImpl.findSuperIndex(caller);
        return new MetadataDef.Entry.ByteMask(superIndex + index, byteMask, offset, defaultValue);
    }

    static <T extends MetadataDef> int count(Class<T> clazz) {
        String name = clazz.getName();
        try {
            Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        int classIndex = MAX_INDEX.get(name);
        int superIndex = MetadataDefImpl.findSuperIndex(name);
        return classIndex + superIndex + 1;
    }

    private static String caller() {
        return Thread.currentThread().getStackTrace()[3].getClassName();
    }

    static void storeMaxIndex(String caller, int index) {
        int currentMax = MAX_INDEX.getOrDefault(caller, 0);
        MAX_INDEX.put(caller, Math.max(currentMax, index));
    }

    static int findSuperIndex(String caller) {
        try {
            Class<?> subclass = Class.forName(caller);
            Class<?> superclass = subclass.getSuperclass();
            if (superclass == Object.class) {
                return 0;
            }
            int index = 0;
            do {
                index += MAX_INDEX.get(superclass.getName()) + 1;
            } while ((superclass = superclass.getSuperclass()) != Object.class);
            return index;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

