/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import org.jetbrains.annotations.NotNull;

public final class CoordConversion {
    public static int globalToBlock(double xyz) {
        return (int)Math.floor(xyz);
    }

    public static int globalToChunk(double xz) {
        int block = CoordConversion.globalToBlock(xz);
        return CoordConversion.globalToChunk(block);
    }

    public static int globalToChunk(int xz) {
        return xz >> 4;
    }

    public static int globalToSectionRelative(int xyz) {
        return xyz & 0xF;
    }

    public static int chunkToRegion(int chunkCoordinate) {
        return chunkCoordinate >> 5;
    }

    public static int chunkToRegionLocal(int chunkCoordinate) {
        return chunkCoordinate & 0x1F;
    }

    public static int floorSection(int coordinate) {
        return coordinate - (coordinate & 0xF);
    }

    public static int ceilSection(int coordinate) {
        return (coordinate - 1 | 0xF) + 1;
    }

    public static long chunkIndex(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    public static long chunkIndex(@NotNull Point point) {
        return CoordConversion.chunkIndex(point.chunkX(), point.chunkZ());
    }

    public static int chunkIndexGetX(long index) {
        return (int)(index >> 32);
    }

    public static int chunkIndexGetZ(long index) {
        return (int)index;
    }

    public static int chunkBlockIndex(int x, int y, int z) {
        x = CoordConversion.globalToSectionRelative(x);
        z = CoordConversion.globalToSectionRelative(z);
        int index = x & 0xF;
        if (y > 0) {
            index |= y << 4 & 0x7FFFFF0;
        } else {
            index |= -y << 4 & 0x7FFFFF0;
            index |= 0x8000000;
        }
        return index |= z << 28 & 0xF0000000;
    }

    public static int chunkBlockIndexGetX(int index) {
        return index & 0xF;
    }

    public static int chunkBlockIndexGetY(int index) {
        int y = (index & 0x7FFFFF0) >>> 4;
        if ((index >>> 27 & 1) == 1) {
            y = -y;
        }
        return y;
    }

    public static int chunkBlockIndexGetZ(int index) {
        return index >> 28 & 0xF;
    }

    @NotNull
    public static Point chunkBlockIndexGetGlobal(int index, int chunkX, int chunkZ) {
        int x = CoordConversion.chunkBlockIndexGetX(index) + 16 * chunkX;
        int y = CoordConversion.chunkBlockIndexGetY(index);
        int z = CoordConversion.chunkBlockIndexGetZ(index) + 16 * chunkZ;
        return new Vec(x, y, z);
    }
}

