/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.audience.AudienceProvider;
import net.minestom.server.adventure.audience.AudienceRegistry;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.adventure.audience.SingleAudienceProvider;
import net.minestom.server.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Audiences {
    private static final SingleAudienceProvider audience = new SingleAudienceProvider();

    @NotNull
    public static AudienceProvider<Audience> single() {
        return audience;
    }

    @NotNull
    public static AudienceProvider<Iterable<? extends Audience>> iterable() {
        return Audiences.audience.collection;
    }

    @NotNull
    public static Audience all() {
        return Audience.audience((Audience[])new Audience[]{Audiences.audience.server, audience.customs()});
    }

    @NotNull
    public static Audience players() {
        return Audiences.audience.players;
    }

    @NotNull
    public static Audience players(@NotNull Predicate<Player> filter) {
        return PacketGroupingAudience.of(MinecraftServer.getConnectionManager().getOnlinePlayers().stream().filter(filter).toList());
    }

    @NotNull
    public static Audience console() {
        return MinecraftServer.getCommandManager().getConsoleSender();
    }

    @NotNull
    public static Audience server() {
        return Audiences.audience.server;
    }

    @NotNull
    public static Audience customs() {
        return Audience.audience((Iterable)audience.iterable().customs());
    }

    @NotNull
    public static Audience custom(@NotNull Keyed keyed) {
        return Audiences.custom(keyed.key());
    }

    @NotNull
    public static Audience custom(@NotNull Key key) {
        return Audience.audience((Iterable)audience.iterable().custom(key));
    }

    @NotNull
    public static Audience custom(@NotNull Keyed keyed, Predicate<Audience> filter) {
        return Audiences.custom(keyed.key(), filter);
    }

    @NotNull
    public static Audience custom(@NotNull Key key, Predicate<Audience> filter) {
        return Audience.audience((Iterable)audience.iterable().custom(key, (Predicate)filter));
    }

    @NotNull
    public static Audience customs(@NotNull Predicate<Audience> filter) {
        return Audience.audience((Iterable)audience.iterable().customs((Predicate)filter));
    }

    @NotNull
    public static Audience all(@NotNull Predicate<Audience> filter) {
        return Audience.audience((Iterable)audience.iterable().all((Predicate)filter));
    }

    @NotNull
    public static AudienceRegistry registry() {
        return audience.iterable().registry();
    }
}

