/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.async;

import java.util.concurrent.CompletableFuture;
import net.minestom.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AsyncUtils {
    public static final CompletableFuture<Void> VOID_FUTURE = CompletableFuture.completedFuture(null);

    public static <T> CompletableFuture<T> empty() {
        return VOID_FUTURE;
    }

    @NotNull
    public static CompletableFuture<Void> runAsync(@NotNull Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
        });
    }
}

