/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.scoreboard;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.play.ScoreboardObjectivePacket;
import net.minestom.server.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

public class BelowNameTag
implements Scoreboard {
    public static final String BELOW_NAME_TAG_PREFIX = "bnt-";
    private final Set<Player> viewers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> unmodifiableViewers = Collections.unmodifiableSet(this.viewers);
    private final String objectiveName;
    private final ScoreboardObjectivePacket scoreboardObjectivePacket;

    @Deprecated
    public BelowNameTag(String name, String value) {
        this(name, (Component)Component.text((String)value));
    }

    public BelowNameTag(String name, Component value) {
        this.objectiveName = BELOW_NAME_TAG_PREFIX + name;
        this.scoreboardObjectivePacket = this.getCreationObjectivePacket(value, ScoreboardObjectivePacket.Type.INTEGER);
    }

    @Override
    @NotNull
    public String getObjectiveName() {
        return this.objectiveName;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        boolean result = this.viewers.add(player);
        if (result) {
            player.sendPacket(this.scoreboardObjectivePacket);
            player.sendPacket(this.getDisplayScoreboardPacket((byte)2));
            player.setBelowNameTag(this);
        }
        return result;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        boolean result = this.viewers.remove(player);
        if (result) {
            player.sendPacket(this.getDestructionObjectivePacket());
            player.setBelowNameTag(null);
        }
        return result;
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.unmodifiableViewers;
    }
}

