/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.entity.attribute.AttributeInstance;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntityAttributesPacket(int entityId, List<AttributeInstance> attributes) implements ServerPacket.Play
{
    public static final int MAX_ENTRIES = 1024;

    public EntityAttributesPacket {
        attributes = List.copyOf(attributes);
    }

    public EntityAttributesPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readCollection(AttributeInstance.NETWORK_TYPE, 1024));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.writeCollection(AttributeInstance.NETWORK_TYPE, this.attributes);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.ENTITY_ATTRIBUTES;
    }
}

